/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.awt.EventQueue;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import jgnash.engine.CommodityNode;
import jgnash.ui.components.JTextFieldEx;

public class JFloatField
extends JTextFieldEx {
    private static final String FLOAT;
    private static final String MATH_OPERATORS = "()+*/";
    private int scale = 2;
    private static char group;
    private static char fraction;
    private final NumberFormat format;
    private volatile boolean keypad = false;
    private static final boolean DEBUG = false;
    private static final ScriptEngine jsEngine;

    public JFloatField() {
        this(0, 2, 2);
    }

    public JFloatField(CommodityNode node) {
        this(0, node.getScale(), (int)node.getScale());
    }

    public JFloatField(int columns, int maxScale, int minScale) {
        super(columns);
        this.scale = maxScale;
        this.addFocusListener(new EvalFocusListener());
        this.addKeyListener(new KeyPadListener());
        this.format = NumberFormat.getInstance();
        if (this.format instanceof DecimalFormat) {
            this.format.setMaximumFractionDigits(maxScale);
            this.format.setMinimumFractionDigits(minScale);
        }
        this.format.setGroupingUsed(false);
    }

    public void setScale(CommodityNode node) {
        this.setScale(node.getScale(), node.getScale());
    }

    void setScale(int maxScale, int minScale) {
        this.scale = maxScale;
        if (this.format instanceof DecimalFormat) {
            this.format.setMaximumFractionDigits(maxScale);
            this.format.setMinimumFractionDigits(minScale);
        }
    }

    public void setScale(int scale) {
        this.setScale(scale, scale);
    }

    private static String getAllowedChars() {
        NumberFormat format = NumberFormat.getInstance();
        if (format instanceof DecimalFormat) {
            group = ((DecimalFormat)format).getDecimalFormatSymbols().getGroupingSeparator();
            fraction = ((DecimalFormat)format).getDecimalFormatSymbols().getDecimalSeparator();
        }
        if (group != '.' && fraction == ',') {
            group = (char)46;
        }
        return "-0123456789" + group + fraction + MATH_OPERATORS;
    }

    @Override
    protected Document createDefaultModel() {
        return new FloatDocument();
    }

    public BigDecimal getDecimal() {
        if (this.getText().length() > 0) {
            try {
                return new BigDecimal(this.eval());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return BigDecimal.ZERO;
    }

    @Override
    @Deprecated
    public void setText(String text) {
    }

    String eval() {
        String text = this.getText();
        if (text.length() == 0) {
            return "";
        }
        StringBuilder temp = new StringBuilder();
        for (int j = 0; j < text.length(); ++j) {
            char c = text.charAt(j);
            if (c == group) continue;
            temp.append(c);
        }
        text = temp.toString();
        if (fraction == ',') {
            text = text.replace(',', '.');
        }
        try {
            BigDecimal d = new BigDecimal(text);
            return d.toString();
        }
        catch (NumberFormatException nfe) {
            try {
                Object o = jsEngine.eval(text);
                if (o instanceof Number) {
                    return new BigDecimal(o.toString()).setScale(this.scale, 4).toString();
                }
            }
            catch (ScriptException ex) {
                return "";
            }
            return "";
        }
    }

    public void setDecimal(BigDecimal decimal) {
        if (decimal != null) {
            super.setText(this.format.format(decimal.doubleValue()));
        } else {
            super.setText("");
        }
    }

    static {
        group = (char)44;
        fraction = (char)46;
        FLOAT = JFloatField.getAllowedChars();
        jsEngine = new ScriptEngineManager().getEngineByName("JavaScript");
    }

    private final class KeyPadListener
    extends KeyAdapter {
        private KeyPadListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyLocation() == 4 && e.getKeyCode() == 110) {
                JFloatField.this.keypad = true;
            }
        }
    }

    private final class EvalFocusListener
    extends FocusAdapter {
        private EvalFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String t = JFloatField.this.eval();
                        if (t.length() > 0) {
                            JFloatField.this.setDecimal(new BigDecimal(t).setScale(JFloatField.this.scale, 4));
                        }
                    }
                });
            }
        }
    }

    private class FloatDocument
    extends PlainDocument {
        private static final long serialVersionUID = 6266828450216708242L;

        private FloatDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (JFloatField.this.keypad) {
                super.insertString(offs, Character.toString(fraction), a);
                JFloatField.this.keypad = false;
                return;
            }
            for (int j = 0; j < str.length(); ++j) {
                if (FLOAT.contains(String.valueOf(str.charAt(j)))) continue;
                return;
            }
            super.insertString(offs, str, a);
        }
    }
}

