/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.plaf.LayerUI;

public class BusyLayerUI
extends LayerUI<JPanel>
implements ActionListener {
    private static final int FPS = 24;
    private static final int TIMER_TICK = 41;
    private boolean isRunning;
    private boolean isFadingOut;
    private Timer timer;
    private int angle;
    private int fadeCount;
    private int fadeLimit = 24;

    @Override
    public void paint(Graphics g, JComponent c) {
        int w = c.getWidth();
        int h = c.getHeight();
        super.paint(g, c);
        if (!this.isRunning) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        float fade = (float)this.fadeCount / (float)this.fadeLimit;
        Composite urComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, 0.5f * fade));
        g2.fillRect(0, 0, w, h);
        g2.setComposite(urComposite);
        int s = Math.min(w, h) / 5;
        int cx = w / 2;
        int cy = h / 2;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(s / 4, 1, 1));
        g2.setPaint(Color.DARK_GRAY);
        g2.rotate(Math.PI * (double)this.angle / 180.0, cx, cy);
        for (int i = 0; i < 8; ++i) {
            float scale = (7.0f - (float)i) / 7.0f;
            g2.drawLine(cx + s, cy, cx + s * 2, cy);
            g2.rotate(-0.7853981633974483, cx, cy);
            g2.setComposite(AlphaComposite.getInstance(3, scale * fade));
        }
        g2.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isRunning) {
            this.firePropertyChange("tick", 0, 1);
            this.angle += 2;
            if (this.angle >= 360) {
                this.angle = 0;
            }
            if (this.isFadingOut) {
                if (--this.fadeCount == 0) {
                    this.isRunning = false;
                    this.timer.stop();
                }
            } else if (this.fadeCount < this.fadeLimit) {
                ++this.fadeCount;
            }
        }
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.isFadingOut = false;
        this.fadeCount = 0;
        this.timer = new Timer(41, this);
        this.timer.start();
    }

    public void stop() {
        this.isFadingOut = true;
    }

    @Override
    public void applyPropertyChange(PropertyChangeEvent pce, JLayer l) {
        if ("tick".equals(pce.getPropertyName())) {
            l.repaint();
        }
    }
}

