/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.CorruptionException;
import com.db4o.Db4oIOException;
import com.db4o.internal.Buffer;
import com.db4o.internal.BufferPair;
import com.db4o.internal.BuiltinTypeHandler;
import com.db4o.internal.Comparable4;
import com.db4o.internal.IndexableTypeHandler;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.Null;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TypeHandler4;
import com.db4o.internal.handlers.VariableLengthTypeHandler;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.slots.Slot;
import com.db4o.marshall.Context;
import com.db4o.marshall.ReadBuffer;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteBuffer;
import com.db4o.marshall.WriteContext;
import com.db4o.reflect.ReflectClass;

public abstract class StringHandler
extends VariableLengthTypeHandler
implements IndexableTypeHandler,
BuiltinTypeHandler {
    private Buffer i_compareTo;

    public StringHandler(ObjectContainerBase objectContainerBase) {
        super(objectContainerBase);
    }

    protected StringHandler(TypeHandler4 typeHandler4) {
        this(((StringHandler)typeHandler4).container());
    }

    public ReflectClass classReflector() {
        return this.container()._handlers.ICLASS_STRING;
    }

    public void deleteEmbedded(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer) {
        Slot slot = statefulBuffer.readSlot();
        if (slot.address() > 0 && !marshallerFamily._string.inlinedStrings()) {
            statefulBuffer.getTransaction().slotFreeOnCommit(slot.address(), slot);
        }
    }

    byte getIdentifier() {
        return 83;
    }

    public Object indexEntryToObject(Transaction transaction, Object object) {
        if (object instanceof Slot) {
            Slot slot = (Slot)object;
            object = this.container().bufferByAddress(slot.address(), slot.length());
        }
        return StringHandler.readStringNoDebug(transaction.context(), (ReadBuffer)object);
    }

    public Object readIndexEntry(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer) throws CorruptionException, Db4oIOException {
        return marshallerFamily._string.readIndexEntry(statefulBuffer);
    }

    public Object readIndexEntry(Buffer buffer) {
        Slot slot = new Slot(buffer.readInt(), buffer.readInt());
        if (this.isInvalidSlot(slot)) {
            return null;
        }
        return slot;
    }

    private boolean isInvalidSlot(Slot slot) {
        return slot.address() == 0 && slot.length() == 0;
    }

    public void writeIndexEntry(Buffer buffer, Object object) {
        if (object == null) {
            buffer.writeInt(0);
            buffer.writeInt(0);
            return;
        }
        if (object instanceof StatefulBuffer) {
            StatefulBuffer statefulBuffer = (StatefulBuffer)object;
            buffer.writeInt(statefulBuffer.getAddress());
            buffer.writeInt(statefulBuffer.length());
            return;
        }
        if (object instanceof Slot) {
            Slot slot = (Slot)object;
            buffer.writeInt(slot.address());
            buffer.writeInt(slot.length());
            return;
        }
        throw new IllegalArgumentException();
    }

    public final void writeShort(Transaction transaction, String string, Buffer buffer) {
        if (string == null) {
            buffer.writeInt(0);
        } else {
            buffer.writeInt(string.length());
            transaction.container().handlers().stringIO().write(buffer, string);
        }
    }

    private Buffer val(Object object) {
        return this.val(object, this.container());
    }

    public Buffer val(Object object, ObjectContainerBase objectContainerBase) {
        if (object instanceof Buffer) {
            return (Buffer)object;
        }
        if (object instanceof String) {
            return StringHandler.writeToBuffer(objectContainerBase, (String)object);
        }
        if (object instanceof Slot) {
            Slot slot = (Slot)object;
            return objectContainerBase.bufferByAddress(slot.address(), slot.length());
        }
        return null;
    }

    public Comparable4 prepareComparison(Object object) {
        if (object == null) {
            this.i_compareTo = null;
            return Null.INSTANCE;
        }
        this.i_compareTo = this.val(object);
        return this;
    }

    public int compareTo(Object object) {
        if (this.i_compareTo == null) {
            if (object == null) {
                return 0;
            }
            return 1;
        }
        return this.compare(this.i_compareTo, this.val(object));
    }

    final int compare(Buffer buffer, Buffer buffer2) {
        if (buffer == null) {
            if (buffer2 == null) {
                return 0;
            }
            return 1;
        }
        if (buffer2 == null) {
            return -1;
        }
        return StringHandler.compare(buffer._buffer, buffer2._buffer);
    }

    public static final int compare(byte[] byArray, byte[] byArray2) {
        int n;
        int n2 = byArray.length < byArray2.length ? byArray.length : byArray2.length;
        for (int i = n = 4; i < n2; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return byArray2[i] - byArray[i];
        }
        return byArray2.length - byArray.length;
    }

    public void defragIndexEntry(BufferPair bufferPair) {
        bufferPair.copyID(false, true);
        bufferPair.incrementIntSize();
    }

    public void defrag(MarshallerFamily marshallerFamily, BufferPair bufferPair, boolean bl) {
        if (!bl) {
            bufferPair.incrementOffset(this.linkLength());
        } else {
            marshallerFamily._string.defrag(bufferPair);
        }
    }

    public abstract Object read(ReadContext var1);

    public void write(WriteContext writeContext, Object object) {
        StringHandler.internalWrite((InternalObjectContainer)writeContext.objectContainer(), writeContext, (String)object);
    }

    protected static void internalWrite(InternalObjectContainer internalObjectContainer, WriteBuffer writeBuffer, String string) {
        writeBuffer.writeInt(string.length());
        StringHandler.stringIo(internalObjectContainer).write(writeBuffer, string);
    }

    public static Buffer writeToBuffer(InternalObjectContainer internalObjectContainer, String string) {
        Buffer buffer = new Buffer(StringHandler.stringIo(internalObjectContainer).length(string));
        StringHandler.internalWrite(internalObjectContainer, buffer, string);
        return buffer;
    }

    protected static LatinStringIO stringIo(Context context) {
        return StringHandler.stringIo((InternalObjectContainer)context.objectContainer());
    }

    protected static LatinStringIO stringIo(InternalObjectContainer internalObjectContainer) {
        return internalObjectContainer.container().stringIO();
    }

    public static String readString(Context context, ReadBuffer readBuffer) {
        String string = StringHandler.readStringNoDebug(context, readBuffer);
        return string;
    }

    public static String readStringNoDebug(Context context, ReadBuffer readBuffer) {
        int n = readBuffer.readInt();
        if (n > 0) {
            return StringHandler.intern(context, StringHandler.stringIo(context).read(readBuffer, n));
        }
        return "";
    }

    protected static String intern(Context context, String string) {
        if (context.objectContainer().ext().configure().internStrings()) {
            return string.intern();
        }
        return string;
    }
}

