/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.PartialObjectContainer;
import com.db4o.internal.Transaction;
import com.db4o.reflect.ReflectClass;

class ObjectAnalyzer {
    private final PartialObjectContainer _container;
    private final Object _obj;
    private ClassMetadata _classMetadata;
    private ObjectReference _ref;
    private boolean _notStorable;

    ObjectAnalyzer(PartialObjectContainer partialObjectContainer, Object object) {
        this._container = partialObjectContainer;
        this._obj = object;
    }

    void analyze(Transaction transaction) {
        this._ref = transaction.referenceForObject(this._obj);
        if (this._ref == null) {
            ReflectClass reflectClass = this._container.reflector().forObject(this._obj);
            if (reflectClass == null) {
                this.notStorable(this._obj, reflectClass);
                return;
            }
            if (!this.detectClassMetadata(transaction, reflectClass)) {
                return;
            }
        } else {
            this._classMetadata = this._ref.classMetadata();
        }
        if (this.isPlainObjectOrPrimitive(this._classMetadata)) {
            this.notStorable(this._obj, this._classMetadata.classReflector());
        }
    }

    private boolean detectClassMetadata(Transaction transaction, ReflectClass reflectClass) {
        this._classMetadata = this._container.getActiveClassMetadata(reflectClass);
        if (this._classMetadata == null) {
            this._classMetadata = this._container.produceClassMetadata(reflectClass);
            if (this._classMetadata == null) {
                this.notStorable(this._obj, reflectClass);
                return false;
            }
            this._ref = transaction.referenceForObject(this._obj);
        }
        return true;
    }

    private void notStorable(Object object, ReflectClass reflectClass) {
        this._container.notStorable(reflectClass, object);
        this._notStorable = true;
    }

    boolean notStorable() {
        return this._notStorable;
    }

    private final boolean isPlainObjectOrPrimitive(ClassMetadata classMetadata) {
        return classMetadata.getID() == 11 || classMetadata.isPrimitive();
    }

    ObjectReference objectReference() {
        return this._ref;
    }

    public ClassMetadata classMetadata() {
        return this._classMetadata;
    }
}

