/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.CorruptionException;
import com.db4o.defragment.DefragContextImpl;
import com.db4o.defragment.PassCommand;
import com.db4o.internal.Buffer;
import com.db4o.internal.BufferPair;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.SlotCopyHandler;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.marshall.ObjectHeader;
import java.io.IOException;

final class SecondPassCommand
implements PassCommand {
    protected final int _objectCommitFrequency;
    protected int _objectCount = 0;

    public SecondPassCommand(int n) {
        this._objectCommitFrequency = n;
    }

    public void processClass(DefragContextImpl defragContextImpl, final ClassMetadata classMetadata, int n, final int n2) throws CorruptionException, IOException {
        if (defragContextImpl.mappedID(n, -1) == -1) {
            System.err.println("MAPPING NOT FOUND: " + n);
        }
        BufferPair.processCopy(defragContextImpl, n, new SlotCopyHandler(){

            public void processCopy(BufferPair bufferPair) throws CorruptionException, IOException {
                classMetadata.defragClass(bufferPair, n2);
            }
        });
    }

    public void processObjectSlot(final DefragContextImpl defragContextImpl, ClassMetadata classMetadata, int n) throws CorruptionException, IOException {
        Buffer buffer = defragContextImpl.sourceBufferByID(n);
        ObjectHeader objectHeader = defragContextImpl.sourceObjectHeader(buffer);
        buffer._offset = 0;
        boolean bl = defragContextImpl.hasFieldIndex(objectHeader.classMetadata());
        BufferPair.processCopy(defragContextImpl, n, new SlotCopyHandler(){

            public void processCopy(BufferPair bufferPair) {
                ClassMetadata.defragObject(bufferPair);
                if (SecondPassCommand.this._objectCommitFrequency > 0) {
                    ++SecondPassCommand.this._objectCount;
                    if (SecondPassCommand.this._objectCount == SecondPassCommand.this._objectCommitFrequency) {
                        defragContextImpl.targetCommit();
                        SecondPassCommand.this._objectCount = 0;
                    }
                }
            }
        }, bl, buffer);
    }

    public void processClassCollection(final DefragContextImpl defragContextImpl) throws CorruptionException, IOException {
        BufferPair.processCopy(defragContextImpl, defragContextImpl.sourceClassCollectionID(), new SlotCopyHandler(){

            public void processCopy(BufferPair bufferPair) {
                int n = 0;
                int n2 = bufferPair.target().offset();
                n = this.copyAcceptedClasses(bufferPair, n);
                this.writeIntAt(bufferPair.target(), n2, n);
            }

            private int copyAcceptedClasses(BufferPair bufferPair, int n) {
                int n2 = bufferPair.readInt();
                for (int i = 0; i < n2; ++i) {
                    int n3 = bufferPair.source().readInt();
                    if (!this.accept(n3)) continue;
                    ++n;
                    bufferPair.writeMappedID(n3);
                }
                return n;
            }

            private void writeIntAt(Buffer buffer, int n, int n2) {
                int n3 = buffer.offset();
                buffer.seek(n);
                buffer.writeInt(n2);
                buffer.seek(n3);
            }

            private boolean accept(int n) {
                return defragContextImpl.accept(defragContextImpl.yapClass(n));
            }
        });
    }

    public void processBTree(DefragContextImpl defragContextImpl, BTree bTree) throws CorruptionException, IOException {
        bTree.defragBTree(defragContextImpl);
    }

    public void flush(DefragContextImpl defragContextImpl) {
    }
}

