/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.export.ElementGridCell;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.ooxml.GenericElementXlsxHandler;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporterContext;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporterNature;
import net.sf.jasperreports.engine.export.ooxml.XlsxCellHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxContentTypesHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxRelsHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxRunHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxSheetHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxStyleHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxWorkbookHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxZip;
import net.sf.jasperreports.engine.export.zip.ExportZipEntry;
import net.sf.jasperreports.engine.export.zip.FileBufferedZipEntry;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRXlsxExporter
extends JRXlsAbstractExporter {
    private static final Log log = LogFactory.getLog((Class)JRXlsxExporter.class);
    public static final String XLSX_EXPORTER_KEY = "net.sf.jasperreports.xlsx";
    protected static final String XLSX_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.xlsx.";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    public static final String IMAGE_NAME_PREFIX = "img_";
    protected static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    protected XlsxZip xlsxZip = null;
    protected XlsxWorkbookHelper wbHelper = null;
    protected XlsxRelsHelper relsHelper = null;
    protected XlsxContentTypesHelper ctHelper = null;
    protected XlsxSheetHelper sheetHelper = null;
    protected XlsxStyleHelper styleHelper = null;
    protected XlsxCellHelper cellHelper = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected Map rendererToImagePathMap = null;
    protected Map imageMaps;
    protected List imagesToProcess = null;
    protected int reportIndex = 0;
    protected int pageIndex = 0;
    protected int tableIndex = 0;
    protected boolean startPage;
    protected boolean isWrapBreakWord = false;
    protected Map fontMap = null;
    protected LinkedList backcolorStack = new LinkedList();
    protected Color backcolor = null;
    private XlsxRunHelper runHelper = null;
    protected ExporterNature nature = null;

    protected void setParameters() {
        super.setParameters();
        this.nature = new JRXlsxExporterNature(this.filter);
        this.isCollapseRowSpan = false;
    }

    public static JRPrintImage getImage(List jasperPrintList, String imageName) {
        return JRXlsxExporter.getImage(jasperPrintList, JRXlsxExporter.getPrintElementIndex(imageName));
    }

    public static JRPrintImage getImage(List jasperPrintList, JRPrintElementIndex imageIndex) {
        JasperPrint report = (JasperPrint)jasperPrintList.get(imageIndex.getReportIndex());
        JRPrintPage page = (JRPrintPage)report.getPages().get(imageIndex.getPageIndex());
        Integer[] elementIndexes = imageIndex.getAddressArray();
        Object element = page.getElements().get(elementIndexes[0]);
        for (int i = 1; i < elementIndexes.length; ++i) {
            JRPrintFrame frame = (JRPrintFrame)element;
            element = frame.getElements().get(elementIndexes[i]);
        }
        return (JRPrintImage)element;
    }

    protected void exportStyledText(JRStyle style, JRStyledText styledText, Locale locale) {
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            this.runHelper.export(style, iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit), locale);
            iterator.setIndex(runLimit);
        }
    }

    protected String getImagePath(JRRenderable renderer, boolean isLazy, JRExporterGridCell gridCell) {
        String imagePath = null;
        if (renderer != null) {
            if (renderer.getType() == 0 && this.rendererToImagePathMap.containsKey(renderer.getId())) {
                imagePath = (String)this.rendererToImagePathMap.get(renderer.getId());
            } else {
                String imageName;
                JRPrintElementIndex imageIndex = this.getElementIndex(gridCell);
                this.imagesToProcess.add(imageIndex);
                imagePath = imageName = JRXlsxExporter.getImageName(imageIndex);
                this.rendererToImagePathMap.put(renderer.getId(), imagePath);
            }
        }
        return imagePath;
    }

    protected JRPrintElementIndex getElementIndex(JRExporterGridCell gridCell) {
        JRPrintElementIndex imageIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, gridCell.getWrapper().getAddress());
        return imageIndex;
    }

    public static String getImageName(JRPrintElementIndex printElementIndex) {
        return IMAGE_NAME_PREFIX + printElementIndex.toString();
    }

    public static JRPrintElementIndex getPrintElementIndex(String imageName) {
        if (!imageName.startsWith(IMAGE_NAME_PREFIX)) {
            throw new JRRuntimeException("Invalid image name: " + imageName);
        }
        return JRPrintElementIndex.parsePrintElementIndex(imageName.substring(IMAGE_NAME_PREFIX_LEGTH));
    }

    protected void setBackcolor(Color color) {
        this.backcolorStack.addLast(this.backcolor);
        this.backcolor = color;
    }

    protected void restoreBackcolor() {
        this.backcolor = (Color)this.backcolorStack.removeLast();
    }

    private float getXAlignFactor(JRPrintImage image) {
        float xalignFactor = 0.0f;
        switch (image.getHorizontalAlignment()) {
            case 3: {
                xalignFactor = 1.0f;
                break;
            }
            case 2: {
                xalignFactor = 0.5f;
                break;
            }
            default: {
                xalignFactor = 0.0f;
            }
        }
        return xalignFactor;
    }

    private float getYAlignFactor(JRPrintImage image) {
        float yalignFactor = 0.0f;
        switch (image.getVerticalAlignment()) {
            case 3: {
                yalignFactor = 1.0f;
                break;
            }
            case 2: {
                yalignFactor = 0.5f;
                break;
            }
            default: {
                yalignFactor = 0.0f;
            }
        }
        return yalignFactor;
    }

    protected boolean startHyperlink(JRPrintHyperlink link, boolean isText) {
        String href = this.getHyperlinkURL(link);
        if (href != null) {
            String tooltip;
            this.wbHelper.write("<w:r><w:fldChar w:fldCharType=\"begin\"/></w:r>\n");
            this.wbHelper.write("<w:r><w:instrText xml:space=\"preserve\"> HYPERLINK \"" + href + "\"");
            String target = this.getHyperlinkTarget(link);
            if (target != null) {
                this.wbHelper.write(" \\t \"" + target + "\"");
            }
            if ((tooltip = link.getHyperlinkTooltip()) != null) {
                this.wbHelper.write(" \\o \"" + JRStringUtil.xmlEncode(tooltip) + "\"");
            }
            this.wbHelper.write(" </w:instrText></w:r>\n");
            this.wbHelper.write("<w:r><w:fldChar w:fldCharType=\"separate\"/></w:r>\n");
        }
        return href != null;
    }

    protected String getHyperlinkTarget(JRPrintHyperlink link) {
        String target = null;
        switch (link.getHyperlinkTarget()) {
            case 1: {
                target = "_self";
                break;
            }
            default: {
                target = "_blank";
            }
        }
        return target;
    }

    protected String getHyperlinkURL(JRPrintHyperlink link) {
        String href;
        block10: {
            JRHyperlinkProducer customHandler;
            block9: {
                href = null;
                customHandler = this.getCustomHandler(link);
                if (customHandler != null) break block9;
                switch (link.getHyperlinkType()) {
                    case 2: {
                        if (link.getHyperlinkReference() != null) {
                            href = link.getHyperlinkReference();
                            break;
                        }
                        break block10;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block10;
                    }
                    case 6: {
                        break;
                    }
                }
                break block10;
            }
            href = customHandler.getHyperlink(link);
        }
        return href;
    }

    protected void endHyperlink(boolean isText) {
        this.wbHelper.write("<w:r><w:fldChar w:fldCharType=\"end\"/></w:r>\n");
    }

    protected String getExporterPropertiesPrefix() {
        return XLSX_EXPORTER_PROPERTIES_PREFIX;
    }

    protected void addBlankCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        this.cellHelper.exportHeader(gridCell, rowIndex, colIndex);
        this.cellHelper.exportFooter();
    }

    protected void closeWorkbook(OutputStream os) throws JRException {
        this.closeSheet();
        this.styleHelper.export();
        this.styleHelper.close();
        try {
            this.wbHelper.exportFooter();
            this.wbHelper.close();
            if (this.imagesToProcess != null && this.imagesToProcess.size() > 0) {
                Iterator it = this.imagesToProcess.iterator();
                while (it.hasNext()) {
                    String mimeType;
                    JRPrintElementIndex imageIndex = (JRPrintElementIndex)it.next();
                    JRPrintImage image = JRXlsxExporter.getImage(this.jasperPrintList, imageIndex);
                    JRRenderable renderer = image.getRenderer();
                    if (renderer.getType() == 1) {
                        renderer = new JRWrappingSvgRenderer(renderer, new Dimension(image.getWidth(), image.getHeight()), 1 == image.getMode() ? image.getBackcolor() : null);
                    }
                    if ((mimeType = JRTypeSniffer.getImageMimeType(renderer.getImageType())) == null) {
                        mimeType = "image/jpeg";
                    }
                    String extension = mimeType.substring(mimeType.lastIndexOf(47) + 1);
                    String imageName = JRXlsxExporter.getImageName(imageIndex);
                    this.xlsxZip.addEntry(new FileBufferedZipEntry("xl/media/" + imageName + "." + extension, renderer.getImageData()));
                    this.relsHelper.exportImage(imageName, extension);
                }
            }
            this.relsHelper.exportFooter();
            this.relsHelper.close();
            this.ctHelper.exportFooter();
            this.ctHelper.close();
            this.xlsxZip.zipEntries(os);
            this.xlsxZip.dispose();
        }
        catch (IOException e) {
            throw new JRException(e);
        }
    }

    protected void createSheet(String name) {
        this.closeSheet();
        this.wbHelper.exportSheet(this.sheetIndex + 1);
        this.ctHelper.exportSheet(this.sheetIndex + 1);
        this.relsHelper.exportSheet(this.sheetIndex + 1);
        ExportZipEntry sheetEntry = this.xlsxZip.addSheet(this.sheetIndex + 1);
        Writer sheetWriter = sheetEntry.getWriter();
        this.sheetHelper = new XlsxSheetHelper(sheetWriter);
        this.cellHelper = new XlsxCellHelper(sheetWriter, this.styleHelper);
        this.runHelper = new XlsxRunHelper(sheetWriter, this.fontMap, null);
        this.sheetHelper.exportHeader();
    }

    protected void closeSheet() {
        if (this.sheetHelper != null) {
            this.sheetHelper.exportFooter();
            this.sheetHelper.close();
        }
    }

    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        this.cellHelper.exportHeader(gridCell, rowIndex, colIndex);
        this.sheetHelper.exportMergedCells(rowIndex, colIndex, gridCell.getRowSpan(), gridCell.getColSpan());
        this.cellHelper.exportFooter();
    }

    protected void exportImage(JRPrintImage image, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols) throws JRException {
        this.cellHelper.exportHeader(gridCell, rowIndex, colIndex);
        this.sheetHelper.exportMergedCells(rowIndex, colIndex, gridCell.getRowSpan(), gridCell.getColSpan());
        this.cellHelper.exportFooter();
    }

    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = null;
        float ratio = line.getWidth() / line.getHeight();
        pen = ratio > 1.0f ? (line.getDirection() == 1 ? box.getTopPen() : box.getBottomPen()) : (line.getDirection() == 1 ? box.getLeftPen() : box.getRightPen());
        pen.setLineColor(line.getLinePen().getLineColor());
        pen.setLineStyle(line.getLinePen().getLineStyle());
        pen.setLineWidth(line.getLinePen().getLineWidth());
        gridCell.setBox(box);
        this.cellHelper.exportHeader(gridCell, rowIndex, colIndex);
        this.sheetHelper.exportMergedCells(rowIndex, colIndex, gridCell.getRowSpan(), gridCell.getColSpan());
        this.cellHelper.exportFooter();
    }

    protected void exportRectangle(JRPrintGraphicElement rectangle, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = box.getPen();
        pen.setLineColor(rectangle.getLinePen().getLineColor());
        pen.setLineStyle(rectangle.getLinePen().getLineStyle());
        pen.setLineWidth(rectangle.getLinePen().getLineWidth());
        gridCell.setBox(box);
        this.cellHelper.exportHeader(gridCell, rowIndex, colIndex);
        this.sheetHelper.exportMergedCells(rowIndex, colIndex, gridCell.getRowSpan(), gridCell.getColSpan());
        this.cellHelper.exportFooter();
    }

    public void exportText(JRPrintText text, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        this.cellHelper.exportHeader(gridCell, rowIndex, colIndex);
        this.sheetHelper.exportMergedCells(rowIndex, colIndex, gridCell.getRowSpan(), gridCell.getColSpan());
        JRStyledText styledText = this.getStyledText(text);
        int textLength = 0;
        if (styledText != null) {
            textLength = styledText.length();
        }
        this.sheetHelper.write("<is>");
        boolean startedHyperlink = this.startHyperlink(text, true);
        if (textLength > 0) {
            this.exportStyledText(text.getStyle(), styledText, this.getTextLocale(text));
        }
        if (startedHyperlink) {
            this.endHyperlink(true);
        }
        this.sheetHelper.write("</is>");
        this.sheetHelper.flush();
        this.cellHelper.exportFooter();
    }

    protected void exportGenericElement(JRGenericPrintElement element, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols) throws JRException {
        GenericElementXlsxHandler handler = (GenericElementXlsxHandler)GenericElementHandlerEnviroment.getHandler(element.getGenericType(), XLSX_EXPORTER_KEY);
        if (handler != null) {
            ExporterContext exporterContext = new ExporterContext(this.sheetHelper);
            handler.exportElement(exporterContext, element, gridCell, colIndex, rowIndex);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No XLSX generic element handler for " + element.getGenericType()));
        }
    }

    protected ExporterNature getNature() {
        return this.nature;
    }

    protected void openWorkbook(OutputStream os) throws JRException {
        this.rendererToImagePathMap = new HashMap();
        this.imageMaps = new HashMap();
        this.imagesToProcess = new ArrayList();
        try {
            this.xlsxZip = new XlsxZip();
            this.wbHelper = new XlsxWorkbookHelper(this.xlsxZip.getWorkbookEntry().getWriter());
            this.wbHelper.exportHeader();
            this.relsHelper = new XlsxRelsHelper(this.xlsxZip.getRelsEntry().getWriter());
            this.relsHelper.exportHeader();
            this.ctHelper = new XlsxContentTypesHelper(this.xlsxZip.getContentTypesEntry().getWriter());
            this.ctHelper.exportHeader();
            this.styleHelper = new XlsxStyleHelper(this.xlsxZip.getStylesEntry().getWriter(), this.fontMap, this.getExporterKey(), this.isWhitePageBackground, this.isIgnoreCellBorder, this.isIgnoreCellBackground);
        }
        catch (IOException e) {
            throw new JRException(e);
        }
    }

    protected void removeColumn(int col) {
    }

    protected void setBackground() {
    }

    protected void setCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) {
    }

    protected void addOccupiedCell(OccupiedGridCell occupiedGridCell, int colIndex, int rowIndex) {
        ElementGridCell elementGridCell = (ElementGridCell)occupiedGridCell.getOccupier();
        this.cellHelper.exportHeader(elementGridCell, rowIndex, colIndex);
        this.cellHelper.exportFooter();
    }

    protected void setColumnWidth(int col, int width) {
        this.sheetHelper.exportColumn(col, width);
    }

    protected void setRowHeight(int rowIndex, int rowHeight) throws JRException {
        this.sheetHelper.exportRow(rowHeight);
    }

    protected String getExporterKey() {
        return XLSX_EXPORTER_KEY;
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRXlsxExporterContext {
        XlsxSheetHelper sheetHelper;

        public ExporterContext(XlsxSheetHelper sheetHelper) {
            super(JRXlsxExporter.this);
            this.sheetHelper = null;
            this.sheetHelper = sheetHelper;
        }

        public XlsxSheetHelper getSheetHelper() {
            return this.sheetHelper;
        }

        public String getExportPropertiesPrefix() {
            return JRXlsxExporter.XLSX_EXPORTER_PROPERTIES_PREFIX;
        }
    }
}

