/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.app;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.MutableLayoutContext;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.context.typewrapper.EnumTypeWrapper;
import net.sourceforge.jeuclid.context.typewrapper.TypeWrapper;
import net.sourceforge.jeuclid.converter.Converter;
import net.sourceforge.jeuclid.converter.ConverterRegistry;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Mml2xxx {
    private static final String OUT_FILE_TYPE = "outFileType";
    private static final String DEFAULT_TYPE = "image/png";

    private Mml2xxx() {
    }

    private static Options createOptions() {
        Options options = new Options();
        Option option = new Option(OUT_FILE_TYPE, true, "output file mime type [default: derived from the target file's extention]; available values are: " + StringUtils.join(ConverterRegistry.getInstance().getAvailableOutfileTypes().iterator(), (char)' '));
        options.addOption(option);
        LayoutContext layoutContext = LayoutContextImpl.getDefaultLayoutContext();
        for (Parameter parameter : Parameter.values()) {
            TypeWrapper typeWrapper = parameter.getTypeWrapper();
            StringBuilder stringBuilder = new StringBuilder(parameter.getOptionDesc());
            String string = parameter.toString(layoutContext.getParameter(parameter));
            if (string != null) {
                stringBuilder.append(" [default: ").append(string).append("]");
            }
            Option option2 = new Option(parameter.getOptionName(), true, stringBuilder.toString());
            String string2 = parameter.getTypeWrapper().getValueType().getSimpleName().toLowerCase(Locale.ENGLISH);
            if (typeWrapper instanceof EnumTypeWrapper) {
                string2 = StringUtils.join((Object[])((EnumTypeWrapper)typeWrapper).values(), (char)'|');
            }
            option2.setArgName(string2);
            options.addOption(option2);
        }
        return options;
    }

    public static void main(String[] stringArray) {
        Options options = Mml2xxx.createOptions();
        CommandLine commandLine = null;
        try {
            commandLine = new GnuParser().parse(options, stringArray);
            List<String> list = Arrays.asList(commandLine.getArgs());
            if (list.size() < 2) {
                throw new ParseException("Not enough arguments!");
            }
            int n = list.size() - 1;
            File file = new File(list.get(n));
            boolean bl = file.isDirectory();
            List<File> list2 = Mml2xxx.createListOfSourceFiles(list, n);
            MutableLayoutContext mutableLayoutContext = Mml2xxx.createLayoutContext(commandLine);
            if (bl) {
                Mml2xxx.convertMultipleFiles(commandLine, file, list2, mutableLayoutContext);
            } else {
                if (list2.size() != 1) {
                    throw new ParseException("Too many file arguments. Did you want to add a target directory?");
                }
                String string = Mml2xxx.findOutfileType(commandLine, file.getName());
                Converter.getInstance().convert(list2.get(0), file, string, (LayoutContext)mutableLayoutContext);
            }
        }
        catch (ParseException parseException) {
            System.err.println((Object)parseException);
            Mml2xxx.showUsage(options);
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println("Error encountered during converion process");
            iOException.printStackTrace(System.err);
            System.exit(2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException);
            Mml2xxx.showUsage(options);
            System.exit(1);
        }
    }

    private static void convertMultipleFiles(CommandLine commandLine, File file, List<File> list, MutableLayoutContext mutableLayoutContext) throws ParseException, IOException {
        String string = Mml2xxx.findOutfileType(commandLine, null);
        for (File file2 : list) {
            String string2 = file2.getName();
            int n = string2.lastIndexOf(46);
            String string3 = n >= 0 ? string2.substring(0, n) : string2;
            File file3 = new File(file, string3 + '.' + ConverterRegistry.getInstance().getSuffixForMimeType(string));
            Converter.getInstance().convert(file2, file3, string, (LayoutContext)mutableLayoutContext);
        }
    }

    private static List<File> createListOfSourceFiles(List<String> list, int n) throws ParseException {
        ArrayList<File> arrayList = new ArrayList<File>(n);
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            File file = new File(string);
            if (!file.isFile() || !file.canRead()) {
                throw new ParseException(string + " is not a file or not readable");
            }
            arrayList.add(file);
        }
        return arrayList;
    }

    private static String findOutfileType(CommandLine commandLine, String string) throws ParseException {
        int n;
        String string2 = commandLine.getOptionValue(OUT_FILE_TYPE);
        if (string2 == null && string != null && (n = string.lastIndexOf(46)) != -1 && n != string.length() - 1) {
            String string3 = string.substring(n + 1);
            string2 = ConverterRegistry.getInstance().getMimeTypeForSuffix(string3);
        }
        if (string2 == null) {
            System.out.println("No ouput type could be detected, assuming image/png");
            string2 = DEFAULT_TYPE;
        } else if (!ConverterRegistry.getInstance().getAvailableOutfileTypes().contains(string2)) {
            throw new IllegalArgumentException("Output type " + string2 + " is not supported");
        }
        return string2;
    }

    private static MutableLayoutContext createLayoutContext(CommandLine commandLine) {
        LayoutContextImpl layoutContextImpl = new LayoutContextImpl(LayoutContextImpl.getDefaultLayoutContext());
        for (Parameter parameter : Parameter.values()) {
            String string = commandLine.getOptionValue(parameter.getOptionName());
            if (string == null) continue;
            layoutContextImpl.setParameter(parameter, parameter.fromString(string));
        }
        return layoutContextImpl;
    }

    private static void showUsage(Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        String string = helpFormatter.getNewLine();
        helpFormatter.printHelp("mml2xxx <source file(s)> <target file/directory> [options]", "source is the path to the source file (MathML or ODF format)" + string + "target is the path to the target file / directory" + string + "If multiple source files are given, target must be a directory", options, "Example: mml2xxx a.mml a.png -backgroundColor white");
    }
}

