/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.general;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.elements.AbstractElementWithDelegates;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.presentation.AbstractContainer;
import net.sourceforge.jeuclid.elements.presentation.general.Msqrt;
import net.sourceforge.jeuclid.elements.support.Dimension2DImpl;
import net.sourceforge.jeuclid.elements.support.ElementListSupport;
import net.sourceforge.jeuclid.elements.support.GraphicsSupport;
import net.sourceforge.jeuclid.elements.support.attributes.AttributesHelper;
import net.sourceforge.jeuclid.layout.GraphicsObject;
import net.sourceforge.jeuclid.layout.LayoutInfo;
import net.sourceforge.jeuclid.layout.LayoutStage;
import net.sourceforge.jeuclid.layout.LayoutView;
import net.sourceforge.jeuclid.layout.LayoutableNode;
import net.sourceforge.jeuclid.layout.LineObject;
import org.apache.batik.dom.AbstractDocument;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.mathml.MathMLEncloseElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Menclose
extends AbstractElementWithDelegates
implements MathMLEncloseElement {
    public static final String ELEMENT = "menclose";
    public static final String ATTR_NOTATION = "notation";
    private static final Log LOGGER = LogFactory.getLog(Menclose.class);
    private static final Map<String, Constructor<?>> IMPL_CLASSES = new HashMap();
    private static final long serialVersionUID = 1L;

    public Menclose(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
        this.setDefaultMathAttribute(ATTR_NOTATION, "");
    }

    protected Node newNode() {
        return new Menclose(this.nodeName, this.ownerDocument);
    }

    @Override
    public String getNotation() {
        return this.getMathAttribute(ATTR_NOTATION);
    }

    @Override
    public void setNotation(String string) {
        this.setAttribute(ATTR_NOTATION, string);
    }

    @Override
    protected List<LayoutableNode> createDelegates() {
        Stack<Constructor<?>> stack = this.parseNotations();
        JEuclidElement jEuclidElement = this.ensureSingleChild();
        jEuclidElement = this.createStackOfDelegates(stack, jEuclidElement);
        return Collections.singletonList(jEuclidElement);
    }

    private JEuclidElement createStackOfDelegates(Stack<Constructor<?>> stack, JEuclidElement jEuclidElement) {
        JEuclidElement jEuclidElement2 = jEuclidElement;
        while (!stack.isEmpty()) {
            Constructor<?> constructor = stack.pop();
            try {
                JEuclidElement jEuclidElement3 = (JEuclidElement)constructor.newInstance("saklsdiwet:menclosechild", this.ownerDocument);
                jEuclidElement3.appendChild(jEuclidElement2);
                jEuclidElement2 = jEuclidElement3;
            }
            catch (InstantiationException instantiationException) {
                LOGGER.warn((Object)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.warn((Object)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.warn((Object)invocationTargetException);
            }
        }
        return jEuclidElement2;
    }

    private JEuclidElement ensureSingleChild() {
        JEuclidElement jEuclidElement;
        if (this.getMathElementCount() == 1) {
            jEuclidElement = this.getMathElement(0);
        } else {
            jEuclidElement = (JEuclidElement)this.ownerDocument.createElement("mrow");
            for (Node node : ElementListSupport.createListOfChildren(this)) {
                jEuclidElement.appendChild(node);
            }
        }
        return jEuclidElement;
    }

    private Stack<Constructor<?>> parseNotations() {
        String[] stringArray = this.getNotation().split(" ");
        Stack stack = new Stack();
        for (String string : stringArray) {
            Constructor<?> constructor = IMPL_CLASSES.get(string.toLowerCase(Locale.ENGLISH));
            if (constructor == null) {
                if (string.length() <= 0) continue;
                LOGGER.info((Object)("Unsupported notation for menclose: " + string));
                continue;
            }
            stack.push(constructor);
        }
        return stack;
    }

    static {
        try {
            IMPL_CLASSES.put("radical", Msqrt.class.getConstructor(String.class, AbstractDocument.class));
            IMPL_CLASSES.put("longdiv", Longdiv.class.getConstructor(String.class, AbstractDocument.class));
            IMPL_CLASSES.put("updiagonalstrike", Updiagonalstrike.class.getConstructor(String.class, AbstractDocument.class));
            IMPL_CLASSES.put("downdiagonalstrike", Downdiagonalstrike.class.getConstructor(String.class, AbstractDocument.class));
            IMPL_CLASSES.put("actuarial", Actuarial.class.getConstructor(String.class, AbstractDocument.class));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.fatal((Object)noSuchMethodException);
        }
    }

    private static final class Actuarial
    extends AbstractRowLikeNotation {
        private static final long serialVersionUID = 1L;

        public Actuarial(String string, AbstractDocument abstractDocument) {
            super(string, abstractDocument);
        }

        protected Node newNode() {
            return new Actuarial(this.nodeName, this.ownerDocument);
        }

        protected Dimension2D getBorderLeftTop(LayoutContext layoutContext) {
            float f = GraphicsSupport.lineWidth(layoutContext) * 2.0f;
            return new Dimension2DImpl(0.0f, f);
        }

        protected Dimension2D getBorderRightBottom(LayoutContext layoutContext) {
            float f = GraphicsSupport.lineWidth(layoutContext) * 2.0f;
            return new Dimension2DImpl(f, 0.0f);
        }

        protected void enclHook(LayoutInfo layoutInfo, LayoutStage layoutStage, LayoutContext layoutContext) {
            List<GraphicsObject> list = layoutInfo.getGraphicObjects();
            list.clear();
            float f = GraphicsSupport.lineWidth(layoutContext);
            float f2 = layoutInfo.getAscentHeight(layoutStage) + f;
            Color color = (Color)layoutContext.getParameter(Parameter.MATHCOLOR);
            list.add(new LineObject(0.0f, -f2, layoutInfo.getWidth(layoutStage) - f, -f2, f, color));
            list.add(new LineObject(layoutInfo.getWidth(layoutStage) - f, -f2, layoutInfo.getWidth(layoutStage) - f, layoutInfo.getDescentHeight(layoutStage), f, color));
        }
    }

    private static final class Downdiagonalstrike
    extends AbstractRowLikeNotation {
        private static final long serialVersionUID = 1L;

        public Downdiagonalstrike(String string, AbstractDocument abstractDocument) {
            super(string, abstractDocument);
        }

        protected Node newNode() {
            return new Downdiagonalstrike(this.nodeName, this.ownerDocument);
        }

        protected void enclHook(LayoutInfo layoutInfo, LayoutStage layoutStage, LayoutContext layoutContext) {
            Color color = (Color)layoutContext.getParameter(Parameter.MATHCOLOR);
            float f = GraphicsSupport.lineWidth(layoutContext);
            layoutInfo.setGraphicsObject(new LineObject(0.0f, -layoutInfo.getAscentHeight(layoutStage), layoutInfo.getWidth(layoutStage), layoutInfo.getDescentHeight(layoutStage), f, color));
        }
    }

    private static final class Updiagonalstrike
    extends AbstractRowLikeNotation {
        private static final long serialVersionUID = 1L;

        public Updiagonalstrike(String string, AbstractDocument abstractDocument) {
            super(string, abstractDocument);
        }

        protected Node newNode() {
            return new Updiagonalstrike(this.nodeName, this.ownerDocument);
        }

        protected void enclHook(LayoutInfo layoutInfo, LayoutStage layoutStage, LayoutContext layoutContext) {
            Color color = (Color)layoutContext.getParameter(Parameter.MATHCOLOR);
            float f = GraphicsSupport.lineWidth(layoutContext);
            layoutInfo.setGraphicsObject(new LineObject(0.0f, layoutInfo.getDescentHeight(layoutStage), layoutInfo.getWidth(layoutStage), -layoutInfo.getAscentHeight(layoutStage), f, color));
        }
    }

    private static final class Longdiv
    extends AbstractRowLikeNotation {
        private static final long serialVersionUID = 1L;

        public Longdiv(String string, AbstractDocument abstractDocument) {
            super(string, abstractDocument);
        }

        protected Node newNode() {
            return new Longdiv(this.nodeName, this.ownerDocument);
        }

        protected Dimension2D getBorderLeftTop(LayoutContext layoutContext) {
            float f = GraphicsSupport.lineWidth(layoutContext) * 2.0f;
            return new Dimension2DImpl(AttributesHelper.convertSizeToPt("0.25em", layoutContext, null) + f, f);
        }

        protected void enclHook(LayoutInfo layoutInfo, LayoutStage layoutStage, LayoutContext layoutContext) {
            List<GraphicsObject> list = layoutInfo.getGraphicObjects();
            list.clear();
            float f = GraphicsSupport.lineWidth(layoutContext);
            float f2 = layoutInfo.getAscentHeight(layoutStage) + f;
            Color color = (Color)layoutContext.getParameter(Parameter.MATHCOLOR);
            list.add(new LineObject(f, -f2, f, layoutInfo.getDescentHeight(layoutStage), f, color));
            list.add(new LineObject(f, -f2, layoutInfo.getWidth(layoutStage), -f2, f, color));
        }
    }

    private static abstract class AbstractRowLikeNotation
    extends AbstractContainer {
        public AbstractRowLikeNotation(String string, AbstractDocument abstractDocument) {
            super(string, abstractDocument);
        }

        protected void layoutStageInvariant(LayoutView layoutView, LayoutInfo layoutInfo, LayoutStage layoutStage, LayoutContext layoutContext) {
            LayoutContext layoutContext2 = this.applyLocalAttributesToContext(layoutContext);
            Dimension2D dimension2D = this.getBorderLeftTop(layoutContext2);
            float f = (float)dimension2D.getWidth();
            if (f > 0.0f) {
                layoutView.getInfo((LayoutableNode)this.getFirstChild()).moveTo(f, 0.0f, layoutStage);
            }
            ElementListSupport.fillInfoFromChildren(layoutView, layoutInfo, this, layoutStage, dimension2D, this.getBorderRightBottom(layoutContext2));
            this.enclHook(layoutInfo, layoutStage, this.applyLocalAttributesToContext(layoutContext2));
        }

        protected Dimension2D getBorderLeftTop(LayoutContext layoutContext) {
            return new Dimension2DImpl(0.0f, 0.0f);
        }

        protected Dimension2D getBorderRightBottom(LayoutContext layoutContext) {
            return new Dimension2DImpl(0.0f, 0.0f);
        }

        protected abstract void enclHook(LayoutInfo var1, LayoutStage var2, LayoutContext var3);
    }
}

