/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.terracotta.servlet;

import com.tc.object.bytecode.Manageable;
import com.tc.object.bytecode.ManagerUtil;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.AbstractSessionManager;
import org.mortbay.log.Log;

public class TerracottaSessionManager
extends AbstractSessionManager
implements Runnable {
    private Map<String, Session> _sessions;
    private Hashtable<String, SessionData> _sessionDatas;
    private Hashtable<String, MutableLong> _sessionExpirations;
    private String _contextPath;
    private String _virtualHost;
    private long _scavengePeriodMs = 30000L;
    private ScheduledExecutorService _scheduler;
    private ScheduledFuture<?> _scavenger;

    public void doStart() throws Exception {
        super.doStart();
        this._contextPath = this.canonicalize(this._context.getContextPath());
        this._virtualHost = this.virtualHostFrom(this._context);
        this._sessions = Collections.synchronizedMap(new HashMap());
        this._sessionDatas = this.newSharedMap("sessionData:" + this._contextPath + ":" + this._virtualHost);
        this._sessionExpirations = this.newSharedMap("sessionExpirations:" + this._contextPath + ":" + this._virtualHost);
        this._scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduleScavenging();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable newSharedMap(String name) {
        Lock.lock(name);
        try {
            Hashtable result = (Hashtable)ManagerUtil.lookupOrCreateRootNoDepth((String)name, new Hashtable());
            ((Manageable)result).__tc_managed().disableAutoLocking();
            Hashtable hashtable = result;
            return hashtable;
        }
        finally {
            Lock.unlock(name);
        }
    }

    private void scheduleScavenging() {
        long scavengePeriod;
        if (this._scavenger != null) {
            this._scavenger.cancel(false);
            this._scavenger = null;
        }
        if ((scavengePeriod = this.getScavengePeriodMs()) > 0L && this._scheduler != null) {
            this._scavenger = this._scheduler.scheduleWithFixedDelay(this, scavengePeriod, scavengePeriod, TimeUnit.MILLISECONDS);
        }
    }

    public void doStop() throws Exception {
        if (this._scavenger != null) {
            this._scavenger.cancel(true);
        }
        if (this._scheduler != null) {
            this._scheduler.shutdownNow();
        }
        super.doStop();
    }

    public void run() {
        this.scavenge();
    }

    public void enter(Request request) {
        String requestedSessionId = request.getRequestedSessionId();
        HttpSession session = request.getSession(false);
        Log.debug((String)"Entering, requested session id {}, session id {}", (Object)requestedSessionId, session == null ? null : this.getClusterId(session));
        if (requestedSessionId != null) {
            this.enter(this.getIdManager().getClusterId(requestedSessionId));
        }
    }

    protected void enter(String clusterId) {
        Lock.lock(this.newLockId(clusterId));
        Log.debug((String)"Entered, session id {}", (Object)clusterId);
    }

    protected boolean tryEnter(String clusterId) {
        return Lock.tryLock(this.newLockId(clusterId));
    }

    public void exit(Request request) {
        String requestedSessionId = request.getRequestedSessionId();
        HttpSession session = request.getSession(false);
        Log.debug((String)"Exiting, requested session id {}, session id {}", (Object)requestedSessionId, session == null ? null : this.getClusterId(session));
        if (requestedSessionId == null) {
            if (session != null) {
                this.exit(this.getClusterId(session));
            }
        } else {
            String requestedClusterId = this.getIdManager().getClusterId(requestedSessionId);
            this.exit(requestedClusterId);
            if (session != null && !requestedClusterId.equals(this.getClusterId(session))) {
                this.exit(this.getClusterId(session));
            }
        }
    }

    protected void exit(String clusterId) {
        Lock.unlock(this.newLockId(clusterId));
        Log.debug((String)"Exited, session id {}", (Object)clusterId);
    }

    protected void addSession(AbstractSessionManager.Session session) {
        String clusterId = this.getClusterId((HttpSession)session);
        Session tcSession = (Session)session;
        SessionData sessionData = tcSession.getSessionData();
        this._sessionExpirations.put(clusterId, sessionData._expiration);
        this._sessionDatas.put(clusterId, sessionData);
        this._sessions.put(clusterId, tcSession);
        Log.debug((String)"Added session {} with id {}", (Object)((Object)tcSession), (Object)clusterId);
    }

    public Cookie access(HttpSession session, boolean secure) {
        Cookie cookie = super.access(session, secure);
        Log.debug((String)"Accessed session {} with id {}", (Object)session, (Object)session.getId());
        return cookie;
    }

    public void complete(HttpSession session) {
        super.complete(session);
        Log.debug((String)"Completed session {} with id {}", (Object)session, (Object)session.getId());
    }

    protected void removeSession(String clusterId) {
        Session session = this._sessions.remove(clusterId);
        Log.debug((String)"Removed session {} with id {}", (Object)((Object)session), (Object)clusterId);
        SessionData sessionData = this._sessionDatas.remove(clusterId);
        Log.debug((String)"Removed session data {} with id {}", (Object)sessionData, (Object)clusterId);
        this._sessionExpirations.remove(clusterId);
    }

    public void setScavengePeriodMs(long ms) {
        ms = ms == 0L ? 60000L : ms;
        ms = ms > 60000L ? 60000L : ms;
        this._scavengePeriodMs = ms = ms < 1000L ? 1000L : ms;
        this.scheduleScavenging();
    }

    public long getScavengePeriodMs() {
        return this._scavengePeriodMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractSessionManager.Session getSession(String clusterId) {
        Session result = null;
        this.enter(clusterId);
        try {
            Map<String, Session> map = this._sessions;
            synchronized (map) {
                result = this._sessions.get(clusterId);
                if (result == null) {
                    Log.debug((String)"Session with id {} --> local cache miss", (Object)clusterId);
                    Log.debug((String)"Distributed session data with id {} --> lookup", (Object)clusterId);
                    SessionData sessionData = this._sessionDatas.get(clusterId);
                    if (sessionData == null) {
                        Log.debug((String)"Distributed session data with id {} --> not found", (Object)clusterId);
                    } else {
                        Log.debug((String)"Distributed session data with id {} --> found", (Object)clusterId);
                        result = new Session(sessionData);
                        this._sessions.put(clusterId, result);
                    }
                } else {
                    Log.debug((String)"Session with id {} --> local cache hit", (Object)clusterId);
                    if (!this._sessionExpirations.containsKey(clusterId)) {
                        this._sessions.remove(clusterId);
                        result = null;
                        Log.debug((String)"Session with id {} --> local cache stale");
                    }
                }
            }
        }
        finally {
            this.exit(clusterId);
        }
        return result;
    }

    protected String newLockId(String clusterId) {
        StringBuilder builder = new StringBuilder(clusterId);
        builder.append(":").append(this._contextPath);
        builder.append(":").append(this._virtualHost);
        return builder.toString();
    }

    public Map getSessionMap() {
        return Collections.unmodifiableMap(this._sessions);
    }

    public int getSessions() {
        return this._sessions.size();
    }

    protected Session newSession(HttpServletRequest request) {
        Session result = new Session(request);
        String requestedSessionId = request.getRequestedSessionId();
        if (requestedSessionId == null) {
            this.enter(result.getClusterId());
        } else if (!result.getClusterId().equals(this.getIdManager().getClusterId(requestedSessionId))) {
            this.enter(result.getClusterId());
        }
        return result;
    }

    protected void invalidateSessions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scavenge() {
        Thread thread = Thread.currentThread();
        ClassLoader old_loader = thread.getContextClassLoader();
        if (this._loader != null) {
            thread.setContextClassLoader(this._loader);
        }
        try {
            long now = System.currentTimeMillis();
            Log.debug((String)(this + " scavenging at {}, scavenge period {}"), (Object)now, (Object)this.getScavengePeriodMs());
            HashSet<String> candidates = new HashSet<String>();
            String lockId = "scavenge:" + this._contextPath + ":" + this._virtualHost;
            Lock.lock(lockId);
            try {
                Map<String, Session> map = this._sessions;
                synchronized (map) {
                    Hashtable<String, MutableLong> hashtable = this._sessionExpirations;
                    synchronized (hashtable) {
                        Enumeration<String> keys = this._sessionExpirations.keys();
                        while (keys.hasMoreElements()) {
                            String sessionId = keys.nextElement();
                            MutableLong value = this._sessionExpirations.get(sessionId);
                            if (value == null) continue;
                            long expirationTime = value.value;
                            Log.debug((String)"Estimated expiration time {} for session {}", (Object)expirationTime, (Object)sessionId);
                            if (expirationTime <= 0L || expirationTime >= now) continue;
                            candidates.add(sessionId);
                        }
                        this._sessions.keySet().retainAll(Collections.list(this._sessionExpirations.keys()));
                    }
                }
            }
            finally {
                Lock.unlock(lockId);
            }
            Log.debug((String)"Scavenging detected {} candidate sessions to expire", (Object)candidates.size());
            for (String sessionId : candidates) {
                boolean entered;
                Session candidate = (Session)this.getSession(sessionId);
                if (candidate == null || !(entered = this.tryEnter(sessionId))) continue;
                try {
                    long maxInactiveTime = candidate.getMaxIdlePeriodMs();
                    if (maxInactiveTime <= 0L) continue;
                    long lastAccessedTime = candidate.getLastAccessedTime();
                    long expirationTime = lastAccessedTime + maxInactiveTime + this.getScavengePeriodMs();
                    if (expirationTime < now) {
                        Log.debug((String)"Scavenging expired session {}, expirationTime {}", (Object)candidate.getClusterId(), (Object)expirationTime);
                        candidate.timeout();
                        continue;
                    }
                    Log.debug((String)"Scavenging skipping candidate session {}, expirationTime {}", (Object)candidate.getClusterId(), (Object)expirationTime);
                }
                finally {
                    this.exit(sessionId);
                }
            }
            int sessionCount = this.getSessions();
            if (sessionCount < this._minSessions) {
                this._minSessions = sessionCount;
            }
            if (sessionCount > this._maxSessions) {
                this._maxSessions = sessionCount;
            }
        }
        catch (Throwable x) {
            if (x instanceof ThreadDeath) {
                throw (ThreadDeath)x;
            }
            Log.warn((String)"Problem scavenging sessions", (Throwable)x);
        }
        finally {
            thread.setContextClassLoader(old_loader);
        }
    }

    private String canonicalize(String contextPath) {
        if (contextPath == null) {
            return "";
        }
        return contextPath.replace('/', '_').replace('.', '_').replace('\\', '_');
    }

    private String virtualHostFrom(ContextHandler.SContext context) {
        String result = "0.0.0.0";
        if (context == null) {
            return result;
        }
        String[] vhosts = context.getContextHandler().getVirtualHosts();
        if (vhosts == null || vhosts.length == 0 || vhosts[0] == null) {
            return result;
        }
        return vhosts[0];
    }

    private static class MutableLong {
        private long value;

        private MutableLong() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Lock {
        private static final ThreadLocal<Map<String, Integer>> nestings = new ThreadLocal<Map<String, Integer>>(){

            @Override
            protected Map<String, Integer> initialValue() {
                return new HashMap<String, Integer>();
            }
        };

        private Lock() {
        }

        public static void lock(String lockId) {
            Integer nestingLevel = nestings.get().get(lockId);
            if (nestingLevel == null) {
                nestingLevel = 0;
            }
            if (nestingLevel < 0) {
                throw new AssertionError((Object)("Lock(" + lockId + ") nest level = " + nestingLevel + ", thread " + Thread.currentThread() + ": " + Lock.getLocks()));
            }
            if (nestingLevel == 0) {
                ManagerUtil.beginLock((String)lockId, (int)2);
                Log.debug((String)"Lock({}) acquired by thread {}", (Object)lockId, (Object)Thread.currentThread().getName());
            }
            nestings.get().put(lockId, nestingLevel + 1);
            Log.debug((String)"Lock({}) nestings {}", (Object)lockId, Lock.getLocks());
        }

        public static boolean tryLock(String lockId) {
            boolean result = ManagerUtil.tryBeginLock((String)lockId, (int)2);
            Log.debug((String)("Lock({}) tried and" + (result ? "" : " not") + " acquired by thread {}"), (Object)lockId, (Object)Thread.currentThread().getName());
            if (result) {
                Integer nestingLevel = nestings.get().get(lockId);
                if (nestingLevel == null) {
                    nestingLevel = 0;
                }
                nestings.get().put(lockId, nestingLevel + 1);
                Log.debug((String)"Lock({}) nestings {}", (Object)lockId, Lock.getLocks());
            }
            return result;
        }

        public static void unlock(String lockId) {
            Integer nestingLevel = nestings.get().get(lockId);
            if (nestingLevel == null) {
                return;
            }
            if (nestingLevel < 1) {
                throw new AssertionError((Object)("Lock(" + lockId + ") nest level = " + nestingLevel + ", thread " + Thread.currentThread() + ": " + Lock.getLocks()));
            }
            if (nestingLevel == 1) {
                ManagerUtil.commitLock((String)lockId);
                Log.debug((String)"Lock({}) released by thread {}", (Object)lockId, (Object)Thread.currentThread().getName());
                nestings.get().remove(lockId);
            } else {
                nestings.get().put(lockId, nestingLevel - 1);
            }
            Log.debug((String)"Lock({}) nestings {}", (Object)lockId, Lock.getLocks());
        }

        protected static Map<String, Integer> getLocks() {
            return Collections.unmodifiableMap(nestings.get());
        }
    }

    public static class SessionData {
        private final String _id;
        private final Map _attributes;
        private final long _creation;
        private final MutableLong _expiration;
        private long _previousAccess;
        private long _cookieTime;

        public SessionData(String sessionId, long maxIdleMs) {
            this._id = sessionId;
            this._attributes = new HashMap();
            this._creation = System.currentTimeMillis();
            this._expiration = new MutableLong();
            this._previousAccess = this._creation;
            this._expiration.value = maxIdleMs > 0L ? this._creation + maxIdleMs : -1L;
        }

        public String getId() {
            return this._id;
        }

        protected Map getAttributeMap() {
            return this._attributes;
        }

        public long getCreationTime() {
            return this._creation;
        }

        public long getExpirationTime() {
            return this._expiration.value;
        }

        public void setExpirationTime(long time) {
            this._expiration.value = time;
        }

        public long getCookieTime() {
            return this._cookieTime;
        }

        public void setCookieTime(long time) {
            this._cookieTime = time;
        }

        public long getPreviousAccessTime() {
            return this._previousAccess;
        }

        public void setPreviousAccessTime(long time) {
            this._previousAccess = time;
        }
    }

    class Session
    extends AbstractSessionManager.Session {
        private static final long serialVersionUID = -2134521374206116367L;
        private final SessionData _sessionData;
        private long _lastUpdate;

        protected Session(HttpServletRequest request) {
            super((AbstractSessionManager)TerracottaSessionManager.this, request);
            this._sessionData = new SessionData(this.getClusterId(), this._maxIdleMs);
            this._lastAccessed = this._sessionData.getCreationTime();
        }

        protected Session(SessionData sd) {
            super((AbstractSessionManager)TerracottaSessionManager.this, sd.getCreationTime(), sd.getId());
            this._sessionData = sd;
            this._lastAccessed = this.getLastAccessedTime();
            this.initValues();
        }

        public SessionData getSessionData() {
            return this._sessionData;
        }

        public long getCookieSetTime() {
            return this._sessionData.getCookieTime();
        }

        protected void cookieSet() {
            this._sessionData.setCookieTime(this.getLastAccessedTime());
        }

        public void setMaxInactiveInterval(int secs) {
            super.setMaxInactiveInterval(secs);
            if (this._maxIdleMs > 0L && this._maxIdleMs / 10L < TerracottaSessionManager.this._scavengePeriodMs) {
                long newScavengeSecs = (secs + 9) / 10;
                TerracottaSessionManager.this.setScavengePeriodMs(1000L * newScavengeSecs);
            }
            if (secs < 0) {
                this._sessionData._expiration.value = -1L;
            } else {
                this._sessionData._expiration.value = System.currentTimeMillis() + 1000L * (long)secs;
            }
        }

        public long getLastAccessedTime() {
            if (!this.isValid()) {
                throw new IllegalStateException();
            }
            return this._sessionData.getPreviousAccessTime();
        }

        public long getCreationTime() throws IllegalStateException {
            if (!this.isValid()) {
                throw new IllegalStateException();
            }
            return this._sessionData.getCreationTime();
        }

        protected String getClusterId() {
            return super.getClusterId();
        }

        protected Map newAttributeMap() {
            return this._sessionData.getAttributeMap();
        }

        protected void access(long time) {
            long previousAccessTime = this.getPreviousAccessTime();
            if (time - previousAccessTime > TerracottaSessionManager.this.getScavengePeriodMs()) {
                Log.debug((String)"Out-of-date update of distributed access times: previous {} - current {}", (Object)previousAccessTime, (Object)time);
                this.updateAccessTimes(time);
            } else if (time - this._lastUpdate > TerracottaSessionManager.this.getScavengePeriodMs()) {
                Log.debug((String)"Periodic update of distributed access times: last update {} - current {}", (Object)this._lastUpdate, (Object)time);
                this.updateAccessTimes(time);
            } else {
                Log.debug((String)"Skipping update of distributed access times: previous {} - current {}", (Object)previousAccessTime, (Object)time);
            }
            super.access(time);
        }

        private void updateAccessTimes(long time) {
            this._sessionData.setPreviousAccessTime(this._accessed);
            if (this.getMaxIdlePeriodMs() > 0L) {
                this._sessionData.setExpirationTime(time + this.getMaxIdlePeriodMs());
            }
            this._lastUpdate = time;
        }

        protected void timeout() {
            super.timeout();
            Log.debug((String)"Timed out session {} with id {}", (Object)((Object)this), (Object)this.getClusterId());
        }

        public void invalidate() {
            super.invalidate();
            Log.debug((String)"Invalidated session {} with id {}", (Object)((Object)this), (Object)this.getClusterId());
        }

        private long getMaxIdlePeriodMs() {
            return this._maxIdleMs;
        }

        private long getPreviousAccessTime() {
            return super.getLastAccessedTime();
        }
    }
}

