/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.terracotta.servlet;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.SessionIdManager;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.servlet.AbstractSessionManager;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.terracotta.servlet.TerracottaSessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerracottaSessionIdManager
extends AbstractLifeCycle
implements SessionIdManager {
    private static final String __NEW_SESSION_ID = "org.mortbay.jetty.newSessionId";
    private static final String SESSION_ID_RANDOM_ALGORITHM = "SHA1PRNG";
    private static final String SESSION_ID_RANDOM_ALGORITHM_ALT = "IBMSecureRandom";
    private static final Object PRESENT = new Object();
    private final Server _server;
    private String _workerName;
    private Random _random;
    private boolean _weakRandom;
    private Map<String, Object> _sessionIds;

    public TerracottaSessionIdManager(Server server) {
        this._server = server;
    }

    public void doStart() {
        if (this._random == null) {
            try {
                this._random = SecureRandom.getInstance(SESSION_ID_RANDOM_ALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                try {
                    this._random = SecureRandom.getInstance(SESSION_ID_RANDOM_ALGORITHM_ALT);
                    this._weakRandom = false;
                }
                catch (NoSuchAlgorithmException e_alt) {
                    Log.warn((String)"Could not generate SecureRandom for session-id randomness", (Throwable)e);
                    this._random = new Random();
                    this._weakRandom = true;
                }
            }
        }
        this._random.setSeed(this._random.nextLong() ^ System.currentTimeMillis() ^ (long)((Object)((Object)this)).hashCode() ^ Runtime.getRuntime().freeMemory());
        this._sessionIds = this.newSessionIdsSet();
    }

    private Map<String, Object> newSessionIdsSet() {
        return new Hashtable<String, Object>();
    }

    public void doStop() {
    }

    public void addSession(HttpSession session) {
        String clusterId = ((TerracottaSessionManager.Session)session).getClusterId();
        this._sessionIds.put(clusterId, PRESENT);
    }

    public String getWorkerName() {
        return this._workerName;
    }

    public void setWorkerName(String workerName) {
        this._workerName = workerName;
    }

    public boolean idInUse(String clusterId) {
        return this._sessionIds.containsKey(clusterId);
    }

    public void invalidateAll(String clusterId) {
        Handler[] contexts = this._server.getChildHandlersByClass(WebAppContext.class);
        for (int i = 0; contexts != null && i < contexts.length; ++i) {
            AbstractSessionManager.Session session;
            WebAppContext webAppContext = (WebAppContext)contexts[i];
            SessionManager sessionManager = webAppContext.getSessionHandler().getSessionManager();
            if (!(sessionManager instanceof AbstractSessionManager) || (session = ((AbstractSessionManager)sessionManager).getSession(clusterId)) == null) continue;
            session.invalidate();
        }
    }

    public String newSessionId(HttpServletRequest request, long created) {
        String requested_id = request.getRequestedSessionId();
        if (requested_id != null && this.idInUse(requested_id)) {
            return requested_id;
        }
        String new_id = (String)request.getAttribute(__NEW_SESSION_ID);
        if (new_id != null && this.idInUse(new_id)) {
            return new_id;
        }
        String id = null;
        while (id == null || id.length() == 0 || this.idInUse(id)) {
            long r = this._weakRandom ? (long)((Object)((Object)this)).hashCode() ^ Runtime.getRuntime().freeMemory() ^ (long)this._random.nextInt() ^ (long)request.hashCode() << 32 : this._random.nextLong();
            r ^= created;
            if (request.getRemoteAddr() != null) {
                r ^= (long)request.getRemoteAddr().hashCode();
            }
            if (r < 0L) {
                r = -r;
            }
            id = Long.toString(r, 36);
        }
        request.setAttribute(__NEW_SESSION_ID, (Object)id);
        return id;
    }

    public void removeSession(HttpSession session) {
        String clusterId = ((TerracottaSessionManager.Session)session).getClusterId();
        this._sessionIds.remove(clusterId);
    }

    public String getClusterId(String nodeId) {
        int dot = nodeId.lastIndexOf(46);
        return dot > 0 ? nodeId.substring(0, dot) : nodeId;
    }

    public String getNodeId(String clusterId, HttpServletRequest request) {
        if (this._workerName != null) {
            return clusterId + '.' + this._workerName;
        }
        return clusterId;
    }
}

