/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.HTMLElementName;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Element
extends Segment
implements HTMLElementName {
    private final StartTag startTag;
    private final EndTag endTag;
    private Segment content = null;
    Element parentElement = NOT_CACHED;
    private int depth = -1;
    static final Element NOT_CACHED = new Element();

    Element(Source source, StartTag startTag, EndTag endTag) {
        super(source, startTag.begin, endTag == null ? startTag.end : endTag.end);
        this.startTag = startTag;
        this.endTag = endTag == null || endTag.length() == 0 ? null : endTag;
    }

    private Element() {
        this.startTag = null;
        this.endTag = null;
    }

    public Element getParentElement() {
        if (this.parentElement == NOT_CACHED) {
            this.source.getChildElements();
            if (this.parentElement == NOT_CACHED) {
                this.parentElement = null;
            }
        }
        return this.parentElement;
    }

    public final List getChildElements() {
        return this.childElements != null ? this.childElements : this.getChildElements(-1);
    }

    final List getChildElements(int n) {
        if (n != -1) {
            this.depth = n;
        }
        if (this.childElements == null) {
            if (this.end == this.startTag.end) {
                this.childElements = Collections.EMPTY_LIST;
            } else {
                StartTag startTag;
                int n2;
                int n3 = n == -1 ? -1 : n + 1;
                this.childElements = new ArrayList();
                int n4 = this.startTag.end;
                int n5 = n2 = this.endTag == null ? this.end : this.endTag.begin;
                while ((startTag = this.source.findNextStartTag(n4)) != null && startTag.begin < n2) {
                    if (startTag.getTagType().isServerTag()) {
                        n4 = startTag.end;
                        continue;
                    }
                    Element element = startTag.getElement();
                    if (element.end > this.end && this.source.logger.isInfoEnabled()) {
                        this.source.logger.info("Child " + element.getDebugInfo() + " extends beyond end of parent " + this.getDebugInfo());
                    }
                    element.getChildElements(n3);
                    if (element.parentElement == NOT_CACHED) {
                        element.parentElement = this;
                        this.childElements.add(element);
                    }
                    n4 = element.end;
                }
            }
        }
        return this.childElements;
    }

    public int getDepth() {
        if (this.depth == -1) {
            this.getParentElement();
            if (this.depth == -1) {
                this.depth = 0;
            }
        }
        return this.depth;
    }

    public Segment getContent() {
        if (this.content == null) {
            this.content = new Segment(this.source, this.startTag.end, this.getContentEnd());
        }
        return this.content;
    }

    public StartTag getStartTag() {
        return this.startTag;
    }

    public EndTag getEndTag() {
        return this.endTag;
    }

    public String getName() {
        return this.startTag.getName();
    }

    public boolean isEmpty() {
        return this.startTag.end == this.getContentEnd();
    }

    public boolean isEmptyElementTag() {
        return this.isEmpty() && this.startTag.isEmptyElementTag();
    }

    public Attributes getAttributes() {
        return this.getStartTag().getAttributes();
    }

    public String getAttributeValue(String string) {
        return this.getStartTag().getAttributeValue(string);
    }

    public FormControl getFormControl() {
        return FormControl.construct(this);
    }

    public String getDebugInfo() {
        if (this == NOT_CACHED) {
            return "NOT_CACHED";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Element ");
        this.startTag.appendDebugTag(stringBuffer);
        if (!this.isEmpty()) {
            stringBuffer.append('-');
        }
        if (this.endTag != null) {
            stringBuffer.append((Object)this.endTag);
        }
        stringBuffer.append(' ');
        this.startTag.appendDebugTagType(stringBuffer);
        stringBuffer.append(super.getDebugInfo());
        return stringBuffer.toString();
    }

    int getContentEnd() {
        return this.endTag != null ? this.endTag.begin : this.end;
    }
}

