/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.BZip2Constants;
import installer.CRC;
import java.io.IOException;
import java.io.InputStream;

public class CBZip2InputStream
extends InputStream
implements BZip2Constants {
    private static final int START_BLOCK_STATE = 1;
    private static final int RAND_PART_A_STATE = 2;
    private static final int RAND_PART_B_STATE = 3;
    private static final int RAND_PART_C_STATE = 4;
    private static final int NO_RAND_PART_A_STATE = 5;
    private static final int NO_RAND_PART_B_STATE = 6;
    private static final int NO_RAND_PART_C_STATE = 7;
    private CRC m_crc = new CRC();
    private boolean[] m_inUse = new boolean[256];
    private char[] m_seqToUnseq = new char[256];
    private char[] m_unseqToSeq = new char[256];
    private char[] m_selector = new char[18002];
    private char[] m_selectorMtf = new char[18002];
    private int[] m_unzftab = new int[256];
    private int[][] m_limit = new int[6][258];
    private int[][] m_base = new int[6][258];
    private int[][] m_perm = new int[6][258];
    private int[] m_minLens = new int[6];
    private boolean m_streamEnd;
    private int m_currentChar = -1;
    private int m_currentState = 1;
    private int m_rNToGo;
    private int m_rTPos;
    private int m_tPos;
    private int i2;
    private int count;
    private int chPrev;
    private int ch2;
    private int j2;
    private char z;
    private boolean m_blockRandomised;
    private int m_blockSize100k;
    private int m_bsBuff;
    private int m_bsLive;
    private InputStream m_input;
    private int m_computedBlockCRC;
    private int m_computedCombinedCRC;
    private int m_last;
    private char[] m_ll8;
    private int m_nInUse;
    private int m_origPtr;
    private int m_storedBlockCRC;
    private int m_storedCombinedCRC;
    private int[] m_tt;

    public CBZip2InputStream(InputStream inputStream) {
        this.bsSetStream(inputStream);
        this.initialize();
        this.initBlock();
        this.setupBlock();
    }

    private static void badBlockHeader() {
        CBZip2InputStream.cadvise();
    }

    private static void blockOverrun() {
        CBZip2InputStream.cadvise();
    }

    private static void cadvise() {
        System.out.println("CRC Error");
    }

    private static void compressedStreamEOF() {
        CBZip2InputStream.cadvise();
    }

    private static void crcError() {
        CBZip2InputStream.cadvise();
    }

    public int read() {
        if (this.m_streamEnd) {
            return -1;
        }
        int n = this.m_currentChar;
        switch (this.m_currentState) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.setupRandPartB();
                break;
            }
            case 4: {
                this.setupRandPartC();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.setupNoRandPartB();
                break;
            }
            case 7: {
                this.setupNoRandPartC();
                break;
            }
        }
        return n;
    }

    private void setDecompressStructureSizes(int n) {
        if (0 > n || n > 9 || 0 > this.m_blockSize100k || this.m_blockSize100k > 9) {
            // empty if block
        }
        this.m_blockSize100k = n;
        if (n == 0) {
            return;
        }
        int n2 = 100000 * n;
        this.m_ll8 = new char[n2];
        this.m_tt = new int[n2];
    }

    private void setupBlock() {
        int n;
        int[] nArray = new int[257];
        nArray[0] = 0;
        for (n = 1; n <= 256; ++n) {
            nArray[n] = this.m_unzftab[n - 1];
        }
        for (n = 1; n <= 256; ++n) {
            int n2 = n;
            nArray[n2] = nArray[n2] + nArray[n - 1];
        }
        n = 0;
        while (n <= this.m_last) {
            char c = this.m_ll8[n];
            this.m_tt[nArray[c]] = n++;
            char c2 = c;
            nArray[c2] = nArray[c2] + 1;
        }
        nArray = null;
        this.m_tPos = this.m_tt[this.m_origPtr];
        this.count = 0;
        this.i2 = 0;
        this.ch2 = 256;
        if (this.m_blockRandomised) {
            this.m_rNToGo = 0;
            this.m_rTPos = 0;
            this.setupRandPartA();
        } else {
            this.setupNoRandPartA();
        }
    }

    private void setupNoRandPartA() {
        if (this.i2 <= this.m_last) {
            this.chPrev = this.ch2;
            this.ch2 = this.m_ll8[this.m_tPos];
            this.m_tPos = this.m_tt[this.m_tPos];
            ++this.i2;
            this.m_currentChar = this.ch2;
            this.m_currentState = 6;
            this.m_crc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupNoRandPartB() {
        if (this.ch2 != this.chPrev) {
            this.m_currentState = 5;
            this.count = 1;
            this.setupNoRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.m_ll8[this.m_tPos];
                this.m_tPos = this.m_tt[this.m_tPos];
                this.m_currentState = 7;
                this.j2 = 0;
                this.setupNoRandPartC();
            } else {
                this.m_currentState = 5;
                this.setupNoRandPartA();
            }
        }
    }

    private void setupNoRandPartC() {
        if (this.j2 < this.z) {
            this.m_currentChar = this.ch2;
            this.m_crc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.m_currentState = 5;
            ++this.i2;
            this.count = 0;
            this.setupNoRandPartA();
        }
    }

    private void setupRandPartA() {
        if (this.i2 <= this.m_last) {
            this.chPrev = this.ch2;
            this.ch2 = this.m_ll8[this.m_tPos];
            this.m_tPos = this.m_tt[this.m_tPos];
            if (this.m_rNToGo == 0) {
                this.m_rNToGo = RAND_NUMS[this.m_rTPos];
                ++this.m_rTPos;
                if (this.m_rTPos == 512) {
                    this.m_rTPos = 0;
                }
            }
            --this.m_rNToGo;
            this.ch2 ^= this.m_rNToGo == 1 ? 1 : 0;
            ++this.i2;
            this.m_currentChar = this.ch2;
            this.m_currentState = 3;
            this.m_crc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupRandPartB() {
        if (this.ch2 != this.chPrev) {
            this.m_currentState = 2;
            this.count = 1;
            this.setupRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.m_ll8[this.m_tPos];
                this.m_tPos = this.m_tt[this.m_tPos];
                if (this.m_rNToGo == 0) {
                    this.m_rNToGo = RAND_NUMS[this.m_rTPos];
                    ++this.m_rTPos;
                    if (this.m_rTPos == 512) {
                        this.m_rTPos = 0;
                    }
                }
                --this.m_rNToGo;
                this.z = (char)(this.z ^ (this.m_rNToGo == 1 ? (char)'\u0001' : '\u0000'));
                this.j2 = 0;
                this.m_currentState = 4;
                this.setupRandPartC();
            } else {
                this.m_currentState = 2;
                this.setupRandPartA();
            }
        }
    }

    private void setupRandPartC() {
        if (this.j2 < this.z) {
            this.m_currentChar = this.ch2;
            this.m_crc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.m_currentState = 2;
            ++this.i2;
            this.count = 0;
            this.setupRandPartA();
        }
    }

    private void getAndMoveToFrontDecode() {
        int n;
        int n2;
        int n3;
        int n4 = 100000 * this.m_blockSize100k;
        this.m_origPtr = this.readVariableSizedInt(24);
        this.recvDecodingTables();
        int n5 = this.m_nInUse + 1;
        int n6 = -1;
        int n7 = 0;
        for (int i = 0; i <= 255; ++i) {
            this.m_unzftab[i] = 0;
        }
        char[] cArray = new char[256];
        for (n3 = 0; n3 <= 255; ++n3) {
            cArray[n3] = (char)n3;
        }
        this.m_last = -1;
        n7 = 49;
        n3 = this.m_selector[++n6];
        int n8 = this.m_minLens[n3];
        int n9 = this.bsR(n8);
        while (n9 > this.m_limit[n3][n8]) {
            ++n8;
            while (this.m_bsLive < 1) {
                try {
                    n2 = this.m_input.read();
                }
                catch (IOException iOException) {
                    CBZip2InputStream.compressedStreamEOF();
                    break;
                }
                if (n2 == -1) {
                    CBZip2InputStream.compressedStreamEOF();
                    break;
                }
                this.m_bsBuff = this.m_bsBuff << 8 | n2 & 0xFF;
                this.m_bsLive += 8;
            }
            n = this.m_bsBuff >> this.m_bsLive - 1 & 1;
            --this.m_bsLive;
            n9 = n9 << 1 | n;
        }
        int n10 = this.m_perm[n3][n9 - this.m_base[n3][n8]];
        while (n10 != n5) {
            int n11;
            int n12;
            if (n10 == 0 || n10 == 1) {
                n12 = -1;
                n11 = 1;
                do {
                    n12 = n10 == 0 ? (n12 += 1 * n11) : (n12 += 2 * n11);
                    n11 *= 2;
                    if (n7 == 0) {
                        ++n6;
                        n7 = 50;
                    }
                    --n7;
                    n3 = this.m_selector[n6];
                    n8 = this.m_minLens[n3];
                    n9 = this.bsR(n8);
                    while (n9 > this.m_limit[n3][n8]) {
                        ++n8;
                        while (this.m_bsLive < 1) {
                            char c = '\u0000';
                            try {
                                c = (char)this.m_input.read();
                            }
                            catch (IOException iOException) {
                                CBZip2InputStream.compressedStreamEOF();
                            }
                            if (c == '\uffffffff') {
                                CBZip2InputStream.compressedStreamEOF();
                            }
                            char c2 = c;
                            this.m_bsBuff = this.m_bsBuff << 8 | c2 & 0xFF;
                            this.m_bsLive += 8;
                        }
                        n = this.m_bsBuff >> this.m_bsLive - 1 & 1;
                        --this.m_bsLive;
                        n9 = n9 << 1 | n;
                    }
                } while ((n10 = this.m_perm[n3][n9 - this.m_base[n3][n8]]) == 0 || n10 == 1);
                int n13 = n2 = this.m_seqToUnseq[cArray[0]];
                this.m_unzftab[n13] = this.m_unzftab[n13] + ++n12;
                while (n12 > 0) {
                    ++this.m_last;
                    this.m_ll8[this.m_last] = n2;
                    --n12;
                }
                if (this.m_last < n4) continue;
                CBZip2InputStream.blockOverrun();
                continue;
            }
            ++this.m_last;
            if (this.m_last >= n4) {
                CBZip2InputStream.blockOverrun();
            }
            n2 = cArray[n10 - 1];
            char c = this.m_seqToUnseq[n2];
            this.m_unzftab[c] = this.m_unzftab[c] + 1;
            this.m_ll8[this.m_last] = this.m_seqToUnseq[n2];
            for (n12 = n10 - 1; n12 > 3; n12 -= 4) {
                cArray[n12] = cArray[n12 - 1];
                cArray[n12 - 1] = cArray[n12 - 2];
                cArray[n12 - 2] = cArray[n12 - 3];
                cArray[n12 - 3] = cArray[n12 - 4];
            }
            while (n12 > 0) {
                cArray[n12] = cArray[n12 - 1];
                --n12;
            }
            cArray[0] = n2;
            if (n7 == 0) {
                ++n6;
                n7 = 50;
            }
            --n7;
            n3 = this.m_selector[n6];
            n8 = this.m_minLens[n3];
            n9 = this.bsR(n8);
            while (n9 > this.m_limit[n3][n8]) {
                ++n8;
                while (this.m_bsLive < 1) {
                    n11 = 0;
                    try {
                        n11 = (char)this.m_input.read();
                    }
                    catch (IOException iOException) {
                        CBZip2InputStream.compressedStreamEOF();
                    }
                    this.m_bsBuff = this.m_bsBuff << 8 | n11 & 0xFF;
                    this.m_bsLive += 8;
                }
                n = this.m_bsBuff >> this.m_bsLive - 1 & 1;
                --this.m_bsLive;
                n9 = n9 << 1 | n;
            }
            n10 = this.m_perm[n3][n9 - this.m_base[n3][n8]];
        }
    }

    private void bsFinishedWithStream() {
        this.m_input = null;
    }

    private int readVariableSizedInt(int n) {
        return this.bsR(n);
    }

    private char readUnsignedChar() {
        return (char)this.bsR(8);
    }

    private int readInt() {
        int n = 0;
        n = n << 8 | this.bsR(8);
        n = n << 8 | this.bsR(8);
        n = n << 8 | this.bsR(8);
        n = n << 8 | this.bsR(8);
        return n;
    }

    private int bsR(int n) {
        char c;
        while (this.m_bsLive < n) {
            c = '\u0000';
            try {
                c = (char)this.m_input.read();
            }
            catch (IOException iOException) {
                CBZip2InputStream.compressedStreamEOF();
            }
            if (c == '\uffffffff') {
                CBZip2InputStream.compressedStreamEOF();
            }
            this.m_bsBuff = this.m_bsBuff << 8 | c & 0xFF;
            this.m_bsLive += 8;
        }
        c = (char)(this.m_bsBuff >> this.m_bsLive - n & (1 << n) - 1);
        this.m_bsLive -= n;
        return c;
    }

    private void bsSetStream(InputStream inputStream) {
        this.m_input = inputStream;
        this.m_bsLive = 0;
        this.m_bsBuff = 0;
    }

    private void complete() {
        this.m_storedCombinedCRC = this.readInt();
        if (this.m_storedCombinedCRC != this.m_computedCombinedCRC) {
            CBZip2InputStream.crcError();
        }
        this.bsFinishedWithStream();
        this.m_streamEnd = true;
    }

    private void endBlock() {
        this.m_computedBlockCRC = this.m_crc.getFinalCRC();
        if (this.m_storedBlockCRC != this.m_computedBlockCRC) {
            CBZip2InputStream.crcError();
        }
        this.m_computedCombinedCRC = this.m_computedCombinedCRC << 1 | this.m_computedCombinedCRC >>> 31;
        this.m_computedCombinedCRC ^= this.m_computedBlockCRC;
    }

    private void hbCreateDecodeTables(int[] nArray, int[] nArray2, int[] nArray3, char[] cArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        for (n5 = n; n5 <= n2; ++n5) {
            for (n4 = 0; n4 < n3; ++n4) {
                if (cArray[n4] != n5) continue;
                nArray3[n6] = n4;
                ++n6;
            }
        }
        for (n5 = 0; n5 < 23; ++n5) {
            nArray2[n5] = 0;
        }
        for (n5 = 0; n5 < n3; ++n5) {
            int n7 = cArray[n5] + '\u0001';
            nArray2[n7] = nArray2[n7] + 1;
        }
        for (n5 = 1; n5 < 23; ++n5) {
            int n8 = n5;
            nArray2[n8] = nArray2[n8] + nArray2[n5 - 1];
        }
        for (n5 = 0; n5 < 23; ++n5) {
            nArray[n5] = 0;
        }
        n5 = 0;
        for (n4 = n; n4 <= n2; ++n4) {
            nArray[n4] = (n5 += nArray2[n4 + 1] - nArray2[n4]) - 1;
            n5 <<= 1;
        }
        for (n4 = n + 1; n4 <= n2; ++n4) {
            nArray2[n4] = (nArray[n4 - 1] + 1 << 1) - nArray2[n4];
        }
    }

    private void initBlock() {
        char c = this.readUnsignedChar();
        char c2 = this.readUnsignedChar();
        char c3 = this.readUnsignedChar();
        char c4 = this.readUnsignedChar();
        char c5 = this.readUnsignedChar();
        char c6 = this.readUnsignedChar();
        if (c == '\u0017' && c2 == 'r' && c3 == 'E' && c4 == '8' && c5 == 'P' && c6 == '\u0090') {
            this.complete();
            return;
        }
        if (c != '1' || c2 != 'A' || c3 != 'Y' || c4 != '&' || c5 != 'S' || c6 != 'Y') {
            CBZip2InputStream.badBlockHeader();
            this.m_streamEnd = true;
            return;
        }
        this.m_storedBlockCRC = this.readInt();
        this.m_blockRandomised = this.bsR(1) == 1;
        this.getAndMoveToFrontDecode();
        this.m_crc.initialiseCRC();
        this.m_currentState = 1;
    }

    private void initialize() {
        char c = this.readUnsignedChar();
        char c2 = this.readUnsignedChar();
        if (c != 'h' || c2 < '1' || c2 > '9') {
            this.bsFinishedWithStream();
            this.m_streamEnd = true;
            return;
        }
        this.setDecompressStructureSizes(c2 - 48);
        this.m_computedCombinedCRC = 0;
    }

    private void makeMaps() {
        this.m_nInUse = 0;
        for (int i = 0; i < 256; ++i) {
            if (!this.m_inUse[i]) continue;
            this.m_seqToUnseq[this.m_nInUse] = (char)i;
            this.m_unseqToSeq[i] = (char)this.m_nInUse;
            ++this.m_nInUse;
        }
    }

    private void recvDecodingTables() {
        int n;
        int n2;
        int n3;
        int n4;
        this.buildInUseTable();
        this.makeMaps();
        int n5 = this.m_nInUse + 2;
        int n6 = this.bsR(3);
        int n7 = this.bsR(15);
        for (int i = 0; i < n7; ++i) {
            n4 = 0;
            while (this.bsR(1) == 1) {
                ++n4;
            }
            this.m_selectorMtf[i] = (char)n4;
        }
        char[] cArray = new char[6];
        for (n4 = 0; n4 < n6; n4 = (int)((char)(n4 + 1))) {
            cArray[n4] = n4;
        }
        for (n4 = 0; n4 < n7; ++n4) {
            n2 = cArray[n3];
            for (n3 = this.m_selectorMtf[n4]; n3 > 0; --n3) {
                cArray[n3] = cArray[n3 - '\u0001'];
            }
            cArray[0] = n2;
            this.m_selector[n4] = n2;
        }
        char[][] cArray2 = new char[6][258];
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = this.bsR(5);
            for (n = 0; n < n5; ++n) {
                while (this.bsR(1) == 1) {
                    if (this.bsR(1) == 0) {
                        ++n2;
                        continue;
                    }
                    --n2;
                }
                cArray2[n3][n] = (char)n2;
            }
        }
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = 32;
            n = 0;
            for (int i = 0; i < n5; ++i) {
                if (cArray2[n3][i] > n) {
                    n = cArray2[n3][i];
                }
                if (cArray2[n3][i] >= n2) continue;
                n2 = cArray2[n3][i];
            }
            this.hbCreateDecodeTables(this.m_limit[n3], this.m_base[n3], this.m_perm[n3], cArray2[n3], n2, n, n5);
            this.m_minLens[n3] = n2;
        }
    }

    private void buildInUseTable() {
        int n;
        boolean[] blArray = new boolean[16];
        for (n = 0; n < 16; ++n) {
            blArray[n] = this.bsR(1) == 1;
        }
        for (n = 0; n < 256; ++n) {
            this.m_inUse[n] = false;
        }
        for (n = 0; n < 16; ++n) {
            if (!blArray[n]) continue;
            for (int i = 0; i < 16; ++i) {
                if (this.bsR(1) != 1) continue;
                this.m_inUse[n * 16 + i] = true;
            }
        }
    }
}

