/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.Install;
import installer.InstallThread;
import installer.OperatingSystem;
import installer.Progress;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class SwingInstall
extends JFrame {
    Install installer = new Install();
    OperatingSystem.OSTask[] osTasks = OperatingSystem.getOperatingSystem().getOSTasks(this.installer);
    String appName = this.installer.getProperty("app.name");
    String appVersion = this.installer.getProperty("app.version");
    JLabel caption;
    ChooseDirectory chooseDirectory;
    SelectComponents selectComponents;
    SwingProgress progress;
    JButton cancelButton;
    JButton prevButton;
    JButton nextButton;
    Component[] pages;
    int currentPage;
    private static final int PADDING = 12;

    public SwingInstall() {
        this.setTitle(this.appName + " " + this.appVersion + " installer");
        JPanel jPanel = new JPanel(new WizardLayout());
        this.setContentPane(jPanel);
        this.caption = new JLabel();
        this.caption.setFont(new Font("SansSerif", 1, 18));
        ActionHandler actionHandler = new ActionHandler();
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setRequestFocusEnabled(false);
        this.cancelButton.addActionListener(actionHandler);
        this.prevButton = new JButton("Previous");
        this.prevButton.setRequestFocusEnabled(false);
        this.prevButton.addActionListener(actionHandler);
        this.nextButton = new JButton();
        this.nextButton.setRequestFocusEnabled(false);
        this.nextButton.addActionListener(actionHandler);
        jPanel.add(this.caption);
        jPanel.add(this.cancelButton);
        jPanel.add(this.prevButton);
        jPanel.add(this.nextButton);
        String string = OperatingSystem.getOperatingSystem().getClass().getName();
        String string2 = "done-" + string.substring(string.indexOf(36) + 1) + ".html";
        Component[] componentArray = new Component[6];
        componentArray[0] = new TextPanel(this.installer.getProperty("app.readme"));
        componentArray[1] = new TextPanel(this.installer.getProperty("app.license"));
        this.chooseDirectory = new ChooseDirectory();
        componentArray[2] = this.chooseDirectory;
        this.selectComponents = new SelectComponents();
        componentArray[3] = this.selectComponents;
        this.progress = new SwingProgress();
        componentArray[4] = this.progress;
        componentArray[5] = new TextPanel(string2);
        this.pages = componentArray;
        for (int i = 0; i < this.pages.length; ++i) {
            jPanel.add(this.pages[i]);
        }
        this.pageChanged();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowHandler());
        Dimension dimension = this.getToolkit().getScreenSize();
        this.pack();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.setVisible(true);
    }

    void install() {
        Object object2;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        JPanel jPanel = this.selectComponents.comp;
        Vector vector2 = this.selectComponents.filesets;
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            if (!((JCheckBox)jPanel.getComponent(i)).getModel().isSelected()) continue;
            n += this.installer.getIntegerProperty("comp." + vector2.elementAt(i) + ".real-size");
            vector.addElement(this.installer.getProperty("comp." + vector2.elementAt(i) + ".fileset"));
        }
        String string = this.chooseDirectory.installDir.getText();
        Map map = this.chooseDirectory.osTaskDirs;
        for (Object object2 : map.keySet()) {
            String string2 = ((JTextField)map.get(object2)).getText();
            if (string2 != null && string2.trim().length() != 0) {
                ((OperatingSystem.OSTask)object2).setEnabled(true);
                ((OperatingSystem.OSTask)object2).setDirectory(string2);
                continue;
            }
            ((OperatingSystem.OSTask)object2).setEnabled(false);
        }
        object2 = new InstallThread(this.installer, this.progress, string, this.osTasks, n, vector);
        this.progress.setThread((InstallThread)object2);
        ((Thread)object2).start();
    }

    private void pageChanged() {
        switch (this.currentPage) {
            case 0: {
                this.caption.setText("Installing " + this.appName);
                this.nextButton.setText("Next");
                this.prevButton.setEnabled(false);
                this.nextButton.setEnabled(true);
                break;
            }
            case 1: {
                this.caption.setText(this.installer.getProperty("app.license.title"));
                this.nextButton.setText("Next");
                this.prevButton.setEnabled(true);
                this.nextButton.setEnabled(true);
                break;
            }
            case 2: {
                this.caption.setText("Specify where " + this.appName + " is to be installed");
                this.nextButton.setText("Next");
                this.prevButton.setEnabled(true);
                if (this.chooseDirectory.isOK()) break;
                this.nextButton.setEnabled(false);
                break;
            }
            case 3: {
                this.caption.setText("Choose components to install");
                this.nextButton.setText("Install");
                this.prevButton.setEnabled(true);
                this.nextButton.setEnabled(true);
                break;
            }
            case 4: {
                this.caption.setText("Installing " + this.appName);
                this.nextButton.setText("Finish");
                this.prevButton.setEnabled(false);
                this.nextButton.setEnabled(false);
                this.install();
                break;
            }
            case 5: {
                this.caption.setText("Installation complete");
                this.nextButton.setText("Finish");
                this.prevButton.setEnabled(false);
                this.nextButton.setEnabled(true);
                this.cancelButton.setEnabled(false);
            }
        }
        this.getRootPane().invalidate();
        this.getRootPane().validate();
    }

    class SwingProgress
    extends JPanel
    implements Progress {
        JProgressBar progress;
        InstallThread thread;

        SwingProgress() {
            super(new BorderLayout());
            this.progress = new JProgressBar();
            this.progress.setStringPainted(true);
            this.add("North", this.progress);
        }

        public void setMaximum(final int n) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SwingProgress.this.progress.setMaximum(n);
                }
            });
        }

        public void advance(final int n) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        SwingProgress.this.progress.setValue(SwingProgress.this.progress.getValue() + n);
                    }
                });
                Thread.yield();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void done() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ++SwingInstall.this.currentPage;
                    SwingInstall.this.pageChanged();
                }
            });
        }

        public void error(final String string) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SwingInstall.this.dispose();
                    JOptionPane.showMessageDialog(null, string, "Installation aborted", 0);
                    System.exit(1);
                }
            });
        }

        public void message(final String string) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SwingProgress.this.progress.setString(string);
                }
            });
        }

        public void setThread(InstallThread installThread) {
            this.thread = installThread;
        }
    }

    class SelectComponents
    extends JPanel
    implements ActionListener {
        JPanel comp;
        JLabel sizeLabel;
        Vector filesets;

        SelectComponents() {
            super(new BorderLayout());
            this.comp = this.createCompPanel();
            this.add("North", this.comp);
            this.sizeLabel = new JLabel("", 2);
            this.add("South", this.sizeLabel);
            this.updateSize();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.updateSize();
        }

        private JPanel createCompPanel() {
            this.filesets = new Vector();
            int n = SwingInstall.this.installer.getIntegerProperty("comp.count");
            JPanel jPanel = new JPanel(new GridLayout(n, 1));
            String string = OperatingSystem.getOperatingSystem().getClass().getName();
            string = string.substring(string.indexOf(36) + 1);
            for (int i = 0; i < n; ++i) {
                String string2 = SwingInstall.this.installer.getProperty("comp." + i + ".os");
                if (string2 != null && !string.equals(string2)) continue;
                JCheckBox jCheckBox = new JCheckBox(SwingInstall.this.installer.getProperty("comp." + i + ".name") + " (" + SwingInstall.this.installer.getProperty("comp." + i + ".disk-size") + "Kb)");
                jCheckBox.getModel().setSelected(true);
                jCheckBox.addActionListener(this);
                jCheckBox.setRequestFocusEnabled(false);
                this.filesets.addElement(new Integer(i));
                jPanel.add(jCheckBox);
            }
            Dimension dimension = jPanel.getPreferredSize();
            dimension.width = Integer.MAX_VALUE;
            jPanel.setMaximumSize(dimension);
            return jPanel;
        }

        private void updateSize() {
            int n = 0;
            for (int i = 0; i < this.filesets.size(); ++i) {
                if (!((JCheckBox)this.comp.getComponent(i)).getModel().isSelected()) continue;
                n += SwingInstall.this.installer.getIntegerProperty("comp." + this.filesets.elementAt(i) + ".disk-size");
            }
            this.sizeLabel.setText("Estimated disk usage of selected components: " + n + "Kb");
        }
    }

    class ChooseDirectory
    extends JPanel {
        JTextField installDir;
        Map osTaskDirs;
        private GridBagConstraints c;

        ChooseDirectory() {
            super(new BorderLayout());
            this.c = new GridBagConstraints();
            this.osTaskDirs = new HashMap();
            JPanel jPanel = new JPanel(new GridBagLayout());
            this.installDir = this.addField(jPanel, "Install program in:", OperatingSystem.getOperatingSystem().getInstallDirectory(SwingInstall.this.appName, SwingInstall.this.appVersion));
            this.installDir.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    SwingInstall.this.nextButton.setEnabled(ChooseDirectory.this.isOK());
                }
            });
            for (int i = 0; i < SwingInstall.this.osTasks.length; ++i) {
                OperatingSystem.OSTask oSTask = SwingInstall.this.osTasks[i];
                String string = oSTask.getLabel();
                if (string == null) continue;
                JTextField jTextField = this.addField(jPanel, string, oSTask.getDirectory());
                this.osTaskDirs.put(oSTask, jTextField);
            }
            this.add("North", jPanel);
        }

        boolean isOK() {
            if (this.installDir.getText().length() == 0) {
                return false;
            }
            File file = new File(this.installDir.getText());
            return !file.exists() || file.isDirectory();
        }

        private JTextField addField(JPanel jPanel, String string, String string2) {
            ++this.c.gridy;
            JTextField jTextField = new JTextField(string2);
            this.c.insets.bottom = 3;
            this.c.gridx = 0;
            this.c.gridwidth = 3;
            this.c.insets.left = 0;
            this.c.insets.right = 0;
            this.c.anchor = 21;
            DirVerifier dirVerifier = new DirVerifier(jPanel, this.c.clone());
            jTextField.setInputVerifier(dirVerifier);
            this.c.insets.bottom = 12;
            this.c.gridx = 0;
            ++this.c.gridy;
            this.c.gridwidth = 1;
            this.c.anchor = 22;
            jPanel.add((Component)new JLabel(string, 4), this.c);
            this.c.gridx = 1;
            this.c.fill = 2;
            this.c.anchor = 10;
            this.c.insets.left = 12;
            this.c.insets.right = 12;
            this.c.weightx = 1.0;
            jPanel.add((Component)jTextField, this.c);
            JButton jButton = new JButton("Choose...");
            jButton.setRequestFocusEnabled(false);
            jButton.addActionListener(new ActionHandler(jTextField));
            this.c.gridx = 2;
            this.c.insets.left = 0;
            this.c.insets.right = 0;
            this.c.fill = 0;
            this.c.weightx = 0.0;
            jPanel.add((Component)jButton, this.c);
            return jTextField;
        }

        class ActionHandler
        implements ActionListener {
            JTextField field;

            ActionHandler(JTextField jTextField) {
                this.field = jTextField;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(this.field.getText());
                JFileChooser jFileChooser = new JFileChooser(file.getParent());
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setSelectedFile(file);
                if (jFileChooser.showOpenDialog(SwingInstall.this) == 0) {
                    this.field.setText(jFileChooser.getSelectedFile().getPath());
                    this.field.getInputVerifier().verify(this.field);
                }
            }
        }
    }

    class DirVerifier
    extends InputVerifier {
        private JTextComponent message = new JTextArea(" ");
        private Object pos;
        private JComponent parent;

        public DirVerifier(JComponent jComponent, Object object) {
            this.message.setEditable(false);
            this.message.setBackground(jComponent.getBackground());
            this.parent = jComponent;
            this.pos = object;
        }

        public boolean shouldYieldFocus(JComponent jComponent) {
            return this.verify(jComponent);
        }

        public boolean verify(JComponent jComponent) {
            if (jComponent instanceof JTextComponent) {
                String string = ((JTextComponent)jComponent).getText();
                if (this.checkNull(string) && this.checkExistNotDirectory(string) && this.checkExistNotEmpty(string) && this.checkRelative(string)) {
                    if (this.message.getParent() != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                DirVerifier.this.parent.remove(DirVerifier.this.message);
                                DirVerifier.this.parent.revalidate();
                                DirVerifier.this.parent.repaint();
                            }
                        });
                    }
                } else if (this.message.getParent() == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DirVerifier.this.parent.add((Component)DirVerifier.this.message, DirVerifier.this.pos);
                            DirVerifier.this.parent.revalidate();
                            DirVerifier.this.parent.repaint();
                        }
                    });
                } else {
                    this.message.repaint();
                }
            }
            return true;
        }

        private boolean checkNull(String string) {
            if (string.trim().length() == 0) {
                this.message.setForeground(Color.red);
                this.message.setText(SwingInstall.this.installer.getProperty("dir.null"));
                return false;
            }
            return true;
        }

        private boolean checkRelative(String string) {
            File file = new File(string);
            if (!file.isAbsolute()) {
                String string2 = SwingInstall.this.installer.getProperty("dir.relative");
                try {
                    String string3 = file.getCanonicalPath();
                    this.message.setForeground(Color.orange);
                    this.message.setText(string2 + '\n' + string3);
                }
                catch (IOException iOException) {
                    this.message.setForeground(Color.red);
                    string2 = SwingInstall.this.installer.getProperty("dir.cant-resolve");
                    this.message.setText(string2);
                }
                return false;
            }
            return true;
        }

        private boolean checkExistNotDirectory(String string) {
            File file = new File(string);
            if (file.exists() && !file.isDirectory()) {
                this.message.setForeground(Color.red);
                this.message.setText(SwingInstall.this.installer.getProperty("dir.not-directory"));
                return false;
            }
            return true;
        }

        private boolean checkExistNotEmpty(String string) {
            File file = new File(string);
            String[] stringArray = file.list();
            if (stringArray != null && stringArray.length > 0) {
                this.message.setForeground(Color.orange);
                this.message.setText(SwingInstall.this.installer.getProperty("dir.not-empty"));
                return false;
            }
            return true;
        }
    }

    class TextPanel
    extends JPanel {
        TextPanel(String string) {
            super(new BorderLayout());
            JEditorPane jEditorPane = new JEditorPane();
            try {
                jEditorPane.setPage(this.getClass().getResource(string));
            }
            catch (Exception exception) {
                jEditorPane.setText("Error loading '" + string + "'");
                exception.printStackTrace();
            }
            jEditorPane.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jEditorPane);
            Dimension dimension = new Dimension();
            dimension.width = 450;
            dimension.height = 200;
            jScrollPane.setPreferredSize(dimension);
            this.add("Center", jScrollPane);
        }
    }

    class WizardLayout
    implements LayoutManager {
        WizardLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension();
            Dimension dimension2 = SwingInstall.this.caption.getPreferredSize();
            dimension.width = dimension2.width;
            for (int i = 0; i < SwingInstall.this.pages.length; ++i) {
                Dimension dimension3 = SwingInstall.this.pages[i].getPreferredSize();
                dimension.width = Math.max(dimension3.width, dimension.width);
                dimension.height = Math.max(dimension3.height, dimension.height);
            }
            dimension.width += 24;
            dimension.height += 24;
            dimension.height += SwingInstall.this.nextButton.getPreferredSize().height;
            dimension.height += dimension2.height;
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            Dimension dimension2 = SwingInstall.this.caption.getPreferredSize();
            SwingInstall.this.caption.setBounds(12, 12, dimension2.width, dimension2.height);
            Dimension dimension3 = SwingInstall.this.cancelButton.getPreferredSize();
            dimension3.width = Math.max(dimension3.width, SwingInstall.this.prevButton.getPreferredSize().width);
            dimension3.width = Math.max(dimension3.width, SwingInstall.this.nextButton.getPreferredSize().width);
            SwingInstall.this.cancelButton.setBounds(12, dimension.height - dimension3.height - 12, dimension3.width, dimension3.height);
            SwingInstall.this.prevButton.setBounds(dimension.width - dimension3.width * 2 - 6 - 12, dimension.height - dimension3.height - 12, dimension3.width, dimension3.height);
            SwingInstall.this.nextButton.setBounds(dimension.width - dimension3.width - 12, dimension.height - dimension3.height - 12, dimension3.width, dimension3.height);
            Rectangle rectangle = new Rectangle();
            rectangle.x = 12;
            rectangle.y = 24 + dimension2.height;
            rectangle.width = dimension.width - rectangle.x - 12;
            rectangle.height = dimension.height - dimension3.height - rectangle.y - 24;
            for (int i = 0; i < SwingInstall.this.pages.length; ++i) {
                Component component = SwingInstall.this.pages[i];
                component.setBounds(rectangle);
                component.setVisible(i == SwingInstall.this.currentPage);
            }
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SwingInstall.this.cancelButton) {
                System.exit(0);
            } else if (object == SwingInstall.this.prevButton) {
                --SwingInstall.this.currentPage;
                SwingInstall.this.pageChanged();
            } else if (object == SwingInstall.this.nextButton) {
                if (SwingInstall.this.currentPage == SwingInstall.this.pages.length - 1) {
                    System.exit(0);
                } else {
                    ++SwingInstall.this.currentPage;
                    SwingInstall.this.pageChanged();
                }
            }
        }
    }
}

