/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.CBZip2InputStream;
import installer.Install;
import installer.OperatingSystem;
import installer.Progress;
import installer.ServerKiller;
import installer.TarEntry;
import installer.TarInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class InstallThread
extends Thread {
    private Install installer;
    private Progress progress;
    private String installDir;
    private OperatingSystem.OSTask[] osTasks;
    private int size;
    private Vector components;

    public InstallThread(Install install, Progress progress, String string, OperatingSystem.OSTask[] oSTaskArray, int n, Vector vector) {
        super("Install thread");
        this.installer = install;
        this.progress = progress;
        this.installDir = string;
        this.osTasks = oSTaskArray;
        this.size = n;
        this.components = vector;
    }

    public void run() {
        this.progress.setMaximum(this.size * 1024);
        this.progress.message("stopping any jEdit server");
        ServerKiller.quitjEditServer();
        try {
            int n;
            for (n = 0; n < this.components.size(); ++n) {
                String string = (String)this.components.elementAt(n);
                this.progress.message("Installing " + string);
                this.installComponent(string);
            }
            for (n = 0; n < this.osTasks.length; ++n) {
                this.progress.message("Performing task " + this.osTasks[n].getName());
                this.osTasks[n].perform(this.installDir, this.components);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.progress.error("The installer could not create the destination directory.\nMaybe you do not have write permission?");
            return;
        }
        catch (IOException iOException) {
            this.progress.error(iOException.toString());
            return;
        }
        this.progress.done();
    }

    private void installComponent(String string) throws IOException {
        TarEntry tarEntry;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getClass().getResourceAsStream(string + ".tar.bz2"));
        ((InputStream)bufferedInputStream).read();
        ((InputStream)bufferedInputStream).read();
        TarInputStream tarInputStream = new TarInputStream(new CBZip2InputStream(bufferedInputStream));
        while ((tarEntry = tarInputStream.getNextEntry()) != null) {
            if (tarEntry.isDirectory()) continue;
            String string2 = tarEntry.getName();
            String string3 = this.installDir + File.separatorChar + string2.replace('/', File.separatorChar);
            this.installer.copy(tarInputStream, string3, this.progress);
        }
        tarInputStream.close();
    }
}

