/*
 * Decompiled with CFR 0.152.
 */
package jdomain.util.gui;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import jdomain.util.Log;
import jdomain.util.Util;

public final class TextCalculator {
    private static final String SEPARATORS = " ,.;:!?\n\t";
    public static final int DEFAULT_TAB_WIDTH = 2;
    private final String text;
    private final int availableWidth;
    private final Font font;
    private String[] textLines = null;
    private final FontRenderContext renderContext;
    private final int tabWidth;

    public TextCalculator(int n, String string, Font font, boolean bl) {
        this(n, string, font, bl, 2);
    }

    public TextCalculator(int n, String string, Font font, boolean bl, int n2) {
        this.text = string;
        this.availableWidth = n;
        this.font = font;
        this.renderContext = new FontRenderContext(null, bl, true);
        Rectangle2D rectangle2D = this.font.getMaxCharBounds(this.renderContext);
        this.tabWidth = n2 * (int)Math.round(rectangle2D.getWidth() + 0.5);
        this.calculate();
    }

    public LineMetrics getMetrics() {
        return this.font.getLineMetrics("DefaultText", this.renderContext);
    }

    public static Rectangle getStringWidth(String string, Font font, boolean bl) {
        FontRenderContext fontRenderContext = new FontRenderContext(null, bl, true);
        Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
        Rectangle rectangle = new Rectangle();
        rectangle.x = (int)Math.round(rectangle2D.getX());
        rectangle.y = (int)Math.round(rectangle2D.getY());
        rectangle.width = (int)Math.round(rectangle2D.getWidth());
        rectangle.height = (int)Math.round(rectangle2D.getHeight());
        return rectangle;
    }

    public String[] getLines() {
        return this.textLines;
    }

    public JLabel createLabel() {
        StringBuffer stringBuffer = new StringBuffer("<html>");
        int n = this.getLineCount();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append("<br>");
            }
            stringBuffer.append(this.textLines[i]);
        }
        stringBuffer.append("</html>");
        return new JLabel(stringBuffer.toString());
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getLineCount();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.textLines[i]);
        }
        return stringBuffer.toString();
    }

    public int getTextHeight() {
        int n = this.getLineHeight();
        int n2 = this.textLines.length;
        return n * n2;
    }

    public int getLineHeight() {
        float f = (float)this.font.getStringBounds("\n", this.renderContext).getHeight();
        LineMetrics lineMetrics = this.font.getLineMetrics("\n", this.renderContext);
        float f2 = lineMetrics.getLeading();
        return Math.round(f + f2 + 0.5f);
    }

    public int getLineCount() {
        return this.textLines.length;
    }

    private void calculate() {
        this.calculateTextLines();
        if (Log.DEBUG) {
            Log.debug("Text broken into:");
            for (int i = 0; i < this.textLines.length; ++i) {
                Log.debug("'" + this.textLines[i] + "'");
            }
        }
    }

    public int getTextWidth() {
        int n = this.textLines.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = (int)this.font.getStringBounds(this.textLines[i], this.renderContext).getWidth();
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private void calculateTextLines() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.text, SEPARATORS, true);
        double d = 0.0;
        while (stringTokenizer.hasMoreElements()) {
            String string = stringTokenizer.nextToken();
            if (string.charAt(0) == '\n') {
                arrayList.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                d = 0.0;
                continue;
            }
            if (string.charAt(0) == '\t') {
                stringBuffer.append(string);
                d += (double)this.tabWidth;
                continue;
            }
            Util.StrippedHTMLString strippedHTMLString = Util.stripHTMLCode(stringBuffer.toString() + string);
            Util.StrippedHTMLString strippedHTMLString2 = Util.stripHTMLCode(string);
            Rectangle2D rectangle2D = this.font.getStringBounds(strippedHTMLString.stripped, this.renderContext);
            Rectangle2D rectangle2D2 = this.font.getStringBounds(strippedHTMLString2.stripped, this.renderContext);
            double d2 = rectangle2D.getWidth() - d;
            if (this.availableWidth == 0 || d + d2 <= (double)this.availableWidth) {
                stringBuffer.append(string);
                d += d2;
                continue;
            }
            arrayList.add(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            if (strippedHTMLString2.endsInHTML) {
                stringBuffer.append(strippedHTMLString2.trailingHTML);
            }
            stringBuffer.append(string);
            d = rectangle2D2.getWidth();
        }
        if (stringBuffer.length() != 0) {
            arrayList.add(stringBuffer.toString());
        }
        int n = arrayList.size();
        this.textLines = new String[n];
        arrayList.toArray(this.textLines);
    }
}

