/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import jdomain.jdraw.data.Clip;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.data.Picture;
import jdomain.jdraw.gui.ClipPanel;
import jdomain.jdraw.gui.FolderPanel;
import jdomain.jdraw.gui.GradientPanel;
import jdomain.jdraw.gui.MainFrame;
import jdomain.jdraw.gui.MouseHandler;
import jdomain.jdraw.gui.RectangularSelectionTool;
import jdomain.jdraw.gui.Tool;
import jdomain.jdraw.gui.undo.DrawPixel;
import jdomain.jdraw.gui.undo.Undoable;
import jdomain.util.gui.TextCalculator;

public final class TextTool
extends RectangularSelectionTool {
    public static final TextTool INSTANCE = new TextTool();
    private final ClipPanel textPanel = new ClipPanel(false);
    private Clip clip;
    private TextCalculator calc;
    private Image img;
    private int background;
    private Font font;
    private String text;
    private boolean drawOutline = false;

    private TextTool() {
    }

    protected void processSelection(int n) {
        int n2 = this.calc.getTextWidth();
        int n3 = this.calc.getTextHeight();
        this.clip = new Clip(n2, n3, Tool.getPicture().getPictureBackground());
        this.clip.setTransparent(Tool.getPicture().getTransparent());
        this.clip.fill(this.background);
        DrawPixel drawPixel = Undoable.calculateDifference(this.clip, this.img, 0, 0, n2, n3);
        drawPixel.redo();
        this.textPanel.setClip(0, 0, this.clip);
    }

    public Clip createClip(int n, int n2, int n3, int n4) {
        this.img = FolderPanel.INSTANCE.createOffScreenImage(n, n2, n3, n4);
        Graphics2D graphics2D = (Graphics2D)this.img.getGraphics();
        this.drawText(graphics2D);
        this.clip = new Clip(n3, n4, Tool.getPicture().getPictureBackground());
        this.clip.setTransparent(Tool.getPicture().getTransparent());
        DrawPixel drawPixel = Undoable.calculateDifference(this.clip, this.img, 0, 0, n3, n4);
        drawPixel.redo();
        this.textPanel.setClip(n, n2, this.clip);
        return this.clip;
    }

    public void process(Font font, String string, boolean bl) {
        this.font = font;
        this.text = string;
        this.drawOutline = bl;
        boolean bl2 = Tool.isAntialiasOn();
        this.calc = new TextCalculator(0, this.text, this.font, bl2);
        this.img = Tool.getDrawPanel().createImage(this.calc.getTextWidth(), this.calc.getTextHeight());
        Graphics2D graphics2D = (Graphics2D)this.img.getGraphics();
        Palette palette = Tool.getCurrentPalette();
        Picture picture = Tool.getPicture();
        this.background = picture.getTransparent();
        if (this.background == -1) {
            this.background = picture.getBackground();
        }
        graphics2D.setColor(palette.getColour(picture.getBackground()).getOpaqueColour());
        graphics2D.fillRect(0, 0, this.calc.getTextWidth(), this.calc.getTextHeight());
        this.drawText(graphics2D);
        this.processSelection(0);
    }

    private void drawText(Graphics2D graphics2D) {
        Palette palette = Tool.getCurrentPalette();
        Picture picture = Tool.getPicture();
        if (Tool.isGradientFillOn()) {
            graphics2D.setColor(palette.getColour(picture.getForeground()).getOpaqueColour());
            graphics2D.setPaint(GradientPanel.INSTANCE.createGradient(new Dimension(this.calc.getTextWidth(), this.calc.getTextHeight())));
        } else {
            graphics2D.setColor(palette.getColour(picture.getForeground()).getOpaqueColour());
        }
        graphics2D.setFont(this.font);
        if (Tool.isAntialiasOn()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.drawOutline) {
            graphics2D.setStroke(new BasicStroke(1.0f));
        }
        String[] stringArray = this.calc.getLines();
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        int n = (int)this.calc.getMetrics().getAscent();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.drawOutline) {
                TextLayout textLayout = new TextLayout(stringArray[i], this.font, fontRenderContext);
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(0.0, n);
                Shape shape = textLayout.getOutline(affineTransform);
                graphics2D.draw(shape);
            } else {
                graphics2D.drawString(stringArray[i], 0, n);
            }
            n += this.calc.getLineHeight();
        }
    }

    public boolean supportsAntialias() {
        return true;
    }

    public void activate() {
        if (!this.isActive) {
            super.activate();
            MouseHandler.INSTANCE.addClip(this.textPanel);
            FolderPanel.addGridListener(this.textPanel);
        }
    }

    public void deactivate() {
        if (this.isActive) {
            super.deactivate();
            this.textPanel.deactivate();
            MouseHandler.INSTANCE.deleteClip(this.textPanel);
            MainFrame.INSTANCE.setCursor(Cursor.getDefaultCursor());
            this.textPanel.deactivate();
            FolderPanel.removeGridListener(this.textPanel);
        }
    }

    public boolean supportsGradientFill() {
        return true;
    }
}

