/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import jdomain.jdraw.gui.RectangularSelectionTool;
import jdomain.jdraw.gui.Tool;
import jdomain.jdraw.gui.undo.DrawLine;
import jdomain.jdraw.gui.undo.UndoManager;

public final class LineTool
extends RectangularSelectionTool {
    private int x1;
    private int x2;
    private int y1;
    private int y2;

    protected final void processSelection(int n) {
        DrawLine drawLine = new DrawLine(n, this.start, this.current);
        if (drawLine.isValid()) {
            UndoManager.INSTANCE.addUndoable(drawLine);
            drawLine.redo();
        }
    }

    private void calculatePoints() {
        this.x1 = this.start.x;
        this.y1 = this.start.y;
        this.x2 = this.current.x;
        this.y2 = this.current.y;
        int n = LineTool.getGrid();
        if (n > 1) {
            int n2 = n / 2;
            this.x1 = this.x1 * n + n2 + 2;
            this.y1 = this.y1 * n + n2 + 2;
            this.x2 = this.x2 * n + n2 + 2;
            this.y2 = this.y2 * n + n2 + 2;
        }
    }

    protected void drawRubberBand() {
        if (this.current == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)Tool.getDrawPanel().getGraphics();
        graphics2D.setXORMode(Color.white);
        graphics2D.setColor(Color.darkGray);
        this.calculatePoints();
        graphics2D.drawLine(this.x1, this.y1, this.x2, this.y2);
        graphics2D.setPaintMode();
    }

    public boolean supportsAntialias() {
        return true;
    }
}

