/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.action;

import java.awt.Dimension;
import javax.swing.KeyStroke;
import jdomain.jdraw.action.BlockingDrawAction;
import jdomain.jdraw.gui.ScaleDialog;
import jdomain.jdraw.gui.Tool;
import jdomain.jdraw.gui.undo.UndoManager;
import jdomain.util.Log;

public final class ScaleAction
extends BlockingDrawAction {
    private static final long serialVersionUID = 1L;
    private Dimension dimension;
    private int scaleStyle = 0;

    protected ScaleAction() {
        super("Scale Image...");
        this.setToolTipText("Scales this picture");
        this.setAccelerators(new KeyStroke[]{KeyStroke.getKeyStroke(new Character('C'), 2)});
    }

    public boolean prepareAction() {
        ScaleDialog scaleDialog = new ScaleDialog();
        scaleDialog.open();
        if (scaleDialog.getResult() == 1) {
            this.dimension = scaleDialog.getScalingDimension();
            this.scaleStyle = scaleDialog.getScalingStyle();
            return this.dimension.width != Tool.getPictureWidth() || this.dimension.height != Tool.getPictureHeight();
        }
        return false;
    }

    public void startAction() {
        Tool.getPicture().scale(this.dimension, this.scaleStyle);
        UndoManager.INSTANCE.reset();
    }

    public void finishAction() {
        Log.info("Image scaled.");
    }
}

