// Copyright (c) 2004-2005 Sun Microsystems, Inc. All rights reserved. Use is
// subject to license terms.
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the Lesser GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA

package org.jdesktop.jdic.screensaver.autogen;

/**
 * Scans an xscreensaver configuration file and stores the result in a
 * Java structure.  Most of this code is auto-generated by NetBeans.
 *
 * Example:
 * <pre>
 *     javax.xml.parsers.DocumentBuilderFactory builderFactory = javax.xml.parsers.DocumentBuilderFactory.newInstance();
 *     javax.xml.parsers.DocumentBuilder builder = builderFactory.newDocumentBuilder();
 *     org.w3c.dom.Document document = builder.parse (new org.xml.sax.InputSource (???));
 *     <font color="blue">HackConfigScanner scanner = new HackConfigScanner (document);</font>
 *     <font color="blue">scanner.visitDocument();</font>
 * </pre>
 *
 * @author  Mark Roth
 * @version generated by NetBeans XML module
 * @see org.w3c.dom.Document
 * @see org.w3c.dom.Element
 * @see org.w3c.dom.NamedNodeMap
 *
 */
public class HackConfigScanner {
    /** org.w3c.dom.Document document */
    org.w3c.dom.Document document;
    
    /** The bean to be populated while we're scanning the tree */
    private HackConfig config = new HackConfig();
    
    /** Create new HackConfigScanner with org.w3c.dom.Document. */
    public HackConfigScanner(org.w3c.dom.Document document) {
        this.document = document;
    }
    
    public HackConfig getHackConfig() {
        return this.config;
    }
    
    /** Scan through org.w3c.dom.Document document. */
    public void visitDocument() {
        org.w3c.dom.Element element = document.getDocumentElement();
        if ((element != null) && element.getTagName().equals("screensaver")) {
            visitElement_screensaver(element);
        }
        if ((element != null) && element.getTagName().equals("command")) {
            visitElement_command(element);
        }
        if ((element != null) && element.getTagName().equals("boolean")) {
            visitElement_boolean(element);
        }
        if ((element != null) && element.getTagName().equals("number")) {
            visitElement_number(element);
        }
        if ((element != null) && element.getTagName().equals("select")) {
            visitElement_select(element);
        }
        if ((element != null) && element.getTagName().equals("option")) {
            //visitElement_option(element);
        }
        if ((element != null) && element.getTagName().equals("string")) {
            visitElement_string(element);
        }
        if ((element != null) && element.getTagName().equals("file")) {
            visitElement_file(element);
        }
        if ((element != null) && element.getTagName().equals("_description")) {
            visitElement__description(element);
        }
    }
    
    /** Scan through org.w3c.dom.Element named screensaver. */
    void visitElement_screensaver(org.w3c.dom.Element element) { // <screensaver>
        // element.getValue();
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("name")) { // <screensaver name="???">
                config.setName( attr.getValue() );
            }
            if (attr.getName().equals("_label")) { // <screensaver _label="???">
                config.setLabel( attr.getValue() );
            }
        }
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    if (nodeElement.getTagName().equals("command")) {
                        visitElement_command(nodeElement);
                    }
                    if (nodeElement.getTagName().equals("boolean")) {
                        visitElement_boolean(nodeElement);
                    }
                    if (nodeElement.getTagName().equals("number")) {
                        visitElement_number(nodeElement);
                    }
                    if (nodeElement.getTagName().equals("select")) {
                        visitElement_select(nodeElement);
                    }
                    if (nodeElement.getTagName().equals("string")) {
                        visitElement_string(nodeElement);
                    }
                    if (nodeElement.getTagName().equals("file")) {
                        visitElement_file(nodeElement);
                    }
                    if (nodeElement.getTagName().equals("_description")) {
                        visitElement__description(nodeElement);
                    }
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named command. */
    void visitElement_command(org.w3c.dom.Element element) { // <command>
        // element.getValue();
        HackConfig.CommandOption option = new HackConfig.CommandOption();
        config.addOption( option );
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("arg")) { // <command arg="???">
                option.setArg( attr.getValue() );
            }
        }
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named boolean. */
    void visitElement_boolean(org.w3c.dom.Element element) { // <boolean>
        // element.getValue();
        HackConfig.BooleanOption option = new HackConfig.BooleanOption();
        config.addOption( option );
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("id")) { // <boolean id="???">
                option.setId( attr.getValue() );
            }
            if (attr.getName().equals("_label")) { // <boolean _label="???">
                option.setLabel( attr.getValue() );
            }
            if (attr.getName().equals("arg-set")) { // <boolean arg-set="???">
                option.setArgSet( attr.getValue() );
            }
            if (attr.getName().equals("arg-unset")) { // <boolean arg-unset="???">
                option.setArgUnset( attr.getValue() );
            }
        }
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named number. */
    void visitElement_number(org.w3c.dom.Element element) { // <number>
        // element.getValue();
        HackConfig.NumberOption option = new HackConfig.NumberOption();
        config.addOption( option );
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("id")) { // <number id="???">
                option.setId( attr.getValue() );
            }
            if (attr.getName().equals("type")) { // <number type="???">
                option.setType( attr.getValue() );
            }
            if (attr.getName().equals("arg")) { // <number arg="???">
                option.setArg( attr.getValue() );
            }
            if (attr.getName().equals("_label")) { // <number _label="???">
                option.setLabel( attr.getValue() );
            }
            if (attr.getName().equals("_low_label")) { // <number _low_label="???">
                option.setLowLabel( attr.getValue() );
            }
            if (attr.getName().equals("_high_label")) { // <number _high_label="???">
                option.setHighLabel( attr.getValue() );
            }
            if (attr.getName().equals("low")) { // <number low="???">
                option.setLow( attr.getValue() );
            }
            if (attr.getName().equals("high")) { // <number high="???">
                option.setHigh( attr.getValue() );
            }
            if (attr.getName().equals("default")) { // <number default="???">
                option.setDefaultValue( attr.getValue() );
            }
            if (attr.getName().equals("convert")) { // <number convert="???">
                option.setConvert( attr.getValue() );
            }
        }
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named select. */
    void visitElement_select(org.w3c.dom.Element element) { // <select>
        // element.getValue();
        HackConfig.SelectOption option = new HackConfig.SelectOption();
        config.addOption( option );
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("id")) { // <select id="???">
                option.setId( attr.getValue() );
            }
        }
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    if (nodeElement.getTagName().equals("option")) {
                        visitElement_option(option, nodeElement);
                    }
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named option. */
    void visitElement_option(HackConfig.SelectOption selectOption, org.w3c.dom.Element element) { // <option>
        // element.getValue();
        HackConfig.SelectOption.OptionOption option = 
            new HackConfig.SelectOption.OptionOption();
        selectOption.addOption( option );
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("id")) { // <option id="???">
                option.setId( attr.getValue() );
            }
            if (attr.getName().equals("_label")) { // <option _label="???">
                option.setLabel( attr.getValue() );
            }
            if (attr.getName().equals("arg-set")) { // <option arg-set="???">
                option.setArgSet( attr.getValue() );
            }
        }
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named string. */
    void visitElement_string(org.w3c.dom.Element element) { // <string>
        // element.getValue();
        HackConfig.StringOption option = new HackConfig.StringOption();
        config.addOption( option );
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("id")) { // <string id="???">
                option.setId( attr.getValue() );
            }
            if (attr.getName().equals("_label")) { // <string _label="???">
                option.setLabel( attr.getValue() );
            }
            if (attr.getName().equals("arg")) { // <string arg="???">
                option.setArg( attr.getValue() );
            }
        }
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named file. */
    void visitElement_file(org.w3c.dom.Element element) { // <file>
        // element.getValue();
        HackConfig.FileOption option = new HackConfig.FileOption();
        config.addOption( option );
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("id")) { // <file id="???">
                option.setId( attr.getValue() );
            }
            if (attr.getName().equals("_label")) { // <file _label="???">
                option.setLabel( attr.getValue() );
            }
            if (attr.getName().equals("arg")) { // <file arg="???">
                option.setArg( attr.getValue() );
            }
        }
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named _description. */
    void visitElement__description(org.w3c.dom.Element element) { // <_description>
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
                case org.w3c.dom.Node.TEXT_NODE:
                    config.setDescription( ((org.w3c.dom.Text)node).getData() );
                    break;
            }
        }
    }
    
    
}
