/*
 * Decompiled with CFR 0.152.
 */
package jdbm.htree;

import java.io.IOError;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import jdbm.PrimaryHashMap;
import jdbm.RecordListener;
import jdbm.RecordManager;
import jdbm.helper.AbstractPrimaryMap;
import jdbm.htree.HTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTreeMap<K, V>
extends AbstractPrimaryMap<K, V>
implements PrimaryHashMap<K, V> {
    protected final HTree<K, V> tree;
    protected final boolean readonly;

    public HTreeMap(HTree<K, V> tree, boolean readonly) {
        this.tree = tree;
        this.readonly = readonly;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            protected Map.Entry<K, V> newEntry(K k, V v) {
                return new AbstractMap.SimpleEntry<K, V>(k, v){
                    private static final long serialVersionUID = 978651696969194154L;

                    @Override
                    public V setValue(V arg0) {
                        HTreeMap.this.put(this.getKey(), arg0);
                        return super.setValue(arg0);
                    }
                };
            }

            @Override
            public boolean add(Map.Entry<K, V> e) {
                if (HTreeMap.this.readonly) {
                    throw new UnsupportedOperationException("readonly");
                }
                try {
                    if (e.getKey() == null) {
                        throw new NullPointerException("Can not add null key");
                    }
                    if (e.getValue().equals(HTreeMap.this.tree.find(e.getKey()))) {
                        return false;
                    }
                    HTreeMap.this.tree.put(e.getKey(), e.getValue());
                    return true;
                }
                catch (IOException e1) {
                    throw new IOError(e1);
                }
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    try {
                        if (e.getKey() != null && HTreeMap.this.tree.find(e.getKey()) != null) {
                            return true;
                        }
                    }
                    catch (IOException e1) {
                        throw new IOError(e1);
                    }
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                try {
                    final Iterator br = HTreeMap.this.tree.keys();
                    return new Iterator<Map.Entry<K, V>>(){
                        private Map.Entry<K, V> next;
                        private K lastKey;
                        {
                            this.ensureNext();
                        }

                        void ensureNext() {
                            try {
                                if (br.hasNext()) {
                                    Object k = br.next();
                                    this.next = this.newEntry(k, HTreeMap.this.tree.find(k));
                                } else {
                                    this.next = null;
                                }
                            }
                            catch (IOException e) {
                                throw new IOError(e);
                            }
                        }

                        @Override
                        public boolean hasNext() {
                            return this.next != null;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (this.next == null) {
                                throw new NoSuchElementException();
                            }
                            Map.Entry ret = this.next;
                            this.lastKey = ret.getKey();
                            this.ensureNext();
                            return ret;
                        }

                        @Override
                        public void remove() {
                            if (HTreeMap.this.readonly) {
                                throw new UnsupportedOperationException("readonly");
                            }
                            if (this.lastKey == null) {
                                throw new IllegalStateException();
                            }
                            HTreeMap.this.remove(this.lastKey);
                            this.lastKey = null;
                        }
                    };
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }

            @Override
            public boolean remove(Object o) {
                if (HTreeMap.this.readonly) {
                    throw new UnsupportedOperationException("readonly");
                }
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    try {
                        if (e.getKey() == null || e.getValue() == null) {
                            return false;
                        }
                        Object v = HTreeMap.this.get(e.getKey());
                        if (v == null || !e.getValue().equals(v)) {
                            return false;
                        }
                        HTreeMap.this.tree.remove(e.getKey());
                        return true;
                    }
                    catch (IOException e1) {
                        throw new IOError(e1);
                    }
                }
                return false;
            }

            @Override
            public int size() {
                try {
                    int counter = 0;
                    Iterator it = HTreeMap.this.tree.keys();
                    while (it.hasNext()) {
                        it.next();
                        ++counter;
                    }
                    return counter;
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
        };
    }

    @Override
    public V get(Object key) {
        try {
            if (key == null) {
                return null;
            }
            return this.tree.find(key);
        }
        catch (ClassCastException e) {
            return null;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public V remove(Object key) {
        if (this.readonly) {
            throw new UnsupportedOperationException("readonly");
        }
        try {
            if (key == null) {
                return null;
            }
            V oldVal = this.tree.find(key);
            if (oldVal != null) {
                this.tree.remove(key);
            }
            return oldVal;
        }
        catch (ClassCastException e) {
            return null;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public V put(K key, V value) {
        if (this.readonly) {
            throw new UnsupportedOperationException("readonly");
        }
        try {
            if (key == null || value == null) {
                throw new NullPointerException("Null key or value");
            }
            V oldVal = this.tree.find(key);
            this.tree.put(key, value);
            return oldVal;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        try {
            V v = this.tree.find(key);
            return v != null;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public HTree<K, V> getTree() {
        return this.tree;
    }

    @Override
    public void addRecordListener(RecordListener<K, V> listener) {
        this.tree.addRecordListener(listener);
    }

    @Override
    public RecordManager getRecordManager() {
        return this.tree.getRecordManager();
    }

    @Override
    public void removeRecordListener(RecordListener<K, V> listener) {
        this.tree.removeRecordListener(listener);
    }

    @Override
    public void clear() {
        try {
            Iterator<K> keyIter = this.tree.keys();
            while (keyIter.hasNext()) {
                this.tree.remove(keyIter.next());
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }
}

