/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import jdbm.helper.LongPacker;
import jdbm.helper.StoreReference;
import jdbm.recman.BlockIo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Serialization {
    public static final byte END_OF_NORMAL_SERIALIZATION = 111;
    public static final boolean DEBUG = false;
    public static final boolean DEBUGSTORE = false;
    private static final int DEBUGSTORE_DUMMY_START = 456456567;
    private static final int DEBUGSTORE_DUMMY_END = 1234456;
    public static final int NULL = 0;
    public static final int NORMAL = 1;
    public static final int BOOLEAN_TRUE = 2;
    public static final int BOOLEAN_FALSE = 3;
    public static final int INTEGER_MINUS_1 = 4;
    public static final int INTEGER_0 = 5;
    public static final int INTEGER_1 = 6;
    public static final int INTEGER_2 = 7;
    public static final int INTEGER_3 = 8;
    public static final int INTEGER_4 = 9;
    public static final int INTEGER_5 = 10;
    public static final int INTEGER_6 = 11;
    public static final int INTEGER_7 = 12;
    public static final int INTEGER_8 = 13;
    public static final int INTEGER_255 = 14;
    public static final int INTEGER_PACK_NEG = 15;
    public static final int INTEGER_PACK = 16;
    public static final int LONG_MINUS_1 = 17;
    public static final int LONG_0 = 18;
    public static final int LONG_1 = 19;
    public static final int LONG_2 = 20;
    public static final int LONG_3 = 21;
    public static final int LONG_4 = 22;
    public static final int LONG_5 = 23;
    public static final int LONG_6 = 24;
    public static final int LONG_7 = 25;
    public static final int LONG_8 = 26;
    public static final int LONG_PACK_NEG = 27;
    public static final int LONG_PACK = 28;
    public static final int LONG_255 = 29;
    public static final int LONG_MINUS_MAX = 30;
    public static final int SHORT_MINUS_1 = 31;
    public static final int SHORT_0 = 32;
    public static final int SHORT_1 = 33;
    public static final int SHORT_255 = 34;
    public static final int SHORT_FULL = 35;
    public static final int BYTE_MINUS_1 = 36;
    public static final int BYTE_0 = 37;
    public static final int BYTE_1 = 38;
    public static final int BYTE_FULL = 39;
    public static final int CHAR = 40;
    public static final int FLOAT_MINUS_1 = 41;
    public static final int FLOAT_0 = 42;
    public static final int FLOAT_1 = 43;
    public static final int FLOAT_255 = 44;
    public static final int FLOAT_SHORT = 45;
    public static final int FLOAT_FULL = 46;
    public static final int DOUBLE_MINUS_1 = 47;
    public static final int DOUBLE_0 = 48;
    public static final int DOUBLE_1 = 49;
    public static final int DOUBLE_255 = 50;
    public static final int DOUBLE_SHORT = 51;
    public static final int DOUBLE_FULL = 52;
    public static final int BIGDECIMAL_255 = 53;
    public static final int BIGDECIMAL = 54;
    public static final int BIGINTEGER_255 = 55;
    public static final int BIGINTEGER = 56;
    public static final int INTEGER_MINUS_MAX = 57;
    public static final int ARRAY_INT_B_255 = 60;
    public static final int ARRAY_INT_B_INT = 61;
    public static final int ARRAY_INT_S = 62;
    public static final int ARRAY_INT_I = 63;
    public static final int ARRAY_INT_PACKED = 64;
    public static final int ARRAY_LONG_B = 65;
    public static final int ARRAY_LONG_S = 66;
    public static final int ARRAY_LONG_I = 67;
    public static final int ARRAY_LONG_L = 68;
    public static final int ARRAY_LONG_PACKED = 69;
    public static final int ARRAY_BYTE_255 = 70;
    public static final int ARRAY_BYTE_INT = 71;
    public static final int ARRAY_OBJECT_255 = 72;
    public static final int ARRAY_OBJECT = 73;
    public static final int ARRAY_OBJECT_PACKED_LONG = 74;
    public static final int ARRAYLIST_PACKED_LONG = 75;
    public static final int STRING_EMPTY = 101;
    public static final int STRING_255 = 102;
    public static final int STRING = 103;
    public static final int ARRAYLIST_255 = 104;
    public static final int ARRAYLIST = 105;
    public static final int TREEMAP_255 = 106;
    public static final int TREEMAP = 107;
    public static final int HASHMAP_255 = 108;
    public static final int HASHMAP = 109;
    public static final int LINKEDHASHMAP_255 = 110;
    public static final int LINKEDHASHMAP = 111;
    public static final int TREESET_255 = 112;
    public static final int TREESET = 113;
    public static final int HASHSET_255 = 114;
    public static final int HASHSET = 115;
    public static final int LINKEDHASHSET_255 = 116;
    public static final int LINKEDHASHSET = 117;
    public static final int LINKEDLIST_255 = 118;
    public static final int LINKEDLIST = 119;
    public static final int VECTOR_255 = 120;
    public static final int VECTOR = 121;
    public static final int HASHTABLE_255 = 122;
    public static final int HASHTABLE = 123;
    public static final int PROPERTIES_255 = 124;
    public static final int PROPERTIES = 125;
    public static final int CLASS = 126;
    public static final int STOREREFERENCE = 160;
    public static final int BLOCKIO = 161;
    public static final int BPAGE_LEAF = 162;
    public static final int BPAGE_NONLEAF = 163;
    public static final int HTREE_BUCKET = 164;
    public static final int HTREE_DIRECTORY = 165;
    public static final int JAVA_SERIALIZATION = 172;

    public static byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        DataOutputStream da = new DataOutputStream(ba);
        Serialization.writeObject(da, obj);
        da.close();
        return ba.toByteArray();
    }

    public static void writeObject(DataOutputStream out, Object obj) throws IOException {
        Class<?> clazz;
        boolean written = false;
        Class<?> clazz2 = clazz = obj != null ? obj.getClass() : null;
        if (obj == null) {
            out.write(0);
        } else if (clazz == Boolean.class) {
            if (((Boolean)obj).booleanValue()) {
                out.write(2);
            } else {
                out.write(3);
            }
        } else if (clazz == Integer.class) {
            int val = (Integer)obj;
            Serialization.writeInteger(out, val);
        } else if (clazz == Double.class) {
            double v = (Double)obj;
            if (v == -1.0) {
                out.write(47);
            } else if (v == 0.0) {
                out.write(48);
            } else if (v == 1.0) {
                out.write(49);
            } else if (v >= 0.0 && v <= 255.0 && (double)((int)v) == v) {
                out.write(50);
                out.write((int)v);
            } else if (v >= -32768.0 && v <= 32767.0 && (double)((short)v) == v) {
                out.write(51);
                out.writeShort((int)v);
            } else {
                out.write(52);
                out.writeDouble(v);
            }
        } else if (clazz == Float.class) {
            float v = ((Float)obj).floatValue();
            if (v == -1.0f) {
                out.write(41);
            } else if (v == 0.0f) {
                out.write(42);
            } else if (v == 1.0f) {
                out.write(43);
            } else if (v >= 0.0f && v <= 255.0f && (float)((int)v) == v) {
                out.write(44);
                out.write((int)v);
            } else if (v >= -32768.0f && v <= 32767.0f && (float)((short)v) == v) {
                out.write(45);
                out.writeShort((int)v);
            } else {
                out.write(46);
                out.writeFloat(v);
            }
        } else if (clazz == Long.class) {
            long val = (Long)obj;
            Serialization.writeLong(out, val);
        } else if (clazz == Short.class) {
            short val = (Short)obj;
            if (val == -1) {
                out.write(31);
            } else if (val == 0) {
                out.write(32);
            } else if (val == 1) {
                out.write(33);
            } else if (val > 0 && val < 255) {
                out.write(34);
                out.write(val);
            } else {
                out.write(35);
                out.writeShort(val);
            }
        } else if (clazz == Byte.class) {
            byte val = (Byte)obj;
            if (val == -1) {
                out.write(36);
            } else if (val == 0) {
                out.write(37);
            } else if (val == 1) {
                out.write(38);
            } else {
                out.write(35);
                out.writeByte(val);
            }
        } else if (clazz == Character.class) {
            out.write(40);
            out.writeChar(((Character)obj).charValue());
        } else if (clazz == BlockIo.class) {
            out.write(161);
            ((BlockIo)obj).writeExternal(out);
        } else if (clazz == StoreReference.class) {
            out.write(160);
            ((StoreReference)obj).writeExternal(out);
        } else if (clazz == String.class) {
            byte[] s = ((String)obj).getBytes();
            if (s.length == 0) {
                out.write(101);
            } else if (s.length < 255) {
                out.write(102);
                out.write(s.length);
            } else {
                out.write(103);
                LongPacker.packInt(out, s.length);
            }
            out.write(s);
        } else if (obj instanceof Class) {
            out.write(126);
            Serialization.writeObject(out, ((Class)obj).getName());
        } else if (obj instanceof int[]) {
            Serialization.writeIntArray(out, (int[])obj);
        } else if (obj instanceof long[]) {
            Serialization.writeLongArray(out, (long[])obj);
        } else if (obj instanceof byte[]) {
            byte[] b = (byte[])obj;
            if (b.length <= 255) {
                out.write(70);
                out.write(b.length);
            } else {
                out.write(71);
                LongPacker.packInt(out, b.length);
            }
            out.write(b);
        } else if (obj instanceof Object[]) {
            Object[] b = (Object[])obj;
            if (b.length <= 255) {
                boolean packableLongs = true;
                for (Object o : b) {
                    if (o == null || o.getClass() == Long.class && ((Long)o >= 0L || (Long)o == Long.MAX_VALUE)) continue;
                    packableLongs = false;
                    break;
                }
                if (packableLongs) {
                    out.write(74);
                    out.write(b.length);
                    for (Object o : b) {
                        if (o == null) {
                            LongPacker.packLong(out, 0L);
                            continue;
                        }
                        LongPacker.packLong(out, (Long)o + 1L);
                    }
                } else {
                    out.write(72);
                    out.write(b.length);
                    for (Object o : b) {
                        Serialization.writeObject(out, o);
                    }
                }
            } else {
                out.write(73);
                LongPacker.packInt(out, b.length);
                for (Object o : b) {
                    Serialization.writeObject(out, o);
                }
            }
        } else if (clazz == ArrayList.class) {
            ArrayList l = (ArrayList)obj;
            if (l.size() < 255) {
                boolean packableLongs = true;
                for (Object o : l) {
                    if (o == null || o.getClass() == Long.class && ((Long)o >= 0L || (Long)o == Long.MAX_VALUE)) continue;
                    packableLongs = false;
                    break;
                }
                if (packableLongs) {
                    out.write(75);
                    out.write(l.size());
                    for (Object o : l) {
                        if (o == null) {
                            LongPacker.packLong(out, 0L);
                            continue;
                        }
                        LongPacker.packLong(out, (Long)o + 1L);
                    }
                } else {
                    out.write(104);
                    out.write(l.size());
                    for (Object o : l) {
                        Serialization.writeObject(out, o);
                    }
                }
            } else {
                out.write(105);
                LongPacker.packInt(out, l.size());
                for (Object o : l) {
                    Serialization.writeObject(out, o);
                }
            }
        } else if (clazz == LinkedList.class) {
            LinkedList l = (LinkedList)obj;
            if (l.size() < 255) {
                out.write(118);
                out.write(l.size());
            } else {
                out.write(119);
                LongPacker.packInt(out, l.size());
            }
            for (Object o : l) {
                Serialization.writeObject(out, o);
            }
        } else if (clazz == Vector.class) {
            Vector l = (Vector)obj;
            if (l.size() < 255) {
                out.write(120);
                out.write(l.size());
            } else {
                out.write(121);
                LongPacker.packInt(out, l.size());
            }
            for (Object o : l) {
                Serialization.writeObject(out, o);
            }
        } else if (clazz == TreeSet.class) {
            TreeSet l = (TreeSet)obj;
            if (l.size() < 255) {
                out.write(112);
                out.write(l.size());
            } else {
                out.write(113);
                LongPacker.packInt(out, l.size());
            }
            Serialization.writeObject(out, l.comparator());
            for (Object o : l) {
                Serialization.writeObject(out, o);
            }
        } else if (clazz == HashSet.class) {
            HashSet l = (HashSet)obj;
            if (l.size() < 255) {
                out.write(114);
                out.write(l.size());
            } else {
                out.write(115);
                LongPacker.packInt(out, l.size());
            }
            for (Object o : l) {
                Serialization.writeObject(out, o);
            }
        } else if (clazz == LinkedHashSet.class) {
            LinkedHashSet l = (LinkedHashSet)obj;
            if (l.size() < 255) {
                out.write(116);
                out.write(l.size());
            } else {
                out.write(117);
                LongPacker.packInt(out, l.size());
            }
            for (Object o : l) {
                Serialization.writeObject(out, o);
            }
        } else if (clazz == TreeMap.class) {
            TreeMap l = (TreeMap)obj;
            if (l.size() < 255) {
                out.write(106);
                out.write(l.size());
            } else {
                out.write(107);
                LongPacker.packInt(out, l.size());
            }
            Serialization.writeObject(out, l.comparator());
            for (Object o : l.keySet()) {
                Serialization.writeObject(out, o);
                Serialization.writeObject(out, l.get(o));
            }
        } else if (clazz == HashMap.class) {
            HashMap l = (HashMap)obj;
            if (l.size() < 255) {
                out.write(108);
                out.write(l.size());
            } else {
                out.write(109);
                LongPacker.packInt(out, l.size());
            }
            for (Object o : l.keySet()) {
                Serialization.writeObject(out, o);
                Serialization.writeObject(out, l.get(o));
            }
        } else if (clazz == LinkedHashMap.class) {
            LinkedHashMap l = (LinkedHashMap)obj;
            if (l.size() < 255) {
                out.write(110);
                out.write(l.size());
            } else {
                out.write(111);
                LongPacker.packInt(out, l.size());
            }
            for (Object o : l.keySet()) {
                Serialization.writeObject(out, o);
                Serialization.writeObject(out, l.get(o));
            }
        } else if (clazz == Hashtable.class) {
            Hashtable l = (Hashtable)obj;
            if (l.size() < 255) {
                out.write(122);
                out.write(l.size());
            } else {
                out.write(123);
                LongPacker.packInt(out, l.size());
            }
            for (Object o : l.keySet()) {
                Serialization.writeObject(out, o);
                Serialization.writeObject(out, l.get(o));
            }
        } else if (clazz == Properties.class) {
            Properties l = (Properties)obj;
            if (l.size() < 255) {
                out.write(124);
                out.write(l.size());
            } else {
                out.write(125);
                LongPacker.packInt(out, l.size());
            }
            for (Object o : l.keySet()) {
                Serialization.writeObject(out, o);
                Serialization.writeObject(out, l.get(o));
            }
        } else {
            out.write(Serialization.serializeNormal(obj));
            out.writeByte(111);
        }
    }

    private static void writeLongArray(DataOutputStream da, long[] obj) throws IOException {
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        for (long i : obj) {
            max = Math.max(max, i);
            min = Math.min(min, i);
        }
        if (0L >= min && max <= 255L) {
            da.write(65);
            LongPacker.packInt(da, obj.length);
            for (long l : obj) {
                da.write((int)l);
            }
        } else if (0L >= min && max <= Long.MAX_VALUE) {
            da.write(69);
            LongPacker.packInt(da, obj.length);
            for (long l : obj) {
                LongPacker.packLong(da, l);
            }
        } else if (-32768L >= min && max <= 32767L) {
            da.write(66);
            LongPacker.packInt(da, obj.length);
            for (long l : obj) {
                da.writeShort((short)l);
            }
        } else if (Integer.MIN_VALUE >= min && max <= Integer.MAX_VALUE) {
            da.write(67);
            LongPacker.packInt(da, obj.length);
            for (long l : obj) {
                da.writeInt((int)l);
            }
        } else {
            da.write(68);
            LongPacker.packInt(da, obj.length);
            for (long l : obj) {
                da.writeLong(l);
            }
        }
    }

    private static void writeIntArray(DataOutputStream da, int[] obj) throws IOException {
        boolean fitsInShort;
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        for (int i : obj) {
            max = Math.max(max, i);
            min = Math.min(min, i);
        }
        boolean fitsInByte = 0 >= min && max <= 255;
        boolean bl = fitsInShort = Short.MIN_VALUE >= min && max <= Short.MAX_VALUE;
        if (obj.length <= 255 && fitsInByte) {
            da.write(60);
            da.write(obj.length);
            for (int i : obj) {
                da.write(i);
            }
        } else if (fitsInByte) {
            da.write(61);
            LongPacker.packInt(da, obj.length);
            for (int i : obj) {
                da.write(i);
            }
        } else if (0 >= min && max <= Integer.MAX_VALUE) {
            da.write(64);
            LongPacker.packInt(da, obj.length);
            for (int l : obj) {
                LongPacker.packInt(da, l);
            }
        } else if (fitsInShort) {
            da.write(62);
            LongPacker.packInt(da, obj.length);
            for (int i : obj) {
                da.writeShort(i);
            }
        } else {
            da.write(62);
            LongPacker.packInt(da, obj.length);
            for (int i : obj) {
                da.writeInt(i);
            }
        }
    }

    private static void writeInteger(DataOutputStream da, int val) throws IOException {
        if (val == -1) {
            da.write(4);
        } else if (val == 0) {
            da.write(5);
        } else if (val == 1) {
            da.write(6);
        } else if (val == 2) {
            da.write(7);
        } else if (val == 3) {
            da.write(8);
        } else if (val == 4) {
            da.write(9);
        } else if (val == 5) {
            da.write(10);
        } else if (val == 6) {
            da.write(11);
        } else if (val == 7) {
            da.write(12);
        } else if (val == 8) {
            da.write(13);
        } else if (val == Integer.MIN_VALUE) {
            da.write(57);
        } else if (val > 0 && val < 255) {
            da.write(14);
            da.write(val);
        } else if (val < 0) {
            da.write(15);
            LongPacker.packInt(da, -val);
        } else {
            da.write(16);
            LongPacker.packInt(da, val);
        }
    }

    private static void writeLong(DataOutputStream da, long val) throws IOException {
        if (val == -1L) {
            da.write(17);
        } else if (val == 0L) {
            da.write(18);
        } else if (val == 1L) {
            da.write(19);
        } else if (val == 2L) {
            da.write(20);
        } else if (val == 3L) {
            da.write(21);
        } else if (val == 4L) {
            da.write(22);
        } else if (val == 5L) {
            da.write(23);
        } else if (val == 6L) {
            da.write(24);
        } else if (val == 7L) {
            da.write(25);
        } else if (val == 8L) {
            da.write(26);
        } else if (val == Long.MIN_VALUE) {
            da.write(30);
        } else if (val > 0L && val < 255L) {
            da.write(29);
            da.write((int)val);
        } else if (val < 0L) {
            da.write(27);
            LongPacker.packLong(da, -val);
        } else {
            da.write(28);
            LongPacker.packLong(da, val);
        }
    }

    public static Object deserialize(byte[] buf) throws ClassNotFoundException, IOException {
        ByteArrayInputStream bs = new ByteArrayInputStream(buf);
        DataInputStream das = new DataInputStream(bs);
        Object ret = Serialization.readObject(das);
        if (bs.available() != 0) {
            throw new InternalError("bytes left: " + bs.available());
        }
        return ret;
    }

    private static String deserializeString(DataInputStream buf) throws IOException {
        int len = LongPacker.unpackInt(buf);
        byte[] b = new byte[len];
        buf.readFully(b);
        return new String(b);
    }

    private static String deserializeString256Smaller(DataInputStream buf) throws IOException {
        int len = buf.read();
        if (len < 0) {
            throw new EOFException();
        }
        byte[] b = new byte[len];
        buf.readFully(b);
        return new String(b);
    }

    protected static byte[] serializeNormal(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(1);
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.close();
        return baos.toByteArray();
    }

    protected static Object deserializeNormal(DataInputStream buf) throws ClassNotFoundException, IOException {
        ObjectInputStream ois = new ObjectInputStream(buf);
        Object ret = ois.readObject();
        if (buf.readByte() != 111) {
            throw new IOException("Wrong magic after serialization, maybe is Externalizable and wrong amount of bytes was read?");
        }
        return ret;
    }

    public static Object readObject(DataInputStream is) throws IOException, ClassNotFoundException {
        boolean available = false;
        Object ret = null;
        int head = is.read();
        switch (head) {
            case 0: {
                ret = null;
                break;
            }
            case 1: {
                ret = Serialization.deserializeNormal(is);
                break;
            }
            case 2: {
                ret = true;
                break;
            }
            case 3: {
                ret = false;
                break;
            }
            case 4: {
                ret = -1;
                break;
            }
            case 5: {
                ret = 0;
                break;
            }
            case 6: {
                ret = 1;
                break;
            }
            case 7: {
                ret = 2;
                break;
            }
            case 8: {
                ret = 3;
                break;
            }
            case 9: {
                ret = 4;
                break;
            }
            case 10: {
                ret = 5;
                break;
            }
            case 11: {
                ret = 6;
                break;
            }
            case 12: {
                ret = 7;
                break;
            }
            case 13: {
                ret = 8;
                break;
            }
            case 57: {
                ret = Integer.MIN_VALUE;
                break;
            }
            case 14: {
                ret = is.read();
                break;
            }
            case 15: {
                ret = -LongPacker.unpackInt(is);
                break;
            }
            case 16: {
                ret = LongPacker.unpackInt(is);
                break;
            }
            case 17: {
                ret = -1L;
                break;
            }
            case 18: {
                ret = 0L;
                break;
            }
            case 19: {
                ret = 1L;
                break;
            }
            case 20: {
                ret = 2L;
                break;
            }
            case 21: {
                ret = 3L;
                break;
            }
            case 22: {
                ret = 4L;
                break;
            }
            case 23: {
                ret = 5L;
                break;
            }
            case 24: {
                ret = 6L;
                break;
            }
            case 25: {
                ret = 7L;
                break;
            }
            case 26: {
                ret = 8L;
                break;
            }
            case 29: {
                ret = (long)is.read();
                break;
            }
            case 27: {
                ret = -LongPacker.unpackLong(is);
                break;
            }
            case 28: {
                ret = LongPacker.unpackLong(is);
                break;
            }
            case 30: {
                ret = Long.MIN_VALUE;
                break;
            }
            case 31: {
                ret = (short)-1;
                break;
            }
            case 32: {
                ret = (short)0;
                break;
            }
            case 33: {
                ret = (short)1;
                break;
            }
            case 34: {
                ret = (short)is.read();
                break;
            }
            case 35: {
                ret = is.readShort();
                break;
            }
            case 36: {
                ret = (byte)-1;
                break;
            }
            case 37: {
                ret = (byte)0;
                break;
            }
            case 38: {
                ret = (byte)1;
                break;
            }
            case 39: {
                ret = is.readByte();
                break;
            }
            case 40: {
                ret = Character.valueOf(is.readChar());
                break;
            }
            case 41: {
                ret = Float.valueOf(-1.0f);
                break;
            }
            case 42: {
                ret = Float.valueOf(0.0f);
                break;
            }
            case 43: {
                ret = Float.valueOf(1.0f);
                break;
            }
            case 44: {
                ret = Float.valueOf(is.read());
                break;
            }
            case 45: {
                ret = Float.valueOf(is.readShort());
                break;
            }
            case 46: {
                ret = Float.valueOf(is.readFloat());
                break;
            }
            case 47: {
                ret = -1.0;
                break;
            }
            case 48: {
                ret = 0.0;
                break;
            }
            case 49: {
                ret = 1.0;
                break;
            }
            case 50: {
                ret = (double)is.read();
                break;
            }
            case 51: {
                ret = (double)is.readShort();
                break;
            }
            case 52: {
                ret = is.readDouble();
                break;
            }
            case 161: {
                ret = Serialization.deserializeBlockIo(is);
                break;
            }
            case 160: {
                ret = Serialization.deserializeStoreReference(is);
                break;
            }
            case 102: {
                ret = Serialization.deserializeString256Smaller(is);
                break;
            }
            case 103: {
                ret = Serialization.deserializeString(is);
                break;
            }
            case 101: {
                ret = "";
                break;
            }
            case 104: {
                ret = Serialization.deserializeArrayList256Smaller(is);
                break;
            }
            case 105: {
                ret = Serialization.deserializeArrayList(is);
                break;
            }
            case 75: {
                ret = Serialization.deserializeArrayListPackedLong(is);
                break;
            }
            case 72: {
                ret = Serialization.deserializeArrayObject256Smaller(is);
                break;
            }
            case 73: {
                ret = Serialization.deserializeArrayObject(is);
                break;
            }
            case 74: {
                ret = Serialization.deserializeArrayObjectPackedLong(is);
                break;
            }
            case 118: {
                ret = Serialization.deserializeLinkedList256Smaller(is);
                break;
            }
            case 119: {
                ret = Serialization.deserializeLinkedList(is);
                break;
            }
            case 112: {
                ret = Serialization.deserializeTreeSet256Smaller(is);
                break;
            }
            case 113: {
                ret = Serialization.deserializeTreeSet(is);
                break;
            }
            case 114: {
                ret = Serialization.deserializeHashSet256Smaller(is);
                break;
            }
            case 115: {
                ret = Serialization.deserializeHashSet(is);
                break;
            }
            case 116: {
                ret = Serialization.deserializeLinkedHashSet256Smaller(is);
                break;
            }
            case 117: {
                ret = Serialization.deserializeLinkedHashSet(is);
                break;
            }
            case 120: {
                ret = Serialization.deserializeVector256Smaller(is);
                break;
            }
            case 121: {
                ret = Serialization.deserializeVector(is);
                break;
            }
            case 106: {
                ret = Serialization.deserializeTreeMap256Smaller(is);
                break;
            }
            case 107: {
                ret = Serialization.deserializeTreeMap(is);
                break;
            }
            case 108: {
                ret = Serialization.deserializeHashMap256Smaller(is);
                break;
            }
            case 109: {
                ret = Serialization.deserializeHashMap(is);
                break;
            }
            case 110: {
                ret = Serialization.deserializeLinkedHashMap256Smaller(is);
                break;
            }
            case 111: {
                ret = Serialization.deserializeLinkedHashMap(is);
                break;
            }
            case 122: {
                ret = Serialization.deserializeHashtable256Smaller(is);
                break;
            }
            case 123: {
                ret = Serialization.deserializeHashtable(is);
                break;
            }
            case 124: {
                ret = Serialization.deserializeProperties256Smaller(is);
                break;
            }
            case 125: {
                ret = Serialization.deserializeProperties(is);
                break;
            }
            case 126: {
                ret = Serialization.deserializeClass(is);
                break;
            }
            case 60: {
                ret = Serialization.deserializeArrayIntB255(is);
                break;
            }
            case 61: {
                ret = Serialization.deserializeArrayIntBInt(is);
                break;
            }
            case 62: {
                ret = Serialization.deserializeArrayIntSInt(is);
                break;
            }
            case 63: {
                ret = Serialization.deserializeArrayIntIInt(is);
                break;
            }
            case 64: {
                ret = Serialization.deserializeArrayIntPack(is);
                break;
            }
            case 65: {
                ret = Serialization.deserializeArrayLongB(is);
                break;
            }
            case 66: {
                ret = Serialization.deserializeArrayLongS(is);
                break;
            }
            case 67: {
                ret = Serialization.deserializeArrayLongI(is);
                break;
            }
            case 68: {
                ret = Serialization.deserializeArrayLongL(is);
                break;
            }
            case 69: {
                ret = Serialization.deserializeArrayLongPack(is);
                break;
            }
            case 70: {
                ret = Serialization.deserializeArrayByte255(is);
                break;
            }
            case 71: {
                ret = Serialization.deserializeArrayByteInt(is);
                break;
            }
            case 162: {
                throw new InternalError("BPage header, wrong serializer used");
            }
            case 163: {
                throw new InternalError("BPage header, wrong serializer used");
            }
            case 172: {
                throw new InternalError("Wrong header, data were propably serialized with OutputStream, not with JDBM serialization");
            }
            case -1: {
                throw new EOFException();
            }
            default: {
                throw new InternalError("Unknown serialization header: " + head);
            }
        }
        return ret;
    }

    private static Class deserializeClass(DataInputStream is) throws IOException, ClassNotFoundException {
        String className = (String)Serialization.readObject(is);
        Class<?> cls = Class.forName(className);
        return cls;
    }

    private static StoreReference deserializeStoreReference(DataInputStream is) throws IOException {
        StoreReference r = new StoreReference();
        r.readExternal(is);
        return r;
    }

    private static byte[] deserializeArrayByteInt(DataInputStream is) throws IOException {
        int size = LongPacker.unpackInt(is);
        byte[] b = new byte[size];
        is.readFully(b);
        return b;
    }

    private static byte[] deserializeArrayByte255(DataInputStream is) throws IOException {
        int size = is.read();
        if (size < 0) {
            throw new EOFException();
        }
        byte[] b = new byte[size];
        is.readFully(b);
        return b;
    }

    private static long[] deserializeArrayLongL(DataInputStream is) throws IOException {
        int size = LongPacker.unpackInt(is);
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readLong();
        }
        return ret;
    }

    private static long[] deserializeArrayLongI(DataInputStream is) throws IOException {
        int size = LongPacker.unpackInt(is);
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readInt();
        }
        return ret;
    }

    private static long[] deserializeArrayLongS(DataInputStream is) throws IOException {
        int size = LongPacker.unpackInt(is);
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readShort();
        }
        return ret;
    }

    private static long[] deserializeArrayLongB(DataInputStream is) throws IOException {
        int size = LongPacker.unpackInt(is);
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.read();
            if (ret[i] >= 0L) continue;
            throw new EOFException();
        }
        return ret;
    }

    private static int[] deserializeArrayIntIInt(DataInputStream is) throws IOException {
        int size = LongPacker.unpackInt(is);
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readInt();
        }
        return ret;
    }

    private static int[] deserializeArrayIntSInt(DataInputStream is) throws IOException {
        int size = LongPacker.unpackInt(is);
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readShort();
        }
        return ret;
    }

    private static int[] deserializeArrayIntBInt(DataInputStream is) throws IOException {
        int size = LongPacker.unpackInt(is);
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.read();
            if (ret[i] >= 0) continue;
            throw new EOFException();
        }
        return ret;
    }

    private static int[] deserializeArrayIntPack(DataInputStream is) throws IOException {
        int size = LongPacker.unpackInt(is);
        if (size < 0) {
            throw new EOFException();
        }
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = LongPacker.unpackInt(is);
        }
        return ret;
    }

    private static long[] deserializeArrayLongPack(DataInputStream is) throws IOException {
        int size = LongPacker.unpackInt(is);
        if (size < 0) {
            throw new EOFException();
        }
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = LongPacker.unpackLong(is);
        }
        return ret;
    }

    private static int[] deserializeArrayIntB255(DataInputStream is) throws IOException {
        int size = is.read();
        if (size < 0) {
            throw new EOFException();
        }
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.read();
            if (ret[i] >= 0) continue;
            throw new EOFException();
        }
        return ret;
    }

    private static BlockIo deserializeBlockIo(DataInputStream is) throws IOException, ClassNotFoundException {
        BlockIo b = new BlockIo();
        b.readExternal(is);
        return b;
    }

    private static Object[] deserializeArrayObject(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        Object[] s = new Object[size];
        for (int i = 0; i < size; ++i) {
            s[i] = Serialization.readObject(is);
        }
        return s;
    }

    private static Object[] deserializeArrayObjectPackedLong(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = is.read();
        Object[] s = new Object[size];
        for (int i = 0; i < size; ++i) {
            long l = LongPacker.unpackLong(is);
            s[i] = l == 0L ? null : Long.valueOf(l - 1L);
        }
        return s;
    }

    private static Object[] deserializeArrayObject256Smaller(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = is.read();
        if (size < 0) {
            throw new EOFException();
        }
        Object[] s = new Object[size];
        for (int i = 0; i < size; ++i) {
            s[i] = Serialization.readObject(is);
        }
        return s;
    }

    private static ArrayList<Object> deserializeArrayList(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        ArrayList<Object> s = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            s.add(Serialization.readObject(is));
        }
        return s;
    }

    private static ArrayList<Object> deserializeArrayListPackedLong(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = is.read();
        if (size < 0) {
            throw new EOFException();
        }
        ArrayList<Object> s = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            long l = LongPacker.unpackLong(is);
            if (l == 0L) {
                s.add(null);
                continue;
            }
            s.add(l - 1L);
        }
        return s;
    }

    private static ArrayList<Object> deserializeArrayList256Smaller(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = is.read();
        if (size < 0) {
            throw new EOFException();
        }
        ArrayList<Object> s = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            s.add(Serialization.readObject(is));
        }
        return s;
    }

    private static LinkedList<Object> deserializeLinkedList(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        LinkedList<Object> s = new LinkedList<Object>();
        for (int i = 0; i < size; ++i) {
            s.add(Serialization.readObject(is));
        }
        return s;
    }

    private static LinkedList<Object> deserializeLinkedList256Smaller(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = is.read();
        if (size < 0) {
            throw new EOFException();
        }
        LinkedList<Object> s = new LinkedList<Object>();
        for (int i = 0; i < size; ++i) {
            s.add(Serialization.readObject(is));
        }
        return s;
    }

    private static Vector<Object> deserializeVector(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        Vector<Object> s = new Vector<Object>(size);
        for (int i = 0; i < size; ++i) {
            s.add(Serialization.readObject(is));
        }
        return s;
    }

    private static Vector<Object> deserializeVector256Smaller(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = is.read();
        if (size < 0) {
            throw new EOFException();
        }
        Vector<Object> s = new Vector<Object>(size);
        for (int i = 0; i < size; ++i) {
            s.add(Serialization.readObject(is));
        }
        return s;
    }

    private static HashSet<Object> deserializeHashSet(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        HashSet<Object> s = new HashSet<Object>(size);
        for (int i = 0; i < size; ++i) {
            s.add(Serialization.readObject(is));
        }
        return s;
    }

    private static HashSet<Object> deserializeHashSet256Smaller(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = is.read();
        if (size < 0) {
            throw new EOFException();
        }
        HashSet<Object> s = new HashSet<Object>(size);
        for (int i = 0; i < size; ++i) {
            s.add(Serialization.readObject(is));
        }
        return s;
    }

    private static LinkedHashSet<Object> deserializeLinkedHashSet(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        LinkedHashSet<Object> s = new LinkedHashSet<Object>(size);
        for (int i = 0; i < size; ++i) {
            s.add(Serialization.readObject(is));
        }
        return s;
    }

    private static LinkedHashSet<Object> deserializeLinkedHashSet256Smaller(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = is.read();
        if (size < 0) {
            throw new EOFException();
        }
        LinkedHashSet<Object> s = new LinkedHashSet<Object>(size);
        for (int i = 0; i < size; ++i) {
            s.add(Serialization.readObject(is));
        }
        return s;
    }

    private static TreeSet<Object> deserializeTreeSet(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        TreeSet<Object> s = new TreeSet<Object>();
        Comparator comparator = (Comparator)Serialization.readObject(is);
        if (comparator != null) {
            s = new TreeSet(comparator);
        }
        for (int i = 0; i < size; ++i) {
            s.add(Serialization.readObject(is));
        }
        return s;
    }

    private static TreeSet<Object> deserializeTreeSet256Smaller(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = is.read();
        if (size < 0) {
            throw new EOFException();
        }
        TreeSet<Object> s = new TreeSet<Object>();
        Object obj = Serialization.readObject(is);
        Comparator comparator = (Comparator)obj;
        if (comparator != null) {
            s = new TreeSet(comparator);
        }
        for (int i = 0; i < size; ++i) {
            s.add(Serialization.readObject(is));
        }
        return s;
    }

    private static TreeMap<Object, Object> deserializeTreeMap(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        TreeMap<Object, Object> s = new TreeMap<Object, Object>();
        Comparator comparator = (Comparator)Serialization.readObject(is);
        if (comparator != null) {
            s = new TreeMap(comparator);
        }
        for (int i = 0; i < size; ++i) {
            s.put(Serialization.readObject(is), Serialization.readObject(is));
        }
        return s;
    }

    private static TreeMap<Object, Object> deserializeTreeMap256Smaller(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = is.read();
        if (size < 0) {
            throw new EOFException();
        }
        TreeMap<Object, Object> s = new TreeMap<Object, Object>();
        Comparator comparator = (Comparator)Serialization.readObject(is);
        if (comparator != null) {
            s = new TreeMap(comparator);
        }
        for (int i = 0; i < size; ++i) {
            s.put(Serialization.readObject(is), Serialization.readObject(is));
        }
        return s;
    }

    private static HashMap<Object, Object> deserializeHashMap(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        HashMap<Object, Object> s = new HashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            s.put(Serialization.readObject(is), Serialization.readObject(is));
        }
        return s;
    }

    private static HashMap<Object, Object> deserializeHashMap256Smaller(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = is.read();
        if (size < 0) {
            throw new EOFException();
        }
        HashMap<Object, Object> s = new HashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            s.put(Serialization.readObject(is), Serialization.readObject(is));
        }
        return s;
    }

    private static LinkedHashMap<Object, Object> deserializeLinkedHashMap(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        LinkedHashMap<Object, Object> s = new LinkedHashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            s.put(Serialization.readObject(is), Serialization.readObject(is));
        }
        return s;
    }

    private static LinkedHashMap<Object, Object> deserializeLinkedHashMap256Smaller(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = is.read();
        if (size < 0) {
            throw new EOFException();
        }
        LinkedHashMap<Object, Object> s = new LinkedHashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            s.put(Serialization.readObject(is), Serialization.readObject(is));
        }
        return s;
    }

    private static Hashtable<Object, Object> deserializeHashtable(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        Hashtable<Object, Object> s = new Hashtable<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            s.put(Serialization.readObject(is), Serialization.readObject(is));
        }
        return s;
    }

    private static Hashtable<Object, Object> deserializeHashtable256Smaller(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = is.read();
        if (size < 0) {
            throw new EOFException();
        }
        Hashtable<Object, Object> s = new Hashtable<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            s.put(Serialization.readObject(is), Serialization.readObject(is));
        }
        return s;
    }

    private static Properties deserializeProperties(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        Properties s = new Properties();
        for (int i = 0; i < size; ++i) {
            s.put(Serialization.readObject(is), Serialization.readObject(is));
        }
        return s;
    }

    private static Properties deserializeProperties256Smaller(DataInputStream is) throws IOException, ClassNotFoundException {
        int size = is.read();
        if (size < 0) {
            throw new EOFException();
        }
        Properties s = new Properties();
        for (int i = 0; i < size; ++i) {
            s.put(Serialization.readObject(is), Serialization.readObject(is));
        }
        return s;
    }
}

