/*
 * Decompiled with CFR 0.152.
 */
package jdbm.htree;

import java.io.IOException;
import jdbm.Serializer;
import jdbm.SerializerInput;
import jdbm.SerializerOutput;
import jdbm.htree.HashBucket;
import jdbm.htree.HashDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HashNode<K, V> {
    static final Serializer<HashNode> SERIALIZER = new Serializer<HashNode>(){

        @Override
        public HashNode deserialize(SerializerInput ds) throws IOException {
            try {
                int i = ds.read();
                if (i == 164) {
                    HashBucket ret = new HashBucket();
                    ret.readExternal(ds);
                    if (ds.available() != 0 && ds.read() != -1) {
                        throw new InternalError("bytes left: " + ds.available() + 1);
                    }
                    return ret;
                }
                if (i == 165) {
                    HashDirectory ret = new HashDirectory();
                    ret.readExternal(ds);
                    if (ds.available() != 0 && ds.read() != -1) {
                        throw new InternalError("bytes left: " + ds.available() + 1);
                    }
                    return ret;
                }
                throw new InternalError("Wrong HTree header: " + i);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void serialize(SerializerOutput out, HashNode obj) throws IOException {
            if (obj.getClass() == HashBucket.class) {
                out.write(164);
                HashBucket b = (HashBucket)obj;
                b.writeExternal(out);
            } else {
                out.write(165);
                HashDirectory n = (HashDirectory)obj;
                n.writeExternal(out);
            }
        }
    };

    HashNode() {
    }
}

