/*
 * Decompiled with CFR 0.152.
 */
package jcckit.renderer;

import jcckit.graphic.Anchor;
import jcckit.graphic.ClippingRectangle;
import jcckit.graphic.GraphPoint;

public class Transformation {
    private final double _scale;
    private final double _x0;
    private final double _y0;

    public Transformation(int width, int height, ClippingRectangle paper, Anchor horizontalAnchor, Anchor verticalAnchor) {
        double pWidth = paper.getMaxX() - paper.getMinX();
        double pHeight = paper.getMaxY() - paper.getMinY();
        this._scale = Math.min((double)width / pWidth, (double)height / pHeight);
        this._x0 = 0.5 * (double)horizontalAnchor.getFactor() * ((double)width - this._scale * pWidth) - this._scale * paper.getMinX();
        this._y0 = 0.5 * (double)verticalAnchor.getFactor() * (this._scale * pHeight - (double)height) + (double)height + this._scale * paper.getMinY();
    }

    public int transformX(double x) {
        return Transformation.trim(this._scale * x + this._x0);
    }

    public int transformY(double y) {
        return Transformation.trim(this._y0 - this._scale * y);
    }

    public int transformWidth(double width) {
        return Transformation.trim(this._scale * width + 0.5);
    }

    public int transformHeight(double height) {
        return Transformation.trim(this._scale * height + 0.5);
    }

    private static int trim(double number) {
        return number > 32767.0 ? Short.MAX_VALUE : (number < -32768.0 ? Short.MIN_VALUE : (int)number);
    }

    public GraphPoint transformBack(int x, int y) {
        return new GraphPoint(((double)x - this._x0) / this._scale, (this._y0 - (double)y) / this._scale);
    }
}

