/*
 * Decompiled with CFR 0.152.
 */
package jcckit.renderer;

import java.awt.Color;
import java.util.Hashtable;
import jcckit.graphic.Anchor;
import jcckit.graphic.BasicGraphicalElement;
import jcckit.graphic.ClippingShape;
import jcckit.graphic.FillAttributes;
import jcckit.graphic.FontStyle;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.GraphicalComposite;
import jcckit.graphic.GraphicalCompositeRenderer;
import jcckit.graphic.LineAttributes;
import jcckit.graphic.Oval;
import jcckit.graphic.OvalRenderer;
import jcckit.graphic.Polygon;
import jcckit.graphic.PolygonRenderer;
import jcckit.graphic.Rectangle;
import jcckit.graphic.RectangleRenderer;
import jcckit.graphic.Text;
import jcckit.graphic.TextAttributes;
import jcckit.graphic.TextRenderer;
import jcckit.util.Format;

public class SVGRenderer
implements GraphicalCompositeRenderer,
PolygonRenderer,
OvalRenderer,
TextRenderer,
RectangleRenderer {
    private static final Format POLYGON_FORMAT = new Format("%9.7g,%9.7g");
    private static final Format RECT_FORMAT = new Format("<rect x='%9.7g' y='%9.7g' width='%9.7g' height='%9.7g'");
    private static final Format OVAL_FORMAT = new Format("<ellipse cx='%9.7g' cy='%9.7g' rx='%9.7g' ry='%9.7g'");
    private static final Format TEXT_FORMAT = new Format("<text x='%9.7g' y='%9.7g'");
    private static final Format ORIENTATION_FORMAT = new Format(" transform='rotate(%9.7g,%9.7g,%9.7g)'");
    private static final Format FONT_FORMAT = new Format(" font-size='%9.7g' text-anchor='");
    private static final Format COLOR_FORMAT = new Format("='#%06x'");
    private static final Format STROKE_WIDTH_FORMAT = new Format(" stroke-width='%9.7g'");
    private static final String DEFAULT_FONT_NAME = "SansSerif";
    private static final Color DEFAULT_COLOR = Color.black;
    private static final double DEFAULT_FONT_SIZE = 0.01;
    private static final int BASELINE_SHIFT_OFFSET = 41;
    private static final int BASELINE_SHIFT_FACTOR = 64;
    private static final Hashtable FONT_MAP = new Hashtable();
    private StringBuffer _document;
    private double _defaultFontSize;
    private int _level;
    private int _id;

    public SVGRenderer init(StringBuffer buffer, int initialIndentLevel, double paperSize) {
        this._document = buffer;
        this._level = initialIndentLevel;
        this._defaultFontSize = paperSize * 0.01;
        return this;
    }

    private void indentAndAdd(String text) {
        for (int i = 2 * this._level; i > 0; --i) {
            this._document.append(' ');
        }
        this._document.append(text);
    }

    public void startRendering(GraphicalComposite composite) {
        this.indentAndAdd("<g");
        ClippingShape shape = composite.getClippingShape();
        if (shape == null) {
            this._document.append(">\n");
        } else {
            this._document.append(" clip-path='url(#path").append(this._id).append(")'>\n");
        }
        ++this._level;
        if (shape != null) {
            this.indentAndAdd("<clipPath id='path");
            this._document.append(this._id++).append("'>\n");
            ++this._level;
            shape.getBoundingBox().getGraphicalElement().renderWith(this);
            --this._level;
            this.indentAndAdd("</clipPath>\n");
        }
    }

    public void finishRendering(GraphicalComposite composite) {
        --this._level;
        this.indentAndAdd("</g>\n");
    }

    public void render(Polygon polygon) {
        this.indentAndAdd(polygon.isClosed() ? "<polygon" : "<polyline");
        int n = polygon.getNumberOfPoints();
        if (n > 0) {
            this._document.append(" points='");
            for (int i = 0; i < n; ++i) {
                this._document.append(POLYGON_FORMAT.form(new double[]{polygon.getPoint(i).getX(), -polygon.getPoint(i).getY()})).append(i < n - 1 ? (char)' ' : '\'');
            }
        }
        this.addShapeAttributes(polygon);
    }

    public void render(Rectangle rectangle) {
        double width = rectangle.getWidth();
        double height = rectangle.getHeight();
        this.indentAndAdd(RECT_FORMAT.form(new double[]{rectangle.getCenter().getX() - width / 2.0, -rectangle.getCenter().getY() - height / 2.0, width, height}));
        this.addShapeAttributes(rectangle);
    }

    public void render(Oval oval) {
        this.indentAndAdd(OVAL_FORMAT.form(new double[]{oval.getCenter().getX(), -oval.getCenter().getY(), oval.getWidth() / 2.0, oval.getHeight() / 2.0}));
        this.addShapeAttributes(oval);
    }

    public void render(Text text) {
        double x = text.getPosition().getX();
        double y = -text.getPosition().getY();
        this.indentAndAdd(TEXT_FORMAT.form(new double[]{x, y}));
        TextAttributes ta = (TextAttributes)text.getGraphicAttributes();
        this.addTextAttributes(ta);
        if (ta != null && ta.getOrientationAngle() != 0.0) {
            this._document.append(ORIENTATION_FORMAT.form(new double[]{-ta.getOrientationAngle(), x, y}));
        }
        this._document.append('>');
        String str = text.getText();
        int n = str.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '&': {
                    this._document.append("&amp;");
                    continue block6;
                }
                case '<': {
                    this._document.append("&lt;");
                    continue block6;
                }
                case '>': {
                    this._document.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    this._document.append("&quot;");
                    continue block6;
                }
                default: {
                    this._document.append(c);
                }
            }
        }
        this._document.append("</text>\n");
    }

    private void addShapeAttributes(BasicGraphicalElement element) {
        GraphicAttributes ga = element.getGraphicAttributes();
        Color fillColor = null;
        if (ga instanceof FillAttributes) {
            fillColor = ((FillAttributes)ga).getFillColor();
            this.addColor(" fill", fillColor);
        }
        if (ga instanceof LineAttributes) {
            this.addLineAttributes((LineAttributes)ga, fillColor == null ? DEFAULT_COLOR : null);
        }
        this._document.append("/>\n");
    }

    private void addLineAttributes(LineAttributes attributes, Color defaultColor) {
        Color color = attributes.getLineColor();
        if (color == null) {
            color = defaultColor;
        }
        if (color != null) {
            this.addColor(" stroke", color);
            this._document.append(STROKE_WIDTH_FORMAT.form(Math.max(1.0E-6, attributes.getLineThickness())));
            double[] linePattern = attributes.getLinePattern();
            if (linePattern != null && linePattern.length > 0) {
                this._document.append(" stroke-dasharray='");
                for (int i = 0; i < linePattern.length; ++i) {
                    this._document.append(linePattern[i]).append(i < linePattern.length - 1 ? (char)',' : '\'');
                }
            }
        }
    }

    private void addTextAttributes(TextAttributes ta) {
        if (ta != null) {
            FontStyle fontStyle;
            String fontFamily;
            this.addColor(" fill", ta.getTextColor() == null ? DEFAULT_COLOR : ta.getTextColor());
            String fontName = ta.getFontName();
            if (fontName == null) {
                fontName = DEFAULT_FONT_NAME;
            }
            if ((fontFamily = (String)FONT_MAP.get(fontName)) == null) {
                fontFamily = fontName;
            }
            if ((fontStyle = ta.getFontStyle()) == FontStyle.BOLD || fontStyle == FontStyle.BOLD_ITALIC) {
                this._document.append(" font-weight='bold'");
            }
            if (fontStyle == FontStyle.ITALIC || fontStyle == FontStyle.BOLD_ITALIC) {
                this._document.append(" font-style='italic'");
            }
            this._document.append(FONT_FORMAT.form(ta.getFontSize() == 0.0 ? this._defaultFontSize : ta.getFontSize())).append(ta.getHorizontalAnchor() == Anchor.CENTER ? "middle'" : (ta.getHorizontalAnchor() == Anchor.RIGHT_TOP ? "end'" : "start'")).append(" font-family='").append(fontFamily).append("' baseline-shift='").append(41 - (ta.getVerticalAnchor() == null ? 1 : ta.getVerticalAnchor().getFactor()) * 64).append("%'");
        }
    }

    private void addColor(String name, Color color) {
        this._document.append(name);
        if (color == null) {
            this._document.append("='none'");
        } else {
            this._document.append(COLOR_FORMAT.form(color.getRGB() & 0xFFFFFF));
        }
    }

    static {
        FONT_MAP.put(DEFAULT_FONT_NAME, "sans-serif");
        FONT_MAP.put("Serif", "serif");
        FONT_MAP.put("Monospaced", "monospace");
    }
}

