/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.xbill.DNS.Cache;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Master;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameSet;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.TypedObject;
import org.xbill.DNS.ZoneTransferException;
import org.xbill.DNS.ZoneTransferIn;

public class Zone
extends NameSet {
    public static final int PRIMARY = 1;
    public static final int SECONDARY = 2;
    private int type;
    private Name origin;
    private int dclass = 1;
    private RRset NS;
    private SOARecord SOA;
    private boolean hasWild;

    private void validate() throws IOException {
        RRset rrset = (RRset)this.findExactSet(this.origin, 6);
        if (rrset == null || rrset.size() != 1) {
            throw new IOException(this.origin + ": exactly 1 SOA must be specified");
        }
        Iterator it = rrset.rrs();
        this.SOA = (SOARecord)it.next();
        this.NS = (RRset)this.findExactSet(this.origin, 2);
        if (this.NS == null) {
            throw new IOException(this.origin + ": no NS set specified");
        }
    }

    private final void maybeAddRecord(Record record, Cache cache, Object source) throws IOException {
        int type = record.getType();
        Name name = record.getName();
        if (type == 6) {
            if (!name.equals(this.origin)) {
                throw new IOException("SOA owner " + name + " does not match zone origin " + this.origin);
            }
            this.setOrigin(this.origin);
            this.dclass = record.getDClass();
        }
        if (this.origin == null && type != 6) {
            throw new IOException("non-SOA record seen at " + name + " with no origin set");
        }
        if (name.subdomain(this.origin)) {
            this.addRecord(record);
        } else if (cache != null) {
            cache.addRecord(record, (byte)2, source);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Zone(String file, Cache cache, Name initialOrigin) throws IOException {
        super(false);
        Record record;
        Master m = new Master(file, initialOrigin);
        this.origin = initialOrigin;
        while ((record = m.nextRecord()) != null) {
            void var5_5;
            this.maybeAddRecord((Record)var5_5, cache, file);
        }
        this.validate();
    }

    public Zone(Record[] records, Cache cache, Name initialOrigin) throws IOException {
        super(false);
        this.origin = initialOrigin;
        int i = 0;
        while (i < records.length) {
            this.maybeAddRecord(records[i], cache, records);
            ++i;
        }
        this.validate();
    }

    public Zone(String file, Cache cache) throws IOException {
        this(file, cache, null);
    }

    public void fromXFR(Name zone, int dclass, String remote) throws IOException, ZoneTransferException {
        if (!zone.isAbsolute()) {
            throw new RelativeNameException(zone);
        }
        DClass.check(dclass);
        this.origin = zone;
        this.dclass = dclass;
        this.type = 2;
        ZoneTransferIn xfrin = ZoneTransferIn.newAXFR(zone, remote, null);
        List records = xfrin.run();
        Iterator it = records.iterator();
        while (it.hasNext()) {
            Record rec = (Record)it.next();
            if (!rec.getName().subdomain(this.origin)) {
                if (!Options.check("verbose")) continue;
                System.err.println(rec.getName() + "is not in zone " + this.origin);
                continue;
            }
            this.addRecord(rec);
        }
        this.validate();
    }

    public Zone(Name zone, int dclass, String remote) throws IOException, ZoneTransferException {
        super(false);
        this.fromXFR(zone, dclass, remote);
    }

    public Zone(Name zone, int dclass, String remote, Cache cache) throws IOException {
        super(false);
        DClass.check(dclass);
        try {
            this.fromXFR(zone, dclass, remote);
        }
        catch (ZoneTransferException e) {
            throw new IOException(e.getMessage());
        }
    }

    public Name getOrigin() {
        return this.origin;
    }

    public RRset getNS() {
        return this.NS;
    }

    public SOARecord getSOA() {
        return this.SOA;
    }

    public int getDClass() {
        return this.dclass;
    }

    public SetResponse findRecords(Name name, int type) {
        RRset rrset;
        Object[] objects;
        SetResponse zr = null;
        Object o = this.lookup(name, type);
        if (o == null) {
            if (name.isWild() || !this.hasWild) {
                return SetResponse.ofType((byte)1);
            }
            int labels = name.labels() - this.origin.labels();
            Name tname = name;
            do {
                SetResponse sr;
                if (!(sr = this.findRecords(tname.wild(1), type)).isNXDOMAIN()) {
                    return sr;
                }
                tname = new Name(tname, 1);
            } while (labels-- >= 1);
            return SetResponse.ofType((byte)1);
        }
        if (o == NameSet.NXRRSET) {
            return SetResponse.ofType((byte)2);
        }
        if (o instanceof RRset) {
            objects = null;
            rrset = (RRset)o;
        } else {
            objects = (Object[])o;
            rrset = (RRset)objects[0];
        }
        if (name.equals(rrset.getName())) {
            if (type != 5 && type != 255 && rrset.getType() == 5) {
                zr = new SetResponse(4, rrset);
            } else if (rrset.getType() == 2 && !name.equals(this.origin)) {
                zr = new SetResponse(3, rrset);
            } else {
                zr = new SetResponse(6);
                zr.addRRset(rrset);
                if (objects != null) {
                    int i = 1;
                    while (i < objects.length) {
                        zr.addRRset((RRset)objects[i]);
                        ++i;
                    }
                }
            }
        } else if (rrset.getType() == 5) {
            zr = SetResponse.ofType((byte)1);
        } else if (rrset.getType() == 39) {
            zr = new SetResponse(5, rrset);
        } else if (rrset.getType() == 2) {
            zr = new SetResponse(3, rrset);
        }
        return zr;
    }

    public RRset findExactMatch(Name name, int type) {
        return (RRset)this.findExactSet(name, type);
    }

    public void addRecord(Record r) {
        int type;
        Name name = r.getName();
        RRset rrset = (RRset)this.findExactSet(name, type = r.getRRsetType());
        if (rrset == null) {
            rrset = new RRset();
            this.addSet(name, type, rrset);
        }
        rrset.addRR(r);
    }

    protected void addSet(Name name, int type, TypedObject set) {
        if (!this.hasWild && name.isWild()) {
            this.hasWild = true;
        }
        super.addSet(name, type, set);
    }

    public void removeRecord(Record r) {
        int type;
        Name name = r.getName();
        RRset rrset = (RRset)this.findExactSet(name, type = r.getRRsetType());
        if (rrset != null) {
            rrset.deleteRR(r);
            if (rrset.size() == 0) {
                this.removeSet(name, type, rrset);
            }
        }
    }

    public Iterator AXFR() {
        return new AXFRIterator();
    }

    public String toMasterFile() {
        Iterator znames = this.names();
        StringBuffer sb = new StringBuffer();
        while (znames.hasNext()) {
            Name name = (Name)znames.next();
            Object[] sets = this.findExactSets(name);
            int i = 0;
            while (i < sets.length) {
                RRset rrset = (RRset)sets[i];
                Iterator it = rrset.rrs();
                while (it.hasNext()) {
                    sb.append(it.next() + "\n");
                }
                it = rrset.sigs();
                while (it.hasNext()) {
                    sb.append(it.next() + "\n");
                }
                ++i;
            }
        }
        return sb.toString();
    }

    static /* synthetic */ Name access$000(Zone x0) {
        return x0.origin;
    }

    class AXFRIterator
    implements Iterator {
        private Iterator znames;
        private Name currentName;
        private Object[] current;
        int count;
        boolean sentFirstSOA;
        boolean sentNS;
        boolean sentOrigin;
        boolean sentLastSOA;

        AXFRIterator() {
            this.znames = Zone.this.names();
        }

        public boolean hasNext() {
            return !this.sentLastSOA;
        }

        /*
         * Unable to fully structure code
         */
        public Object next() {
            if (this.sentLastSOA) {
                return null;
            }
            if (!this.sentFirstSOA) {
                this.sentFirstSOA = true;
                return (RRset)Zone.this.findExactSet(Zone.access$000(Zone.this), 6);
            }
            if (!this.sentNS) {
                this.sentNS = true;
                return Zone.this.getNS();
            }
            if (!this.sentOrigin) {
                if (this.currentName == null) {
                    this.currentName = Zone.this.getOrigin();
                    this.current = Zone.this.findExactSets(this.currentName);
                    this.count = 0;
                }
                while (this.count < this.current.length) {
                    rrset = (RRset)this.current[this.count];
                    if (rrset.getType() != 6 && rrset.getType() != 2) {
                        return this.current[this.count++];
                    }
                    ++this.count;
                }
                this.current = null;
                this.sentOrigin = true;
            }
            if (this.current == null || this.count >= this.current.length) ** GOTO lbl30
            return this.current[this.count++];
lbl-1000:
            // 1 sources

            {
                currentName = (Name)this.znames.next();
                if (currentName.equals(Zone.this.getOrigin())) continue;
                this.current = Zone.this.findExactSets(currentName);
                this.count = 0;
                if (this.count >= this.current.length) continue;
                return this.current[this.count++];
lbl30:
                // 3 sources

                ** while (this.znames.hasNext())
            }
lbl31:
            // 1 sources

            this.sentLastSOA = true;
            rrset = new RRset();
            rrset.addRR(Zone.this.getSOA());
            return rrset;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

