/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.HashMap;
import org.xbill.DNS.InvalidTypeException;

public final class Type {
    public static final int A = 1;
    public static final int NS = 2;
    public static final int MD = 3;
    public static final int MF = 4;
    public static final int CNAME = 5;
    public static final int SOA = 6;
    public static final int MB = 7;
    public static final int MG = 8;
    public static final int MR = 9;
    public static final int NULL = 10;
    public static final int WKS = 11;
    public static final int PTR = 12;
    public static final int HINFO = 13;
    public static final int MINFO = 14;
    public static final int MX = 15;
    public static final int TXT = 16;
    public static final int RP = 17;
    public static final int AFSDB = 18;
    public static final int X25 = 19;
    public static final int ISDN = 20;
    public static final int RT = 21;
    public static final int NSAP = 22;
    public static final int NSAP_PTR = 23;
    public static final int SIG = 24;
    public static final int KEY = 25;
    public static final int PX = 26;
    public static final int GPOS = 27;
    public static final int AAAA = 28;
    public static final int LOC = 29;
    public static final int NXT = 30;
    public static final int EID = 31;
    public static final int NIMLOC = 32;
    public static final int SRV = 33;
    public static final int ATMA = 34;
    public static final int NAPTR = 35;
    public static final int KX = 36;
    public static final int CERT = 37;
    public static final int A6 = 38;
    public static final int DNAME = 39;
    public static final int OPT = 41;
    public static final int APL = 42;
    public static final int DS = 43;
    public static final int TKEY = 249;
    public static final int TSIG = 250;
    public static final int IXFR = 251;
    public static final int AXFR = 252;
    public static final int MAILB = 253;
    public static final int MAILA = 254;
    public static final int ANY = 255;
    private static DoubleHashMap types = new DoubleHashMap();
    private static Integer[] typecache = new Integer[44];

    private Type() {
    }

    static void check(int i) {
        if (i < 0 || i > 65535) {
            throw new InvalidTypeException(i);
        }
    }

    public static String string(int i) {
        Type.check(i);
        String s = types.getString(i);
        return s != null ? s : "TYPE" + i;
    }

    public static int value(String s) {
        Integer val = types.getValue(s = s.toUpperCase());
        if (val != null) {
            return val;
        }
        if (s.startsWith("TYPE")) {
            try {
                int type = Integer.parseInt(s.substring(4));
                if (type < 0 || type > 65535) {
                    return -1;
                }
                return type;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public static boolean isRR(int type) {
        switch (type) {
            case 41: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return false;
            }
        }
        return true;
    }

    static Integer toInteger(int type) {
        if (type >= 0 && type < typecache.length) {
            return typecache[type];
        }
        return new Integer(type);
    }

    static {
        int i = 0;
        while (i < typecache.length) {
            Type.typecache[i] = new Integer(i);
            ++i;
        }
        types.put(1, "A");
        types.put(2, "NS");
        types.put(3, "MD");
        types.put(4, "MF");
        types.put(5, "CNAME");
        types.put(6, "SOA");
        types.put(7, "MB");
        types.put(8, "MG");
        types.put(9, "MR");
        types.put(10, "NULL");
        types.put(11, "WKS");
        types.put(12, "PTR");
        types.put(13, "HINFO");
        types.put(14, "MINFO");
        types.put(15, "MX");
        types.put(16, "TXT");
        types.put(17, "RP");
        types.put(18, "AFSDB");
        types.put(19, "X25");
        types.put(20, "ISDN");
        types.put(21, "RT");
        types.put(22, "NSAP");
        types.put(23, "NSAP_PTR");
        types.put(24, "SIG");
        types.put(25, "KEY");
        types.put(26, "PX");
        types.put(27, "GPOS");
        types.put(28, "AAAA");
        types.put(29, "LOC");
        types.put(30, "NXT");
        types.put(31, "EID");
        types.put(32, "NIMLOC");
        types.put(33, "SRV");
        types.put(34, "ATMA");
        types.put(35, "NAPTR");
        types.put(36, "KX");
        types.put(37, "CERT");
        types.put(38, "A6");
        types.put(39, "DNAME");
        types.put(41, "OPT");
        types.put(42, "APL");
        types.put(43, "DS");
        types.put(249, "TKEY");
        types.put(250, "TSIG");
        types.put(251, "IXFR");
        types.put(252, "AXFR");
        types.put(253, "MAILB");
        types.put(254, "MAILA");
        types.put(255, "ANY");
    }

    private static class DoubleHashMap {
        private HashMap byString = new HashMap();
        private HashMap byInteger = new HashMap();

        public void put(int value, String string) {
            Integer i = Type.toInteger(value);
            this.byInteger.put(i, string);
            this.byString.put(string, i);
        }

        public Integer getValue(String string) {
            return (Integer)this.byString.get(string);
        }

        public String getString(int value) {
            return (String)this.byInteger.get(Type.toInteger(value));
        }
    }
}

