/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.TTL;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.Type;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.base64;

public class SIGRecord
extends Record {
    private static SIGRecord member = new SIGRecord();
    private int covered;
    private int alg;
    private int labels;
    private long origttl;
    private Date expire;
    private Date timeSigned;
    private int footprint;
    private Name signer;
    private byte[] signature;

    private SIGRecord() {
    }

    private SIGRecord(Name name, int dclass, long ttl) {
        super(name, 24, dclass, ttl);
    }

    static SIGRecord getMember() {
        return member;
    }

    public SIGRecord(Name name, int dclass, long ttl, int covered, int alg, int origttl, Date expire, Date timeSigned, int footprint, Name signer, byte[] signature) {
        this(name, dclass, ttl);
        Type.check(covered);
        Record.checkU8("alg", alg);
        Record.checkU8("labels", this.labels);
        TTL.check(origttl);
        Record.checkU16("footprint", footprint);
        this.covered = covered;
        this.alg = alg;
        this.labels = name.labels();
        this.origttl = origttl;
        this.expire = expire;
        this.timeSigned = timeSigned;
        this.footprint = footprint;
        if (!signer.isAbsolute()) {
            throw new RelativeNameException(signer);
        }
        this.signer = signer;
        this.signature = signature;
    }

    Record rrFromWire(Name name, int type, int dclass, long ttl, int length, DataByteInputStream in) throws IOException {
        SIGRecord rec = new SIGRecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        int start = in.getPos();
        rec.covered = in.readUnsignedShort();
        rec.alg = in.readByte();
        rec.labels = in.readByte();
        rec.origttl = in.readUnsignedInt();
        rec.expire = new Date(1000L * (long)in.readInt());
        rec.timeSigned = new Date(1000L * (long)in.readInt());
        rec.footprint = in.readShort();
        rec.signer = new Name(in);
        rec.signature = new byte[length - (in.getPos() - start)];
        in.read(rec.signature);
        return rec;
    }

    Record rdataFromString(Name name, int dclass, long ttl, Tokenizer st, Name origin) throws IOException {
        SIGRecord rec = new SIGRecord(name, dclass, ttl);
        String typeString = st.getString();
        int covered = Type.value(typeString);
        if (covered < 0) {
            throw st.exception("Invalid type: " + typeString);
        }
        rec.covered = covered;
        rec.alg = st.getUInt8();
        rec.labels = st.getUInt8();
        rec.origttl = st.getTTL();
        rec.expire = SIGRecord.parseDate(st.getString());
        rec.timeSigned = SIGRecord.parseDate(st.getString());
        rec.footprint = st.getUInt16();
        rec.signer = st.getName(origin);
        rec.signature = base64.fromString(Record.remainingStrings(st));
        return rec;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.signature != null) {
            sb.append(Type.string(this.covered));
            sb.append(" ");
            sb.append(this.alg);
            sb.append(" ");
            sb.append(this.labels);
            sb.append(" ");
            sb.append(this.origttl);
            sb.append(" ");
            if (Options.check("multiline")) {
                sb.append("(\n\t");
            }
            sb.append(SIGRecord.formatDate(this.expire));
            sb.append(" ");
            sb.append(SIGRecord.formatDate(this.timeSigned));
            sb.append(" ");
            sb.append(this.footprint);
            sb.append(" ");
            sb.append(this.signer);
            if (Options.check("multiline")) {
                sb.append("\n");
                sb.append(base64.formatString(this.signature, 64, "\t", true));
            } else {
                sb.append(" ");
                sb.append(base64.toString(this.signature));
            }
        }
        return sb.toString();
    }

    public int getTypeCovered() {
        return this.covered;
    }

    public int getAlgorithm() {
        return this.alg;
    }

    public int getLabels() {
        return this.labels;
    }

    public long getOrigTTL() {
        return this.origttl;
    }

    public Date getExpire() {
        return this.expire;
    }

    public Date getTimeSigned() {
        return this.timeSigned;
    }

    public int getFootprint() {
        return this.footprint;
    }

    public Name getSigner() {
        return this.signer;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.signature == null) {
            return;
        }
        out.writeUnsignedShort(this.covered);
        out.writeByte(this.alg);
        out.writeByte(this.labels);
        out.writeUnsignedInt(this.origttl);
        out.writeUnsignedInt(this.expire.getTime() / 1000L);
        out.writeUnsignedInt(this.timeSigned.getTime() / 1000L);
        out.writeShort(this.footprint);
        this.signer.toWire(out, null, canonical);
        out.writeArray(this.signature);
    }

    static String formatDate(Date d) {
        GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        StringBuffer sb = new StringBuffer();
        DecimalFormat w4 = new DecimalFormat();
        ((NumberFormat)w4).setMinimumIntegerDigits(4);
        ((NumberFormat)w4).setGroupingUsed(false);
        DecimalFormat w2 = new DecimalFormat();
        ((NumberFormat)w2).setMinimumIntegerDigits(2);
        c.setTime(d);
        sb.append(w4.format(c.get(1)));
        sb.append(w2.format(c.get(2) + 1));
        sb.append(w2.format(c.get(5)));
        sb.append(w2.format(c.get(11)));
        sb.append(w2.format(c.get(12)));
        sb.append(w2.format(c.get(13)));
        return sb.toString();
    }

    static Date parseDate(String s) {
        GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        int year = Integer.parseInt(s.substring(0, 4));
        int month = Integer.parseInt(s.substring(4, 6)) - 1;
        int date = Integer.parseInt(s.substring(6, 8));
        int hour = Integer.parseInt(s.substring(8, 10));
        int minute = Integer.parseInt(s.substring(10, 12));
        int second = Integer.parseInt(s.substring(12, 14));
        c.set(year, month, date, hour, minute, second);
        return c.getTime();
    }
}

