/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import org.xbill.DNS.utils.StringValueTable;

public final class Rcode {
    private static StringValueTable rcodes = new StringValueTable();
    private static StringValueTable tsigrcodes = new StringValueTable();
    public static final byte NOERROR = 0;
    public static final byte FORMERR = 1;
    public static final byte SERVFAIL = 2;
    public static final byte NXDOMAIN = 3;
    public static final byte NOTIMPL = 4;
    public static final byte REFUSED = 5;
    public static final byte YXDOMAIN = 6;
    public static final byte YXRRSET = 7;
    public static final byte NXRRSET = 8;
    public static final byte NOTAUTH = 9;
    public static final byte NOTZONE = 10;
    public static final byte BADVERS = 16;
    public static final byte BADSIG = 16;
    public static final byte BADKEY = 17;
    public static final byte BADTIME = 18;
    public static final byte BADMODE = 19;

    private Rcode() {
    }

    public static String string(int i) {
        String s = rcodes.getString(i);
        return s != null ? s : Integer.toString(i);
    }

    public static String TSIGstring(int i) {
        String s = tsigrcodes.getString(i);
        if (s != null) {
            return s;
        }
        s = rcodes.getString(i);
        return s != null ? s : Integer.toString(i);
    }

    public static byte value(String s) {
        byte i = (byte)rcodes.getValue(s.toUpperCase());
        if (i >= 0) {
            return i;
        }
        try {
            return Byte.parseByte(s);
        }
        catch (Exception e) {
            return -1;
        }
    }

    static {
        rcodes.put2(0, "NOERROR");
        rcodes.put2(1, "FORMERR");
        rcodes.put2(2, "SERVFAIL");
        rcodes.put2(3, "NXDOMAIN");
        rcodes.put2(4, "NOTIMPL");
        rcodes.put2(5, "REFUSED");
        rcodes.put2(6, "YXDOMAIN");
        rcodes.put2(7, "YXRRSET");
        rcodes.put2(8, "NXRRSET");
        rcodes.put2(9, "NOTAUTH");
        rcodes.put2(10, "NOTZONE");
        rcodes.put2(16, "BADVERS");
        tsigrcodes.put2(16, "BADSIG");
        tsigrcodes.put2(17, "BADKEY");
        tsigrcodes.put2(18, "BADTIME");
        tsigrcodes.put2(19, "BADMODE");
    }
}

