/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.xbill.DNS.Name;
import org.xbill.DNS.TypedObject;

class NameSet {
    private Map data;
    private Name origin;
    private boolean isCache;
    protected static Object NXRRSET = new Object();

    protected NameSet(boolean isCache, Map map) {
        this.data = map;
        this.origin = Name.root;
        this.isCache = isCache;
    }

    protected NameSet(boolean isCache) {
        this(isCache, new HashMap());
    }

    protected void setOrigin(Name origin) {
        this.origin = origin;
    }

    protected synchronized void clear() {
        this.data.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object lookupType(Object typelist, int type) {
        if (type == 255) {
            throw new IllegalArgumentException("type ANY passed to NameSet.lookupType()");
        }
        Object object = typelist;
        synchronized (object) {
            if (typelist instanceof LinkedList) {
                LinkedList list = (LinkedList)typelist;
                int i = 0;
                while (i < list.size()) {
                    TypedObject obj = (TypedObject)list.get(i);
                    if (obj.getType() == type) {
                        return obj;
                    }
                    ++i;
                }
                return null;
            }
            TypedObject obj = (TypedObject)typelist;
            if (obj.getType() == type) {
                return obj;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object[] lookupAll(Object typelist) {
        Object object = typelist;
        synchronized (object) {
            if (typelist instanceof LinkedList) {
                return ((LinkedList)typelist).toArray();
            }
            return new Object[]{typelist};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object lookup(Name name, int type) {
        int olabels;
        Object bestns = null;
        if (!name.subdomain(this.origin)) {
            return null;
        }
        byte labels = name.labels();
        int tlabels = olabels = this.origin.labels();
        while (tlabels <= labels) {
            Object typelist;
            boolean isexact;
            boolean isorigin = tlabels == olabels;
            boolean bl = isexact = tlabels == labels;
            Name tname = isorigin ? this.origin : (isexact ? name : new Name(name, labels - tlabels));
            NameSet nameSet = this;
            synchronized (nameSet) {
                typelist = this.data.get(tname);
            }
            if (typelist != null) {
                Object o;
                if (isexact && type == 255) {
                    return this.lookupAll(typelist);
                }
                if ((!isorigin || this.isCache) && (o = this.lookupType(typelist, 2)) != null) {
                    if (this.isCache) {
                        bestns = o;
                    } else {
                        return o;
                    }
                }
                if (isexact) {
                    o = this.lookupType(typelist, type);
                    if (o == null) {
                        o = this.lookupType(typelist, 5);
                    }
                    if (o != null) {
                        return o;
                    }
                } else {
                    o = this.lookupType(typelist, 39);
                    if (o != null) {
                        return o;
                    }
                }
                if (isexact && this.isCache && (o = this.lookupType(typelist, 0)) != null) {
                    return o;
                }
                if (isexact) {
                    return NXRRSET;
                }
            }
            ++tlabels;
        }
        return bestns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object findExactSet(Name name, int type) {
        Object typelist;
        NameSet nameSet = this;
        synchronized (nameSet) {
            typelist = this.data.get(name);
        }
        if (typelist == null) {
            return null;
        }
        return this.lookupType(typelist, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] findExactSets(Name name) {
        Object typelist;
        NameSet nameSet = this;
        synchronized (nameSet) {
            typelist = this.data.get(name);
        }
        if (typelist == null) {
            return new Object[0];
        }
        return this.lookupAll(typelist);
    }

    private Object findName(Name name) {
        return this.data.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSet(Name name, int type, TypedObject set) {
        Object typelist;
        NameSet nameSet = this;
        synchronized (nameSet) {
            typelist = this.data.get(name);
            if (typelist == null) {
                this.data.put(name, set);
                return;
            }
            if (!(typelist instanceof LinkedList)) {
                TypedObject obj = (TypedObject)typelist;
                if (obj.getType() == type) {
                    this.data.put(name, set);
                } else {
                    LinkedList<Object> list = new LinkedList<Object>();
                    list.add(typelist);
                    list.add(set);
                    this.data.put(name, list);
                }
                return;
            }
        }
        Object v = typelist;
        synchronized (v) {
            LinkedList list = (LinkedList)typelist;
            int i = 0;
            while (i < list.size()) {
                TypedObject obj = (TypedObject)list.get(i);
                if (obj.getType() == type) {
                    list.set(i, set);
                    return;
                }
                ++i;
            }
            list.add(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSet(Name name, int type, TypedObject set) {
        Object typelist;
        NameSet nameSet = this;
        synchronized (nameSet) {
            typelist = this.data.get(name);
            if (typelist == null) {
                return;
            }
            if (!(typelist instanceof LinkedList)) {
                if (typelist == set) {
                    this.data.remove(name);
                }
                return;
            }
        }
        Object v = typelist;
        synchronized (v) {
            LinkedList list = (LinkedList)typelist;
            int i = 0;
            while (i < list.size()) {
                if (list.get(i) == set) {
                    list.remove(i);
                    return;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeName(Name name) {
        NameSet nameSet = this;
        synchronized (nameSet) {
            this.data.remove(name);
        }
    }

    Iterator names() {
        return this.data.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        NameSet nameSet = this;
        synchronized (nameSet) {
            Iterator it = this.data.values().iterator();
            while (it.hasNext()) {
                Object typelist = it.next();
                Object[] elements = this.lookupAll(typelist);
                int i = 0;
                while (i < elements.length) {
                    sb.append(elements[i]);
                    sb.append("\n");
                    ++i;
                }
            }
        }
        return sb.toString();
    }
}

