/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import org.xbill.DNS.InvalidDClassException;

public final class DClass {
    public static final int IN = 1;
    public static final int CH = 3;
    public static final int CHAOS = 3;
    public static final int HS = 4;
    public static final int HESIOD = 4;
    public static final int NONE = 254;
    public static final int ANY = 255;
    private static Integer[] classcache = new Integer[5];

    private DClass() {
    }

    static void check(int i) {
        if (i < 0 || i > 65535) {
            throw new InvalidDClassException(i);
        }
    }

    public static String string(int i) {
        DClass.check(i);
        switch (i) {
            case 1: {
                return "IN";
            }
            case 3: {
                return "CH";
            }
            case 4: {
                return "HS";
            }
            case 254: {
                return "NONE";
            }
            case 255: {
                return "ANY";
            }
        }
        return "CLASS" + i;
    }

    public static int value(String s) {
        if ((s = s.toUpperCase()).equals("IN")) {
            return 1;
        }
        if (s.equals("CH") || s.equals("CHAOS")) {
            return 3;
        }
        if (s.equals("HS") || s.equals("HESIOS")) {
            return 4;
        }
        if (s.equals("NONE")) {
            return 254;
        }
        if (s.equals("ANY")) {
            return 255;
        }
        if (s.startsWith("CLASS")) {
            try {
                int dclass = Integer.parseInt(s.substring(5));
                if (dclass < 0 || dclass > 65535) {
                    return -1;
                }
                return dclass;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    static Integer toInteger(int dclass) {
        if (dclass >= 0 && dclass < classcache.length) {
            return classcache[dclass];
        }
        return new Integer(dclass);
    }

    static {
        int i = 0;
        while (i < classcache.length) {
            DClass.classcache[i] = new Integer(i);
            ++i;
        }
    }
}

