package org.jaxup.dom;

import java.io.IOException;
import java.io.Writer;

import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.jaxup.JaxupWriter;
import org.w3c.dom.Document;

/**
 *
 */
public class DOMWriter implements JaxupWriter
{
    public void write(Object doc, Writer output) throws IOException
    {
        OutputFormat format = new OutputFormat("xml", "ISO-8859-1", true);
        format.setIndenting(true);
        format.setIndent(2);
        format.setPreserveSpace(true);

        XMLSerializer serial = new XMLSerializer(output, format);
        serial.serialize((Document) doc);
    }

}
