// Copyright 2001-2003 Erwin Bolwidt. All rights reserved.
// See the file LICENSE.txt in this package for information about licensing.
package org.jaxup;

/** 
 * An exception directly related to an attempt to update an XML document.
 *
 * @author Erwin Bolwidt
 */
public class UpdateException extends Exception
{
    /**
     * The exception that caused the update to fail exceptionally. Or null
     * if the update failed due to an intrinsical reason.
     */
    private Throwable cause;

    public UpdateException(String message)
    {
        super(message);
        this.cause = null;
    }

    public UpdateException(String message, Throwable cause)
    {
        super(message);
        this.cause = cause;
    }

    public Throwable getCause()
    {
        return cause;
    }
}
