/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.stream;

import javax.realtime.MemoryArea;
import javolution.lang.Reusable;
import javolution.text.CharArray;
import javolution.text.Text;
import javolution.xml.sax.Attributes;
import javolution.xml.stream.NamespacesImpl;

final class AttributesImpl
implements Attributes,
Reusable {
    private CharArray[] _localNames = new CharArray[16];
    private CharArray[] _prefixes = new CharArray[16];
    private CharArray[] _qNames = new CharArray[16];
    private CharArray[] _values = new CharArray[16];
    private final NamespacesImpl _namespaces;
    private int _length;
    private static final CharArray CDATA = new CharArray("CDATA");

    public AttributesImpl(NamespacesImpl namespacesImpl) {
        this._namespaces = namespacesImpl;
    }

    public int getLength() {
        return this._length;
    }

    public CharArray getURI(int n) {
        return n >= 0 && n < this._length ? this._namespaces.getNamespaceURINullAllowed(this._prefixes[n]) : null;
    }

    public CharArray getLocalName(int n) {
        return n >= 0 && n < this._length ? this._localNames[n] : null;
    }

    public CharArray getPrefix(int n) {
        return n >= 0 && n < this._length ? this._prefixes[n] : null;
    }

    public CharArray getQName(int n) {
        return n >= 0 && n < this._length ? this._qNames[n] : null;
    }

    public CharArray getType(int n) {
        return n >= 0 && n < this._length ? CDATA : null;
    }

    public CharArray getValue(int n) {
        return n >= 0 && n < this._length ? this._values[n] : null;
    }

    public int getIndex(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null) {
            throw new IllegalArgumentException("null namespace URI is not allowed");
        }
        for (int i = 0; i < this._length; ++i) {
            CharArray charArray;
            if (!this._localNames[i].equals((Object)charSequence2) || (charArray = this._namespaces.getNamespaceURINullAllowed(this._prefixes[i])) == null || !charArray.equals((Object)charSequence)) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(CharSequence charSequence) {
        for (int i = 0; i < this._length; ++i) {
            if (!this._qNames[i].equals((Object)charSequence)) continue;
            return i;
        }
        return -1;
    }

    public CharArray getType(CharSequence charSequence, CharSequence charSequence2) {
        int n = this.getIndex(charSequence, charSequence2);
        return n >= 0 ? CDATA : null;
    }

    public CharArray getType(CharSequence charSequence) {
        int n = this.getIndex(charSequence);
        return n >= 0 ? CDATA : null;
    }

    public CharArray getValue(CharSequence charSequence, CharSequence charSequence2) {
        int n = this.getIndex(charSequence, charSequence2);
        return n >= 0 ? this._values[n] : null;
    }

    public CharArray getValue(CharSequence charSequence) {
        int n = this.getIndex(charSequence);
        return n >= 0 ? this._values[n] : null;
    }

    public void reset() {
        this._length = 0;
    }

    public void addAttribute(CharArray charArray, CharArray charArray2, CharArray charArray3, CharArray charArray4) {
        if (this._length >= this._localNames.length) {
            this.increaseCapacity();
        }
        this._localNames[this._length] = charArray;
        this._prefixes[this._length] = charArray2;
        this._qNames[this._length] = charArray3;
        this._values[this._length++] = charArray4;
    }

    public String toString() {
        Text text = Text.valueOf('[');
        Text text2 = Text.valueOf('=');
        Text text3 = Text.valueOf((Object)", ");
        int n = 0;
        while (n < this._length) {
            text = text.concat(Text.valueOf(this._qNames[n]).concat(text2).concat(Text.valueOf(this._values[n])));
            if (++n == this._length) continue;
            text = text.concat(text3);
        }
        return text.concat(Text.valueOf(']')).toString();
    }

    private void increaseCapacity() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                int n = AttributesImpl.this._length * 2;
                CharArray[] charArrayArray = new CharArray[n];
                System.arraycopy(AttributesImpl.this._localNames, 0, charArrayArray, 0, AttributesImpl.this._length);
                AttributesImpl.access$102(AttributesImpl.this, charArrayArray);
                charArrayArray = new CharArray[n];
                System.arraycopy(AttributesImpl.this._prefixes, 0, charArrayArray, 0, AttributesImpl.this._length);
                AttributesImpl.access$202(AttributesImpl.this, charArrayArray);
                charArrayArray = new CharArray[n];
                System.arraycopy(AttributesImpl.this._qNames, 0, charArrayArray, 0, AttributesImpl.this._length);
                AttributesImpl.access$302(AttributesImpl.this, charArrayArray);
                charArrayArray = new CharArray[n];
                System.arraycopy(AttributesImpl.this._values, 0, charArrayArray, 0, AttributesImpl.this._length);
                AttributesImpl.access$402(AttributesImpl.this, charArrayArray);
            }
        });
    }

    static /* synthetic */ CharArray[] access$102(AttributesImpl attributesImpl, CharArray[] charArrayArray) {
        attributesImpl._localNames = charArrayArray;
        return charArrayArray;
    }

    static /* synthetic */ CharArray[] access$202(AttributesImpl attributesImpl, CharArray[] charArrayArray) {
        attributesImpl._prefixes = charArrayArray;
        return charArrayArray;
    }

    static /* synthetic */ CharArray[] access$302(AttributesImpl attributesImpl, CharArray[] charArrayArray) {
        attributesImpl._qNames = charArrayArray;
        return charArrayArray;
    }

    static /* synthetic */ CharArray[] access$402(AttributesImpl attributesImpl, CharArray[] charArrayArray) {
        attributesImpl._values = charArrayArray;
        return charArrayArray;
    }
}

