/*
 * Decompiled with CFR 0.152.
 */
package javolution.io;

import java.io.IOException;
import java.io.Writer;
import javolution.lang.Reusable;
import javolution.text.Text;

public final class AppendableWriter
extends Writer
implements Reusable {
    private Appendable _output;
    private char[] _tmpBuffer;
    private final CharSequence _tmpBufferAsCharSequence = new CharSequence(){

        public int length() {
            return AppendableWriter.this._tmpBuffer.length;
        }

        public char charAt(int n) {
            return AppendableWriter.this._tmpBuffer[n];
        }

        public CharSequence subSequence(int n, int n2) {
            throw new UnsupportedOperationException();
        }
    };

    public AppendableWriter setOutput(Appendable appendable) {
        if (this._output != null) {
            throw new IllegalStateException("Writer not closed or reset");
        }
        this._output = appendable;
        return this;
    }

    public void write(char c) throws IOException {
        if (this._output == null) {
            throw new IOException("Writer closed");
        }
        this._output.append(c);
    }

    public void write(int n) throws IOException {
        if (this._output == null) {
            throw new IOException("Writer closed");
        }
        this._output.append((char)n);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this._output == null) {
            throw new IOException("Writer closed");
        }
        this._tmpBuffer = cArray;
        this._output.append(this._tmpBufferAsCharSequence, n, n + n2);
        this._tmpBuffer = null;
    }

    public void write(String string, int n, int n2) throws IOException {
        if (this._output == null) {
            throw new IOException("Writer closed");
        }
        String string2 = string;
        if (string2 instanceof CharSequence) {
            this._output.append(string2);
        } else {
            this._output.append(Text.valueOf((Object)string));
        }
    }

    public void write(CharSequence charSequence) throws IOException {
        if (this._output == null) {
            throw new IOException("Writer closed");
        }
        this._output.append(charSequence);
    }

    public void flush() {
    }

    public void close() {
        if (this._output != null) {
            this.reset();
        }
    }

    public void reset() {
        this._output = null;
        this._tmpBuffer = null;
    }
}

