/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.util;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import net.disy.commons.swing.util.GuiUtilities;

public abstract class RelativePosition {
    public static final RelativePosition CENTER;

    private RelativePosition() {
    }

    public final void place(Window window) {
        Window owner = window.getOwner();
        if (owner != null && owner.isVisible()) {
            window.setLocation(this.createLocation(window.getBounds(), window.getOwner().getBounds()));
            return;
        }
        GuiUtilities.centerOnScreen(window);
    }

    protected abstract Point createLocation(Rectangle var1, Rectangle var2);

    static {
        new RelativePosition(){

            protected final Point createLocation(Rectangle windowBounds, Rectangle ownerBounds) {
                return new Point(ownerBounds.x - windowBounds.width, ownerBounds.y);
            }
        };
        new RelativePosition(){

            protected final Point createLocation(Rectangle windowBounds, Rectangle ownerBounds) {
                return new Point((int)ownerBounds.getMaxX(), (int)(ownerBounds.getCenterY() - (double)(windowBounds.height / 2)));
            }
        };
        CENTER = new RelativePosition(){

            protected final Point createLocation(Rectangle windowBounds, Rectangle ownerBounds) {
                return new Point((int)(ownerBounds.getCenterX() - (double)(windowBounds.width / 2)), (int)(ownerBounds.getCenterY() - (double)(windowBounds.height / 2)));
            }
        };
    }
}

