/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.tree;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.disy.commons.core.model.listener.IListenerClosure;
import net.disy.commons.core.model.listener.ListenerList;
import net.disy.commons.swing.tree.ITreeNodeActionListener;

public final class SmartTree
extends JTree {
    private final ListenerList nodeActionListeners = new ListenerList();
    private int lastRowClickIndex = -1;

    public SmartTree(TreeNode rootNode) {
        super(rootNode);
        this.addMouseListener(new MouseAdapter(){

            public final void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    SmartTree.this.lastRowClickIndex = SmartTree.this.getRowForLocation(e.getX(), e.getY());
                }
                if (e.getClickCount() != 2 || e.isMetaDown()) {
                    return;
                }
                int rowIndex = SmartTree.this.getRowForLocation(e.getX(), e.getY());
                if (rowIndex == -1 || SmartTree.this.lastRowClickIndex != rowIndex) {
                    SmartTree.this.lastRowClickIndex = -1;
                    return;
                }
                SmartTree.this.lastRowClickIndex = -1;
                TreePath path = SmartTree.this.getPathForRow(rowIndex);
                SmartTree.this.fireNodeActionPerformed((TreeNode)path.getLastPathComponent());
            }
        });
    }

    public final void addNodeActionListener(ITreeNodeActionListener listener) {
        this.nodeActionListeners.add(listener);
    }

    public final void fireNodeActionPerformed(final TreeNode node) {
        this.nodeActionListeners.forAllDo(new IListenerClosure(){

            public final void execute(Object input) {
                ((ITreeNodeActionListener)input).nodeActionPerformed(SmartTree.this, node);
            }
        });
    }
}

