/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.layout.util;

import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public final class LayoutUtilities {
    private static final EmptyBorder DEFAULT_EMPTY_BORDER;

    public static final int getScreenResolution() {
        try {
            return Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (Exception exception) {
            return 96;
        }
    }

    public static final int getComponentSpacing() {
        return LayoutUtilities.getComponentSpacing(LayoutUtilities.getScreenResolution());
    }

    public static final int getComponentSpacing(int screenResolutionInDpi) {
        return LayoutUtilities.getDpiAdjusted(6, screenResolutionInDpi);
    }

    public static final int getDpiAdjusted(int pixels, int screenResolutionInDpi) {
        return pixels * screenResolutionInDpi / 96;
    }

    public static final int getDpiAdjusted(int pixels) {
        return pixels * LayoutUtilities.getScreenResolution() / 96;
    }

    public static final int getComponentGroupsSpacing() {
        return LayoutUtilities.getComponentGroupsSpacing(LayoutUtilities.getScreenResolution());
    }

    public static final int getComponentGroupsSpacing(int screenResolutionInDpi) {
        return LayoutUtilities.getDpiAdjusted(11, screenResolutionInDpi);
    }

    public static final Border getDefaultEmptyBorder() {
        return DEFAULT_EMPTY_BORDER;
    }

    static {
        new Dimension(22, 21);
        DEFAULT_EMPTY_BORDER = new EmptyBorder(LayoutUtilities.getDpiAdjusted(5), LayoutUtilities.getDpiAdjusted(6), LayoutUtilities.getDpiAdjusted(5), LayoutUtilities.getDpiAdjusted(6));
    }
}

