/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.fontchooser.view;

import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.fontchooser.resources.DisyCommonsSwingFontChooserMessages;
import net.disy.commons.swing.fontchooser.util.FontUtilities;
import net.disy.commons.swing.fontchooser.view.AbstractFontAdjustListPanel;
import net.disy.commons.swing.fontchooser.view.DefaultFontDialogProperties;

public final class FontSizePanel
extends AbstractFontAdjustListPanel {
    public FontSizePanel(FontModel fontModel, DefaultFontDialogProperties properties) {
        super(fontModel, properties);
    }

    protected final String getTitle() {
        return DisyCommonsSwingFontChooserMessages.getString("FontSizePanel.size");
    }

    protected final JList createListComponent() {
        return new JList<Integer>(FontUtilities.getStandardSizes());
    }

    protected final void updateFontModelView() {
        int fontSize = this.getFontModel().getFontSize();
        this.getTextField().setText(String.valueOf(fontSize));
        this.getList().setSelectedValue(new Integer(fontSize), true);
    }

    protected final void attachListListener() {
        this.getList().addListSelectionListener(new ListSelectionListener(){

            public final void valueChanged(ListSelectionEvent e) {
                Integer selectedValue = (Integer)FontSizePanel.this.getList().getSelectedValue();
                if (selectedValue == null) {
                    return;
                }
                int fontSize = selectedValue;
                if (FontUtilities.isValidFontSize(fontSize)) {
                    FontSizePanel.this.getFontModel().setFontSize(fontSize);
                    return;
                }
                FontSizePanel.this.rejectUserInput();
            }
        });
    }
}

