/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.fontchooser.model;

import java.awt.Font;
import net.disy.commons.core.graphics.font.FontDescription;
import net.disy.commons.core.graphics.font.FontStyle;
import net.disy.commons.core.model.AbstractChangeableModel;
import net.disy.commons.core.util.ObjectUtilities;
import net.disy.commons.swing.font.FontFactory;
import net.disy.commons.swing.fontchooser.util.FontUtilities;

public final class FontModel
extends AbstractChangeableModel {
    private FontDescription font;

    public FontModel() {
        this(FontUtilities.getDefaultFont());
    }

    public FontModel(Font font) {
        this.setFont(font);
    }

    public FontModel(FontDescription font) {
        this.setFont(font);
    }

    public final void setFont(Font font) {
        this.setFont(FontFactory.createFontDescription(font));
    }

    public final void setFont(FontDescription fontDescription) {
        this.font = fontDescription;
        this.fireChangeEvent();
    }

    public final String getFontFamilyName() {
        return this.font.getFontFamilyName();
    }

    public final int getFontSize() {
        return this.font.getFontSize();
    }

    public final FontStyle getFontStyle() {
        return this.font.getFontStyle();
    }

    public final void setFontFamilyName(String fontFamilyName) {
        if (ObjectUtilities.equals(this.font.getFontFamilyName(), fontFamilyName)) {
            return;
        }
        this.font.setFontFamilyName(fontFamilyName);
        this.fireChangeEvent();
    }

    public final void setFontSize(int fontSize) {
        if (!FontUtilities.isValidFontSize(fontSize)) {
            throw new IllegalArgumentException("Illegal value '" + fontSize + "' for font size. Valid values are " + 2 + ".." + 200);
        }
        if (this.font.getFontSize() == fontSize) {
            return;
        }
        this.font.setFontSize(fontSize);
        this.fireChangeEvent();
    }

    public final void setFontStyle(FontStyle fontStyle) {
        if (ObjectUtilities.equals(this.font.getFontStyle(), fontStyle)) {
            return;
        }
        this.font.setFontStyle(fontStyle);
        this.fireChangeEvent();
    }

    public final Font getFont() {
        return FontModel.createFont(this.font);
    }

    public final FontDescription getFontDescription() {
        return this.font;
    }

    public static final Font createFont(FontDescription fontDescription) {
        return FontFactory.createFont(fontDescription.getFontFamilyName(), fontDescription.getFontStyle(), fontDescription.getFontSize());
    }
}

