/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.filechooser.view;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.swing.component.AbstractActionComponent;
import net.disy.commons.swing.filechooser.view.FileTreeCellRenderer;
import net.disy.commons.swing.filechooser.view.FolderNode;
import net.disy.commons.swing.tree.ITreeNodeActionListener;
import net.disy.commons.swing.tree.SmartTree;

public final class FolderSelectionPanel
extends AbstractActionComponent {
    private SmartTree tree;
    private final JComponent content;
    private final FileSystemView fileSystemView;
    private final Map nodesByFile = new HashMap();
    private File[] roots;

    public FolderSelectionPanel(FileModel folderModel, FileSystemView fileSystemView) {
        this(folderModel, fileSystemView, fileSystemView.getRoots());
    }

    public FolderSelectionPanel(final FileModel folderModel, FileSystemView fileSystemView, File[] roots) {
        this.fileSystemView = fileSystemView;
        this.roots = roots;
        this.content = this.createDirectoryPanel();
        if (folderModel.getFile() != null) {
            this.setSelectedFolder(folderModel.getFile());
        }
        folderModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                FolderSelectionPanel.this.setSelectedFolder(folderModel.getFile());
            }
        });
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public final void valueChanged(TreeSelectionEvent e) {
                File selectedFolder = FolderSelectionPanel.this.getSelectedFolder();
                if (selectedFolder == null) {
                    return;
                }
                folderModel.setFile(selectedFolder);
            }
        });
    }

    private void setSelectedFolder(File file) {
        if (file == null || file.equals(this.getSelectedFolder())) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (file = file.getAbsoluteFile(); file != null; file = file.getParentFile()) {
            files.add(file);
            if (this.isRoot(file)) break;
        }
        this.reverseSelect(files, files.size() - 1);
    }

    private boolean isRoot(File file) {
        for (int index = 0; index < this.roots.length; ++index) {
            if (!this.roots[index].getAbsoluteFile().equals(file)) continue;
            return true;
        }
        return false;
    }

    private void reverseSelect(List files, int index) {
        FolderNode node = (FolderNode)this.nodesByFile.get(files.get(index));
        if (node == null) {
            return;
        }
        Object[] path = node.getPath();
        TreePath treePath = new TreePath(path);
        this.tree.expandPath(treePath);
        if (index > 0) {
            this.reverseSelect(files, index - 1);
            return;
        }
        this.tree.setSelectionPath(treePath);
        this.tree.scrollPathToVisible(treePath);
    }

    private JComponent createDirectoryPanel() {
        this.tree = new SmartTree(this.createRootNode());
        if (this.roots.length > 1) {
            this.tree.setRootVisible(false);
        }
        this.tree.setCellRenderer(new FileTreeCellRenderer(this.fileSystemView));
        this.tree.addNodeActionListener(new ITreeNodeActionListener(){

            public final void nodeActionPerformed(Component parentComponent, TreeNode node) {
                if (node.getChildCount() == 0) {
                    FolderSelectionPanel.this.fireActionEvent();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.tree);
        scrollPane.setPreferredSize(new Dimension(150, 250));
        return scrollPane;
    }

    private DefaultMutableTreeNode createRootNode() {
        DefaultMutableTreeNode root;
        if (this.roots.length == 1) {
            root = new FolderNode(this, this.roots[0]);
        } else {
            root = new DefaultMutableTreeNode("root");
            for (int i = 0; i < this.roots.length; ++i) {
                root.add(new FolderNode(this, this.roots[i]));
            }
        }
        return root;
    }

    private File getSelectedFolder() {
        FolderNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        return node.getFile();
    }

    private FolderNode getSelectedNode() {
        TreePath selectionPath = this.tree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        return (FolderNode)selectionPath.getLastPathComponent();
    }

    public final JComponent getContent() {
        return this.content;
    }

    public final FileSystemView getFileSystemView() {
        return this.fileSystemView;
    }

    public final void setBusy(boolean busy) {
        if (this.content == null) {
            return;
        }
        if (busy) {
            this.content.setCursor(Cursor.getPredefinedCursor(3));
            return;
        }
        this.content.setCursor(null);
    }

    public final void registerNode(File file, FolderNode node) {
        this.nodesByFile.put(file, node);
    }
}

