/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.wizard;

import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.BasicDialogUi;
import net.disy.commons.swing.dialog.core.AbstractDialog;
import net.disy.commons.swing.dialog.core.IDialogConstants;
import net.disy.commons.swing.dialog.core.ISwingFrameOrDialog;
import net.disy.commons.swing.dialog.wizard.IWizardConfiguration;
import net.disy.commons.swing.dialog.wizard.IWizardPage;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;
import net.disy.commons.swing.util.GuiUtilities;

public final class WizardDialog
extends AbstractDialog
implements IDialogConstants {
    private JButton finishButton;
    private JButton backButton;
    private JButton nextButton;
    private JButton helpButton;
    private IWizardPage currentPage;
    private IWizardConfiguration wizard;
    private final Collection pages = new HashSet();

    public WizardDialog(Component parent, IWizardConfiguration wizard) {
        super(parent, wizard);
        this.wizard = wizard;
        wizard.setContainer(this);
        wizard.addPages();
        this.initialize();
    }

    protected final Component createButtonBar() {
        SmartAction backAction = new SmartAction(BasicDialogUi.WIZARD_BACK_SMART){

            protected final void execute(Component parentComponent) {
                WizardDialog.this.backPressed();
            }
        };
        this.backButton = new JButton(backAction);
        SmartAction nextAction = new SmartAction(BasicDialogUi.WIZARD_NEXT_SMART){

            protected final void execute(Component parentComponent) {
                WizardDialog.this.nextPressed();
            }
        };
        this.nextButton = new JButton(nextAction);
        JPanel compactedButtons = new JPanel(new GridLayout(1, 0, 0, 0));
        compactedButtons.add(this.backButton);
        compactedButtons.add(this.nextButton);
        SmartAction finishAction = new SmartAction(this.getWizard().getOkButtonText()){

            protected final void execute(Component parentComponent) {
                WizardDialog.this.performFinish(parentComponent);
            }
        };
        this.finishButton = new JButton(finishAction);
        this.finishButton.setName("WizardDialog.FinishButton.ComponentName");
        SmartAction cancelAction = new SmartAction(this.getWizard().getCancelButtonText()){

            protected final void execute(Component parentComponent) {
                WizardDialog.this.performCancel();
            }
        };
        JButton cancelButton = new JButton(cancelAction);
        SmartAction helpAction = new SmartAction(BasicDialogUi.HELP_TEXT_SMART){

            protected final void execute(Component parentComponent) {
                WizardDialog.this.helpPressed();
            }
        };
        this.helpButton = new JButton(helpAction);
        ArrayList<JComponent> buttonList = new ArrayList<JComponent>();
        buttonList.add(compactedButtons);
        JButton[] additionalButtons = this.createAdditionalButtons();
        buttonList.addAll(Arrays.asList(additionalButtons));
        if (this.getWizard().isOkButtonAvailable()) {
            buttonList.add(this.finishButton);
        }
        if (this.getWizard().isCancelAvailable()) {
            buttonList.add(cancelButton);
        }
        if (this.getWizard().isHelpAvailable()) {
            buttonList.add(this.helpButton);
        }
        ButtonPanelBuilder buttonPanelBuilder = new ButtonPanelBuilder();
        for (int i = 0; i < buttonList.size(); ++i) {
            Component button = (Component)buttonList.get(i);
            buttonPanelBuilder.add(button);
        }
        return buttonPanelBuilder.createPanel();
    }

    private JButton[] createAdditionalButtons() {
        return new JButton[0];
    }

    protected final void backPressed() {
        this.showPage(this.getCurrentPage().getPreviousPage());
    }

    protected final boolean cancelPressed() {
        return this.getWizard().performCancel(this.getDialog().getWindow());
    }

    protected final boolean finishPressed(Component parentComponent) {
        this.getCurrentPage().getNextPage();
        return this.getWizard().performFinish(parentComponent);
    }

    protected final void helpPressed() {
        this.getCurrentPage().performHelp();
    }

    protected final void nextPressed() {
        this.showPage(this.getCurrentPage().getNextPage());
    }

    public final void showPage(IWizardPage page) {
        Ensure.ensureArgumentNotNull(page);
        this.currentPage = page;
        this.pages.add(page);
        this.updateContent();
        this.updateMessage();
        this.updateDescription();
        this.updateButtons();
        this.updateTitle();
        this.updateSize();
        this.currentPage.pageActivated();
        this.currentPage.requestFocus();
    }

    protected final void updateContent() {
        this.setContent(this.getCurrentPage().getContent());
    }

    public final IWizardPage getCurrentPage() {
        return this.currentPage;
    }

    public final void updateButtons() {
        IWizardPage page = this.getCurrentPage();
        this.nextButton.setEnabled(page.canFlipToNextPage());
        this.backButton.setEnabled(page.getPreviousPage() != null);
        this.finishButton.setEnabled(this.getWizard().canFinish());
        this.helpButton.setVisible(this.getWizard().isHelpAvailable());
        this.helpButton.setEnabled(page.isHelpAvailable());
        if (this.finishButton.isEnabled()) {
            this.setDefaultButton(this.finishButton);
            return;
        }
        this.setDefaultButton(this.nextButton);
    }

    public final void updateMessage() {
        this.setMessage(this.getCurrentPage().getMessage());
    }

    public final void updateDescription() {
        this.setDescription(this.getCurrentPage().getDescription());
    }

    public final void updateTitle() {
        this.setTitle(this.getCurrentPage().getTitle());
    }

    public final void show() {
        ISwingFrameOrDialog configuredDialog = this.getConfiguredDialog();
        GuiUtilities.centerToParent(configuredDialog.getWindow());
        configuredDialog.show();
    }

    public final ISwingFrameOrDialog getConfiguredDialog() {
        IWizardPage startingPage = this.getWizard().getStartingPage();
        if (startingPage == null) {
            throw new RuntimeException("Starting page may not be null in IWizard.getStartingPage()");
        }
        this.showPage(startingPage);
        ISwingFrameOrDialog configuredDialog = this.getDialog();
        if (configuredDialog == null) {
            throw new IllegalStateException("WizardDialog is already disposed and may not be shown more often than once");
        }
        if (configuredDialog.isVisible()) {
            throw new IllegalStateException("WizardDialog is already visible");
        }
        return configuredDialog;
    }

    protected final IWizardConfiguration getWizard() {
        return this.wizard;
    }

    private final void performFinish(Component parentComponent) {
        if (this.finishPressed(parentComponent)) {
            this.closeDialog();
        }
    }

    public final void requestNext() {
        if (!this.getCurrentPage().canFlipToNextPage()) {
            return;
        }
        this.nextPressed();
    }

    protected final void closeDialog() {
        super.closeDialog();
        Iterator iter = this.pages.iterator();
        while (iter.hasNext()) {
            iter.next();
        }
    }
}

