/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.userdialog;

import javax.swing.JComponent;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.core.util.ObjectUtilities;
import net.disy.commons.swing.dialog.userdialog.IDialogPage;
import net.disy.commons.swing.dialog.userdialog.UserDialog;
import net.disy.commons.swing.events.CheckInputValidListener;
import net.disy.commons.swing.events.IInputValidCheckable;

public final class DialogPageControl
implements IInputValidCheckable {
    private UserDialog userDialog;
    private JComponent content;
    private boolean canFinish;
    private final IDialogPage dialogPage;
    private IBasicMessage message;

    public DialogPageControl(IDialogPage dialogPage) {
        this.dialogPage = dialogPage;
        this.setMessage(dialogPage.getDefaultMessage());
        dialogPage.setInputValidListener(new CheckInputValidListener(this));
    }

    public final boolean canFinish() {
        return this.canFinish;
    }

    protected final void setMessage(IBasicMessage message) {
        Ensure.ensureArgumentNotNull(message);
        if (ObjectUtilities.equals(this.message, message)) {
            this.updateCanFinish();
            return;
        }
        this.message = message;
        this.updateCanFinish();
        UserDialog dialog = this.userDialog;
        if (dialog != null) {
            dialog.updateMessage();
        }
    }

    private void updateCanFinish() {
        UserDialog dialog = this.userDialog;
        if (dialog != null) {
            this.canFinish = !this.message.isErrorMessage();
            this.updateButtons();
        }
    }

    public final IBasicMessage getMessage() {
        return this.message;
    }

    public final void setUserDialogContainer(UserDialog userDialog) {
        this.userDialog = userDialog;
    }

    public final JComponent getContent() {
        if (this.content == null) {
            this.content = this.dialogPage.createContent();
            this.canFinish = !this.dialogPage.createCurrentMessage().isErrorMessage();
            this.updateButtons();
        }
        return this.content;
    }

    protected final void updateButtons() {
        if (this.userDialog != null) {
            this.userDialog.updateButtons();
        }
    }

    public final boolean performOk() {
        return this.dialogPage.performOk();
    }

    public final boolean performCancel() {
        return this.dialogPage.performCancel();
    }

    public final String getDescription() {
        return this.dialogPage.getDescription();
    }

    public final void checkInputValid() {
        this.setMessage(this.dialogPage.createCurrentMessage());
    }

    public final String getTitle() {
        return this.dialogPage.getTitle();
    }

    public final void requestFocus() {
        this.dialogPage.requestFocus();
    }

    public final boolean isHelpAvailable() {
        return this.dialogPage.isHelpAvailable();
    }

    public final void performHelp() {
        this.dialogPage.performHelp();
    }
}

