/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.userdialog;

import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.dialog.userdialog.IDialogPage;
import net.disy.commons.swing.events.CheckInputValidListener;

public abstract class AbstractDialogPage
implements IDialogPage {
    private final IBasicMessage defaultMessage;
    private CheckInputValidListener inputValidListener;

    public AbstractDialogPage(IBasicMessage defaultMessage) {
        Ensure.ensureArgumentNotNull("DefaultMessage must not be null.", defaultMessage);
        this.defaultMessage = defaultMessage;
    }

    public final IBasicMessage getDefaultMessage() {
        return this.defaultMessage;
    }

    public final void setInputValidListener(CheckInputValidListener inputValidListener) {
        this.inputValidListener = inputValidListener;
    }

    public final void performHelp() {
        throw new UnsupportedOperationException();
    }

    public final boolean performOk() {
        return true;
    }

    public final boolean performCancel() {
        return true;
    }

    public String getDescription() {
        return this.getTitle();
    }

    public final boolean isHelpAvailable() {
        return false;
    }

    public void requestFocus() {
    }

    protected final CheckInputValidListener getCheckInputValidListener() {
        Ensure.ensureNotNull("CheckInputValidListener not yet set.", this.inputValidListener);
        return this.inputValidListener;
    }
}

