/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.progress;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import net.disy.commons.core.progress.DefaultRunnableExecuter;
import net.disy.commons.core.progress.IRunnableWithProgress;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.dialog.progress.InternalProgressDialog;
import net.disy.commons.swing.dialog.progress.InternalProgressDialogModel;

public final class ProgressMonitorDialog {
    private boolean first = true;
    private final InternalProgressDialog progressDialog;
    private final InternalProgressDialogModel model = new InternalProgressDialogModel();
    private int millisecondsUntilDialogPopup = 500;
    private static DefaultRunnableExecuter defaultExecuter = new DefaultRunnableExecuter("runWithProgress");

    public ProgressMonitorDialog(Component parentComponent, String title) {
        this.progressDialog = new InternalProgressDialog(parentComponent, title, this.model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(boolean cancelable, final IRunnableWithProgress runnable) throws InterruptedException, InvocationTargetException {
        Ensure.ensureArgumentNotNull(runnable);
        ProgressMonitorDialog progressMonitorDialog = this;
        synchronized (progressMonitorDialog) {
            if (!this.first) {
                throw new IllegalStateException("Progress monitor dialog can only be run once.");
            }
            this.first = false;
        }
        this.progressDialog.setCancelable(cancelable);
        Runnable actualRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void run() {
                try {
                    try {
                        runnable.run(ProgressMonitorDialog.this.progressDialog);
                    }
                    catch (InterruptedException e) {
                        ProgressMonitorDialog.this.model.interrupted(e);
                        Object var3_2 = null;
                        InternalProgressDialogModel internalProgressDialogModel2 = ProgressMonitorDialog.this.model;
                        synchronized (internalProgressDialogModel2) {
                            ProgressMonitorDialog.this.model.finished();
                            ProgressMonitorDialog.this.model.notifyAll();
                        }
                        ProgressMonitorDialog.this.progressDialog.dispose();
                        return;
                    }
                    catch (InvocationTargetException e) {
                        ProgressMonitorDialog.this.model.crashed(e);
                        Object var3_3 = null;
                        InternalProgressDialogModel internalProgressDialogModel3 = ProgressMonitorDialog.this.model;
                        synchronized (internalProgressDialogModel3) {
                            ProgressMonitorDialog.this.model.finished();
                            ProgressMonitorDialog.this.model.notifyAll();
                        }
                        ProgressMonitorDialog.this.progressDialog.dispose();
                        return;
                    }
                    catch (Throwable e) {
                        ProgressMonitorDialog.this.model.crashed(new InvocationTargetException(e));
                        Object var3_4 = null;
                        InternalProgressDialogModel internalProgressDialogModel4 = ProgressMonitorDialog.this.model;
                        synchronized (internalProgressDialogModel4) {
                            ProgressMonitorDialog.this.model.finished();
                            ProgressMonitorDialog.this.model.notifyAll();
                        }
                        ProgressMonitorDialog.this.progressDialog.dispose();
                        return;
                    }
                    Object var3_1 = null;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    InternalProgressDialogModel internalProgressDialogModel = ProgressMonitorDialog.this.model;
                    synchronized (internalProgressDialogModel) {
                        ProgressMonitorDialog.this.model.finished();
                        ProgressMonitorDialog.this.model.notifyAll();
                    }
                    ProgressMonitorDialog.this.progressDialog.dispose();
                    throw throwable;
                }
                InternalProgressDialogModel internalProgressDialogModel = ProgressMonitorDialog.this.model;
                synchronized (internalProgressDialogModel) {
                    ProgressMonitorDialog.this.model.finished();
                    ProgressMonitorDialog.this.model.notifyAll();
                }
                ProgressMonitorDialog.this.progressDialog.dispose();
            }
        };
        defaultExecuter.execute(actualRunnable);
        InternalProgressDialogModel internalProgressDialogModel = this.model;
        synchronized (internalProgressDialogModel) {
            if (!this.model.isFinished()) {
                this.model.wait(this.millisecondsUntilDialogPopup);
            }
        }
        if (!this.model.isFinished()) {
            this.progressDialog.show();
        }
        if (this.model.getInterruptedException() != null) {
            throw this.model.getInterruptedException();
        }
        if (this.model.getInvocationTargetException() != null) {
            throw this.model.getInvocationTargetException();
        }
    }
}

