/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.input.text;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.disy.commons.core.message.BasicMessage;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.swing.dialog.input.text.ITextInputDialogConfiguration;
import net.disy.commons.swing.dialog.userdialog.AbstractDialogPage;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;

public final class TextInputDialogPage
extends AbstractDialogPage {
    private final ITextInputDialogConfiguration configuration;
    private JTextField textField;

    public TextInputDialogPage(ITextInputDialogConfiguration configuration, String initialText) {
        super(new BasicMessage(configuration.getDefaultMessageText()));
        this.configuration = configuration;
        this.textField = new JTextField(initialText);
    }

    public final String getTitle() {
        return this.configuration.getTitle();
    }

    public final IBasicMessage createCurrentMessage() {
        IBasicMessage currentMessage = this.configuration.createCurrentMessage(this.getSelectedText());
        if (currentMessage != null) {
            return currentMessage;
        }
        return this.getDefaultMessage();
    }

    public final JComponent createContent() {
        JPanel panel = new JPanel(new GridDialogLayout(2, false));
        panel.add(new JLabel(this.configuration.getLabelText()));
        panel.add((Component)this.textField, GridDialogLayoutData.FILL_HORIZONTAL);
        this.textField.selectAll();
        this.textField.getDocument().addDocumentListener(this.getCheckInputValidListener());
        return panel;
    }

    public final void requestFocus() {
        this.textField.requestFocus();
    }

    public final String getSelectedText() {
        return this.textField.getText();
    }
}

