/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.color.widgets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import net.disy.commons.swing.color.widgets.AbstractColorChoosingComponent;
import net.disy.commons.swing.color.widgets.ColorModel;
import net.disy.commons.swing.layout.util.LayoutUtilities;
import net.disy.commons.swing.resources.DisyCommonsSwingMessages;

public final class ColorChooserButton
extends AbstractColorChoosingComponent {
    public ColorChooserButton() {
        this(new ColorModel());
    }

    public ColorChooserButton(ColorModel model) {
        super(model);
    }

    protected final JComponent createContent() {
        JButton button = this.createButton();
        button.setOpaque(false);
        button.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                ColorChooserButton.this.performColorChooseDialog();
            }
        });
        button.setToolTipText(this.getTooltipText());
        return button;
    }

    private String getTooltipText() {
        return DisyCommonsSwingMessages.getString("ColorChooseButton.ToolTip");
    }

    private JButton createButton() {
        JButton button = new JButton();
        Icon icon = this.createIcon(button);
        button.setIcon(icon);
        int twoPixels = LayoutUtilities.getDpiAdjusted(2);
        button.setMargin(new Insets(twoPixels, twoPixels, twoPixels, twoPixels));
        return button;
    }

    private Icon createIcon(final JButton button) {
        return new Icon(){

            public final int getIconHeight() {
                return 13;
            }

            public final int getIconWidth() {
                return 49;
            }

            public final void paintIcon(Component c, Graphics g, int x, int y) {
                ColorChooserButton.this.paintColorRectangle(g, x, y, new Dimension(this.getIconWidth(), this.getIconHeight()), button.isEnabled());
            }
        };
    }
}

