/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.action;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import net.disy.commons.swing.util.GuiUtilities;

public abstract class SmartAction
extends AbstractAction
implements Action {
    private Component explicitParentComponent;
    private Icon icon;
    private Icon disabledIcon;

    public SmartAction() {
        this(null, null);
    }

    public SmartAction(String name) {
        this(name, null);
    }

    public SmartAction(String name, Icon icon) {
        if (name != null) {
            this.setName(name);
        }
        this.setIcon(icon);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public final void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    SmartAction.this.updateIcon();
                }
            }
        });
    }

    public SmartAction(Icon icon) {
        this(null, icon);
    }

    public final void setName(String name) {
        int index = -1;
        boolean found = false;
        do {
            ++index;
            if ((index = name.indexOf(38, index)) == -1 || index + 1 >= name.length()) continue;
            if (name.charAt(index + 1) == '&') {
                name = name.substring(0, index) + name.substring(index + 1);
                continue;
            }
            found = true;
            break;
        } while (index != -1 && index + 1 < name.length());
        if (found) {
            char mnemonic = name.charAt(index + 1);
            this.setMnemonic(mnemonic);
            name = name.substring(0, index) + name.substring(index + 1);
        }
        this.putValue("Name", name);
    }

    public final void actionPerformed(ActionEvent e) {
        Component parentComponent = this.explicitParentComponent == null ? GuiUtilities.getWindowForComponent(e) : this.explicitParentComponent;
        this.execute(parentComponent);
    }

    protected abstract void execute(Component var1);

    public final void setMnemonic(int keyCode) {
        this.putValue("MnemonicKey", new Integer(keyCode));
    }

    public final void setMnemonic(char character) {
        char ch = Character.toUpperCase(character);
        if (!SmartAction.isLetter(ch) && !SmartAction.isDigit(ch)) {
            throw new IllegalArgumentException("Unsupported mnemonic character'" + character + "'.");
        }
        this.setMnemonic((int)ch);
    }

    public final void setAcceleratorKey(KeyStroke keyStroke) {
        this.putValue("AcceleratorKey", keyStroke);
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static boolean isLetter(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    public final String getName() {
        return (String)this.getValue("Name");
    }

    public final void setIcon(Icon icon) {
        this.icon = icon;
        this.updateIcon();
    }

    private void updateIcon() {
        if (!this.isEnabled()) {
            if (this.disabledIcon != null) {
                this.putValue("SmallIcon", this.disabledIcon);
                return;
            }
            this.putValue("SmallIcon", this.icon);
            return;
        }
        if (this.icon != null) {
            this.putValue("SmallIcon", this.icon);
        }
    }

    public final void setDisabledIcon(Icon disabledIcon) {
        if (disabledIcon instanceof ImageIcon) {
            disabledIcon = new ProxyIcon(disabledIcon);
        }
        this.disabledIcon = disabledIcon;
        this.updateIcon();
    }

    public final void setToolTipText(String shortDescription) {
        this.putValue("ShortDescription", shortDescription);
    }

    private static final class ProxyIcon
    implements Icon {
        private final Icon icon;

        public ProxyIcon(Icon icon) {
            this.icon = icon;
        }

        public final void paintIcon(Component c, Graphics g, int x, int y) {
            this.icon.paintIcon(c, g, x, y);
        }

        public final int getIconWidth() {
            return this.icon.getIconWidth();
        }

        public final int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }
}

