/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.model;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.exception.UnreachableCodeReachedException;
import net.disy.commons.core.model.IChangeableModel;
import net.disy.commons.core.model.listener.IListenerClosure;
import net.disy.commons.core.model.listener.ListenerList;

public abstract class AbstractChangeableModel
implements Cloneable,
IChangeableModel {
    private transient ListenerList listeners = new ListenerList();

    protected final Object clone() {
        try {
            AbstractChangeableModel clone = (AbstractChangeableModel)super.clone();
            ((AbstractChangeableModel)super.clone()).listeners = new ListenerList();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new UnreachableCodeReachedException(e);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected final void fireChangeEvent() {
        final ChangeEvent event = new ChangeEvent(this);
        this.listeners.forAllDo(new IListenerClosure(this){

            public final void execute(Object input) {
                ChangeListener listener = (ChangeListener)input;
                listener.stateChanged(event);
            }
        });
    }
}

