/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.misc;

import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.IBrowserLaunching;
import edu.stanford.ejalbert.launching.misc.StandardUnixBrowser;
import edu.stanford.ejalbert.launching.misc.UnixBrowser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class UnixNetscapeBrowserLaunching
implements IBrowserLaunching {
    private List unixBrowsers = new ArrayList(3);

    public final void initialize() throws BrowserLaunchingInitializingException {
        ArrayList<StandardUnixBrowser> potentialBrowsers = new ArrayList<StandardUnixBrowser>(3);
        potentialBrowsers.add(StandardUnixBrowser.FIREFOX);
        potentialBrowsers.add(StandardUnixBrowser.MOZILLA);
        potentialBrowsers.add(StandardUnixBrowser.NETSCAPE);
        Iterator iter = potentialBrowsers.iterator();
        while (iter.hasNext()) {
            UnixBrowser browser = (UnixBrowser)iter.next();
            if (!browser.isBrowserAvailable()) continue;
            this.unixBrowsers.add(browser);
        }
        this.unixBrowsers = Collections.unmodifiableList(this.unixBrowsers);
    }

    public final void openUrl(String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        try {
            boolean success = false;
            Iterator iter = this.unixBrowsers.iterator();
            while (iter.hasNext() && !success) {
                UnixBrowser browser = (UnixBrowser)iter.next();
                Process process = Runtime.getRuntime().exec(browser.getArgsForOpenBrowser(urlString));
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    process = Runtime.getRuntime().exec(browser.getArgsForStartingBrowser(urlString));
                    exitCode = process.waitFor();
                }
                success = exitCode == 0;
            }
            return;
        }
        catch (Exception e) {
            throw new BrowserLaunchingExecutionException(e);
        }
    }
}

