/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.misc;

import edu.stanford.ejalbert.launching.misc.UnixBrowser;
import java.io.IOException;

final class StandardUnixBrowser
implements UnixBrowser {
    private String browserName;
    private String browserArgName;
    static StandardUnixBrowser NETSCAPE = new StandardUnixBrowser("Netscape", "netscape");
    static StandardUnixBrowser MOZILLA = new StandardUnixBrowser("Mozilla", "mozilla");
    static StandardUnixBrowser FIREFOX = new StandardUnixBrowser("FireFox", "firefox");

    private StandardUnixBrowser(String browserName, String browserArgName) {
        this.browserArgName = browserArgName;
        this.browserName = browserName;
    }

    public final String toString() {
        return this.browserName;
    }

    public final String[] getArgsForOpenBrowser(String urlString) {
        return new String[]{this.browserArgName, "-remote", "openURL(" + urlString + ")"};
    }

    public final String[] getArgsForStartingBrowser(String urlString) {
        return new String[]{this.browserArgName, urlString};
    }

    public final boolean isBrowserAvailable() {
        boolean isAvailable = false;
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"which", this.browserArgName});
            int exitCode = process.waitFor();
            isAvailable = exitCode == 0;
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {}
        return isAvailable;
    }
}

